#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.sketcher_interfaces.geometry2_d import Geometry2D


class Point2D(Geometry2D):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SketcherInterfaces.GeometricElement
                |                         SketcherInterfaces.Geometry2D
                |                             Point2D
                | 
                | Class defining a point in 2D Space.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.point2_d = com_object

    def get_coordinates(self, o_point):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub GetCoordinates(CATSafeArrayVariant oPoint)
                | 
                |     Returns the coordinates of the point
                | 
                |     Parameters:
                | 
                |         oPoint[0]
                |             The X Coordinate of the point 
                |         oPoint[1]
                |             The Y Coordinate of the point

        :param tuple o_point:
        :return: None
        """
        return self.point2_d.GetCoordinates(o_point)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_coordinates'
        # # vba_code = """
        # # Public Function get_coordinates(point2_d)
        # #     Dim oPoint (2)
        # #     point2_d.GetCoordinates oPoint
        # #     get_coordinates = oPoint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_data(self, i_x, i_y):
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetData(double iX,
                | double iY)
                | 
                |     Modifies the coordinates of the point
                | 
                |     Parameters:
                | 
                |         iX
                |             The X Coordinate of the point 
                |         iY
                |             The Y Coordinate of the point

        :param float i_x:
        :param float i_y:
        :return: None
        """
        return self.point2_d.SetData(i_x, i_y)

    def __repr__(self):
        return f'Point2D(name="{self.name}")'
