# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.compute_fleet_status import ComputeFleetStatus


class UpdateComputeFleetResponseContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, status=None, last_status_updated_time=None):
        """UpdateComputeFleetResponseContent - a model defined in OpenAPI

        :param status: The status of this UpdateComputeFleetResponseContent.
        :type status: ComputeFleetStatus
        :param last_status_updated_time: The last_status_updated_time of this UpdateComputeFleetResponseContent.
        :type last_status_updated_time: datetime
        """
        self.openapi_types = {"status": ComputeFleetStatus, "last_status_updated_time": datetime}

        self.attribute_map = {"status": "status", "last_status_updated_time": "lastStatusUpdatedTime"}

        self._status = status
        self._last_status_updated_time = last_status_updated_time

    @classmethod
    def from_dict(cls, dikt) -> "UpdateComputeFleetResponseContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The UpdateComputeFleetResponseContent of this UpdateComputeFleetResponseContent.
        :rtype: UpdateComputeFleetResponseContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def status(self):
        """Gets the status of this UpdateComputeFleetResponseContent.


        :return: The status of this UpdateComputeFleetResponseContent.
        :rtype: ComputeFleetStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this UpdateComputeFleetResponseContent.


        :param status: The status of this UpdateComputeFleetResponseContent.
        :type status: ComputeFleetStatus
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")

        self._status = status

    @property
    def last_status_updated_time(self):
        """Gets the last_status_updated_time of this UpdateComputeFleetResponseContent.

        Timestamp representing the last status update time.

        :return: The last_status_updated_time of this UpdateComputeFleetResponseContent.
        :rtype: datetime
        """
        return self._last_status_updated_time

    @last_status_updated_time.setter
    def last_status_updated_time(self, last_status_updated_time):
        """Sets the last_status_updated_time of this UpdateComputeFleetResponseContent.

        Timestamp representing the last status update time.

        :param last_status_updated_time: The last_status_updated_time of this UpdateComputeFleetResponseContent.
        :type last_status_updated_time: datetime
        """
        if last_status_updated_time is None:
            raise ValueError("Invalid value for `last_status_updated_time`, must not be `None`")

        self._last_status_updated_time = last_status_updated_time
