# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model


class UpdateClusterRequestContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, cluster_configuration=None):
        """UpdateClusterRequestContent - a model defined in OpenAPI

        :param cluster_configuration: The cluster_configuration of this UpdateClusterRequestContent.
        :type cluster_configuration: str
        """
        self.openapi_types = {"cluster_configuration": str}

        self.attribute_map = {"cluster_configuration": "clusterConfiguration"}

        self._cluster_configuration = cluster_configuration

    @classmethod
    def from_dict(cls, dikt) -> "UpdateClusterRequestContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The UpdateClusterRequestContent of this UpdateClusterRequestContent.
        :rtype: UpdateClusterRequestContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def cluster_configuration(self):
        """Gets the cluster_configuration of this UpdateClusterRequestContent.

        Cluster configuration as a YAML document

        :return: The cluster_configuration of this UpdateClusterRequestContent.
        :rtype: str
        """
        return self._cluster_configuration

    @cluster_configuration.setter
    def cluster_configuration(self, cluster_configuration):
        """Sets the cluster_configuration of this UpdateClusterRequestContent.

        Cluster configuration as a YAML document

        :param cluster_configuration: The cluster_configuration of this UpdateClusterRequestContent.
        :type cluster_configuration: str
        """
        if cluster_configuration is None:
            raise ValueError("Invalid value for `cluster_configuration`, must not be `None`")

        self._cluster_configuration = cluster_configuration
