# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.cloud_formation_resource_status import CloudFormationResourceStatus


class StackEvent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(
        self,
        event_id=None,
        physical_resource_id=None,
        resource_status=None,
        resource_status_reason=None,
        client_request_token=None,
        resource_properties=None,
        stack_id=None,
        stack_name=None,
        logical_resource_id=None,
        resource_type=None,
        timestamp=None,
    ):
        """StackEvent - a model defined in OpenAPI

        :param event_id: The event_id of this StackEvent.
        :type event_id: str
        :param physical_resource_id: The physical_resource_id of this StackEvent.
        :type physical_resource_id: str
        :param resource_status: The resource_status of this StackEvent.
        :type resource_status: CloudFormationResourceStatus
        :param resource_status_reason: The resource_status_reason of this StackEvent.
        :type resource_status_reason: str
        :param client_request_token: The client_request_token of this StackEvent.
        :type client_request_token: str
        :param resource_properties: The resource_properties of this StackEvent.
        :type resource_properties: str
        :param stack_id: The stack_id of this StackEvent.
        :type stack_id: str
        :param stack_name: The stack_name of this StackEvent.
        :type stack_name: str
        :param logical_resource_id: The logical_resource_id of this StackEvent.
        :type logical_resource_id: str
        :param resource_type: The resource_type of this StackEvent.
        :type resource_type: str
        :param timestamp: The timestamp of this StackEvent.
        :type timestamp: datetime
        """
        self.openapi_types = {
            "event_id": str,
            "physical_resource_id": str,
            "resource_status": CloudFormationResourceStatus,
            "resource_status_reason": str,
            "client_request_token": str,
            "resource_properties": str,
            "stack_id": str,
            "stack_name": str,
            "logical_resource_id": str,
            "resource_type": str,
            "timestamp": datetime,
        }

        self.attribute_map = {
            "event_id": "eventId",
            "physical_resource_id": "physicalResourceId",
            "resource_status": "resourceStatus",
            "resource_status_reason": "resourceStatusReason",
            "client_request_token": "clientRequestToken",
            "resource_properties": "resourceProperties",
            "stack_id": "stackId",
            "stack_name": "stackName",
            "logical_resource_id": "logicalResourceId",
            "resource_type": "resourceType",
            "timestamp": "timestamp",
        }

        self._event_id = event_id
        self._physical_resource_id = physical_resource_id
        self._resource_status = resource_status
        self._resource_status_reason = resource_status_reason
        self._client_request_token = client_request_token
        self._resource_properties = resource_properties
        self._stack_id = stack_id
        self._stack_name = stack_name
        self._logical_resource_id = logical_resource_id
        self._resource_type = resource_type
        self._timestamp = timestamp

    @classmethod
    def from_dict(cls, dikt) -> "StackEvent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The StackEvent of this StackEvent.
        :rtype: StackEvent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def event_id(self):
        """Gets the event_id of this StackEvent.

        The unique ID of this event.

        :return: The event_id of this StackEvent.
        :rtype: str
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """Sets the event_id of this StackEvent.

        The unique ID of this event.

        :param event_id: The event_id of this StackEvent.
        :type event_id: str
        """
        if event_id is None:
            raise ValueError("Invalid value for `event_id`, must not be `None`")

        self._event_id = event_id

    @property
    def physical_resource_id(self):
        """Gets the physical_resource_id of this StackEvent.

        The name or unique identifier associated with the physical instance of the resource.

        :return: The physical_resource_id of this StackEvent.
        :rtype: str
        """
        return self._physical_resource_id

    @physical_resource_id.setter
    def physical_resource_id(self, physical_resource_id):
        """Sets the physical_resource_id of this StackEvent.

        The name or unique identifier associated with the physical instance of the resource.

        :param physical_resource_id: The physical_resource_id of this StackEvent.
        :type physical_resource_id: str
        """
        if physical_resource_id is None:
            raise ValueError("Invalid value for `physical_resource_id`, must not be `None`")

        self._physical_resource_id = physical_resource_id

    @property
    def resource_status(self):
        """Gets the resource_status of this StackEvent.


        :return: The resource_status of this StackEvent.
        :rtype: CloudFormationResourceStatus
        """
        return self._resource_status

    @resource_status.setter
    def resource_status(self, resource_status):
        """Sets the resource_status of this StackEvent.


        :param resource_status: The resource_status of this StackEvent.
        :type resource_status: CloudFormationResourceStatus
        """
        if resource_status is None:
            raise ValueError("Invalid value for `resource_status`, must not be `None`")

        self._resource_status = resource_status

    @property
    def resource_status_reason(self):
        """Gets the resource_status_reason of this StackEvent.

        Success/failure message associated with the resource.

        :return: The resource_status_reason of this StackEvent.
        :rtype: str
        """
        return self._resource_status_reason

    @resource_status_reason.setter
    def resource_status_reason(self, resource_status_reason):
        """Sets the resource_status_reason of this StackEvent.

        Success/failure message associated with the resource.

        :param resource_status_reason: The resource_status_reason of this StackEvent.
        :type resource_status_reason: str
        """
        if resource_status_reason is None:
            raise ValueError("Invalid value for `resource_status_reason`, must not be `None`")

        self._resource_status_reason = resource_status_reason

    @property
    def client_request_token(self):
        """Gets the client_request_token of this StackEvent.

        The token passed to the operation that generated this event.

        :return: The client_request_token of this StackEvent.
        :rtype: str
        """
        return self._client_request_token

    @client_request_token.setter
    def client_request_token(self, client_request_token):
        """Sets the client_request_token of this StackEvent.

        The token passed to the operation that generated this event.

        :param client_request_token: The client_request_token of this StackEvent.
        :type client_request_token: str
        """
        if client_request_token is None:
            raise ValueError("Invalid value for `client_request_token`, must not be `None`")

        self._client_request_token = client_request_token

    @property
    def resource_properties(self):
        """Gets the resource_properties of this StackEvent.

        BLOB of the properties used to create the resource.

        :return: The resource_properties of this StackEvent.
        :rtype: str
        """
        return self._resource_properties

    @resource_properties.setter
    def resource_properties(self, resource_properties):
        """Sets the resource_properties of this StackEvent.

        BLOB of the properties used to create the resource.

        :param resource_properties: The resource_properties of this StackEvent.
        :type resource_properties: str
        """
        if resource_properties is None:
            raise ValueError("Invalid value for `resource_properties`, must not be `None`")

        self._resource_properties = resource_properties

    @property
    def stack_id(self):
        """Gets the stack_id of this StackEvent.

        The unique ID name of the instance of the stack.

        :return: The stack_id of this StackEvent.
        :rtype: str
        """
        return self._stack_id

    @stack_id.setter
    def stack_id(self, stack_id):
        """Sets the stack_id of this StackEvent.

        The unique ID name of the instance of the stack.

        :param stack_id: The stack_id of this StackEvent.
        :type stack_id: str
        """
        if stack_id is None:
            raise ValueError("Invalid value for `stack_id`, must not be `None`")

        self._stack_id = stack_id

    @property
    def stack_name(self):
        """Gets the stack_name of this StackEvent.

        The name associated with a stack.

        :return: The stack_name of this StackEvent.
        :rtype: str
        """
        return self._stack_name

    @stack_name.setter
    def stack_name(self, stack_name):
        """Sets the stack_name of this StackEvent.

        The name associated with a stack.

        :param stack_name: The stack_name of this StackEvent.
        :type stack_name: str
        """
        if stack_name is None:
            raise ValueError("Invalid value for `stack_name`, must not be `None`")

        self._stack_name = stack_name

    @property
    def logical_resource_id(self):
        """Gets the logical_resource_id of this StackEvent.

        The logical name of the resource specified in the template.

        :return: The logical_resource_id of this StackEvent.
        :rtype: str
        """
        return self._logical_resource_id

    @logical_resource_id.setter
    def logical_resource_id(self, logical_resource_id):
        """Sets the logical_resource_id of this StackEvent.

        The logical name of the resource specified in the template.

        :param logical_resource_id: The logical_resource_id of this StackEvent.
        :type logical_resource_id: str
        """
        if logical_resource_id is None:
            raise ValueError("Invalid value for `logical_resource_id`, must not be `None`")

        self._logical_resource_id = logical_resource_id

    @property
    def resource_type(self):
        """Gets the resource_type of this StackEvent.

        Type of resource.

        :return: The resource_type of this StackEvent.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this StackEvent.

        Type of resource.

        :param resource_type: The resource_type of this StackEvent.
        :type resource_type: str
        """
        if resource_type is None:
            raise ValueError("Invalid value for `resource_type`, must not be `None`")

        self._resource_type = resource_type

    @property
    def timestamp(self):
        """Gets the timestamp of this StackEvent.

        Time the status was updated.

        :return: The timestamp of this StackEvent.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this StackEvent.

        Time the status was updated.

        :param timestamp: The timestamp of this StackEvent.
        :type timestamp: datetime
        """
        if timestamp is None:
            raise ValueError("Invalid value for `timestamp`, must not be `None`")

        self._timestamp = timestamp
