# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from typing import List

from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.cluster_info_summary import ClusterInfoSummary


class ListClustersResponseContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, next_token=None, clusters=None):
        """ListClustersResponseContent - a model defined in OpenAPI

        :param next_token: The next_token of this ListClustersResponseContent.
        :type next_token: str
        :param clusters: The clusters of this ListClustersResponseContent.
        :type clusters: List[ClusterInfoSummary]
        """
        self.openapi_types = {"next_token": str, "clusters": List[ClusterInfoSummary]}

        self.attribute_map = {"next_token": "nextToken", "clusters": "clusters"}

        self._next_token = next_token
        self._clusters = clusters

    @classmethod
    def from_dict(cls, dikt) -> "ListClustersResponseContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ListClustersResponseContent of this ListClustersResponseContent.
        :rtype: ListClustersResponseContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def next_token(self):
        """Gets the next_token of this ListClustersResponseContent.

        Token to use for paginated requests.

        :return: The next_token of this ListClustersResponseContent.
        :rtype: str
        """
        return self._next_token

    @next_token.setter
    def next_token(self, next_token):
        """Sets the next_token of this ListClustersResponseContent.

        Token to use for paginated requests.

        :param next_token: The next_token of this ListClustersResponseContent.
        :type next_token: str
        """

        self._next_token = next_token

    @property
    def clusters(self):
        """Gets the clusters of this ListClustersResponseContent.


        :return: The clusters of this ListClustersResponseContent.
        :rtype: List[ClusterInfoSummary]
        """
        return self._clusters

    @clusters.setter
    def clusters(self, clusters):
        """Sets the clusters of this ListClustersResponseContent.


        :param clusters: The clusters of this ListClustersResponseContent.
        :type clusters: List[ClusterInfoSummary]
        """
        if clusters is None:
            raise ValueError("Invalid value for `clusters`, must not be `None`")

        self._clusters = clusters
