from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Self:
	"""Self commands group definition. 2 total commands, 2 Subgroups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("self", core, parent)

	@property
	def address(self):
		"""address commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_address'):
			from .Address import Address
			self._address = Address(self._core, self._cmd_group)
		return self._address

	@property
	def rterminator(self):
		"""rterminator commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_rterminator'):
			from .Rterminator import Rterminator
			self._rterminator = Rterminator(self._core, self._cmd_group)
		return self._rterminator

	def clone(self) -> 'Self':
		"""Clones the group by creating new object from it and its whole existing subgroups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Self(self._core, self._cmd_group.parent)
		self._cmd_group.synchronize_repcaps(new_group)
		return new_group
