from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Result:
	"""Result commands group definition. 9 total commands, 2 Subgroups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("result", core, parent)

	@property
	def capture(self):
		"""capture commands group. 2 Sub-classes, 0 commands."""
		if not hasattr(self, '_capture'):
			from .Capture import Capture
			self._capture = Capture(self._core, self._cmd_group)
		return self._capture

	@property
	def rrange(self):
		"""rrange commands group. 1 Sub-classes, 0 commands."""
		if not hasattr(self, '_rrange'):
			from .Rrange import Rrange
			self._rrange = Rrange(self._core, self._cmd_group)
		return self._rrange

	def clone(self) -> 'Result':
		"""Clones the group by creating new object from it and its whole existing subgroups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Result(self._core, self._cmd_group.parent)
		self._cmd_group.synchronize_repcaps(new_group)
		return new_group
