# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UserSignatureDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, date_stamp_properties=None, disallow_user_resize_stamp=None, external_id=None, image_type=None, is_default=None, nrds_id=None, nrds_last_name=None, phonetic_name=None, signature_font=None, signature_id=None, signature_initials=None, signature_name=None, stamp_format=None, stamp_size_mm=None):
        """
        UserSignatureDefinition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_stamp_properties': 'DateStampProperties',
            'disallow_user_resize_stamp': 'str',
            'external_id': 'str',
            'image_type': 'str',
            'is_default': 'str',
            'nrds_id': 'str',
            'nrds_last_name': 'str',
            'phonetic_name': 'str',
            'signature_font': 'str',
            'signature_id': 'str',
            'signature_initials': 'str',
            'signature_name': 'str',
            'stamp_format': 'str',
            'stamp_size_mm': 'str'
        }

        self.attribute_map = {
            'date_stamp_properties': 'dateStampProperties',
            'disallow_user_resize_stamp': 'disallowUserResizeStamp',
            'external_id': 'externalID',
            'image_type': 'imageType',
            'is_default': 'isDefault',
            'nrds_id': 'nrdsId',
            'nrds_last_name': 'nrdsLastName',
            'phonetic_name': 'phoneticName',
            'signature_font': 'signatureFont',
            'signature_id': 'signatureId',
            'signature_initials': 'signatureInitials',
            'signature_name': 'signatureName',
            'stamp_format': 'stampFormat',
            'stamp_size_mm': 'stampSizeMM'
        }

        self._date_stamp_properties = date_stamp_properties
        self._disallow_user_resize_stamp = disallow_user_resize_stamp
        self._external_id = external_id
        self._image_type = image_type
        self._is_default = is_default
        self._nrds_id = nrds_id
        self._nrds_last_name = nrds_last_name
        self._phonetic_name = phonetic_name
        self._signature_font = signature_font
        self._signature_id = signature_id
        self._signature_initials = signature_initials
        self._signature_name = signature_name
        self._stamp_format = stamp_format
        self._stamp_size_mm = stamp_size_mm

    @property
    def date_stamp_properties(self):
        """
        Gets the date_stamp_properties of this UserSignatureDefinition.

        :return: The date_stamp_properties of this UserSignatureDefinition.
        :rtype: DateStampProperties
        """
        return self._date_stamp_properties

    @date_stamp_properties.setter
    def date_stamp_properties(self, date_stamp_properties):
        """
        Sets the date_stamp_properties of this UserSignatureDefinition.

        :param date_stamp_properties: The date_stamp_properties of this UserSignatureDefinition.
        :type: DateStampProperties
        """

        self._date_stamp_properties = date_stamp_properties

    @property
    def disallow_user_resize_stamp(self):
        """
        Gets the disallow_user_resize_stamp of this UserSignatureDefinition.
        

        :return: The disallow_user_resize_stamp of this UserSignatureDefinition.
        :rtype: str
        """
        return self._disallow_user_resize_stamp

    @disallow_user_resize_stamp.setter
    def disallow_user_resize_stamp(self, disallow_user_resize_stamp):
        """
        Sets the disallow_user_resize_stamp of this UserSignatureDefinition.
        

        :param disallow_user_resize_stamp: The disallow_user_resize_stamp of this UserSignatureDefinition.
        :type: str
        """

        self._disallow_user_resize_stamp = disallow_user_resize_stamp

    @property
    def external_id(self):
        """
        Gets the external_id of this UserSignatureDefinition.
        

        :return: The external_id of this UserSignatureDefinition.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this UserSignatureDefinition.
        

        :param external_id: The external_id of this UserSignatureDefinition.
        :type: str
        """

        self._external_id = external_id

    @property
    def image_type(self):
        """
        Gets the image_type of this UserSignatureDefinition.
        

        :return: The image_type of this UserSignatureDefinition.
        :rtype: str
        """
        return self._image_type

    @image_type.setter
    def image_type(self, image_type):
        """
        Sets the image_type of this UserSignatureDefinition.
        

        :param image_type: The image_type of this UserSignatureDefinition.
        :type: str
        """

        self._image_type = image_type

    @property
    def is_default(self):
        """
        Gets the is_default of this UserSignatureDefinition.
        

        :return: The is_default of this UserSignatureDefinition.
        :rtype: str
        """
        return self._is_default

    @is_default.setter
    def is_default(self, is_default):
        """
        Sets the is_default of this UserSignatureDefinition.
        

        :param is_default: The is_default of this UserSignatureDefinition.
        :type: str
        """

        self._is_default = is_default

    @property
    def nrds_id(self):
        """
        Gets the nrds_id of this UserSignatureDefinition.
        

        :return: The nrds_id of this UserSignatureDefinition.
        :rtype: str
        """
        return self._nrds_id

    @nrds_id.setter
    def nrds_id(self, nrds_id):
        """
        Sets the nrds_id of this UserSignatureDefinition.
        

        :param nrds_id: The nrds_id of this UserSignatureDefinition.
        :type: str
        """

        self._nrds_id = nrds_id

    @property
    def nrds_last_name(self):
        """
        Gets the nrds_last_name of this UserSignatureDefinition.
        

        :return: The nrds_last_name of this UserSignatureDefinition.
        :rtype: str
        """
        return self._nrds_last_name

    @nrds_last_name.setter
    def nrds_last_name(self, nrds_last_name):
        """
        Sets the nrds_last_name of this UserSignatureDefinition.
        

        :param nrds_last_name: The nrds_last_name of this UserSignatureDefinition.
        :type: str
        """

        self._nrds_last_name = nrds_last_name

    @property
    def phonetic_name(self):
        """
        Gets the phonetic_name of this UserSignatureDefinition.
        

        :return: The phonetic_name of this UserSignatureDefinition.
        :rtype: str
        """
        return self._phonetic_name

    @phonetic_name.setter
    def phonetic_name(self, phonetic_name):
        """
        Sets the phonetic_name of this UserSignatureDefinition.
        

        :param phonetic_name: The phonetic_name of this UserSignatureDefinition.
        :type: str
        """

        self._phonetic_name = phonetic_name

    @property
    def signature_font(self):
        """
        Gets the signature_font of this UserSignatureDefinition.
        

        :return: The signature_font of this UserSignatureDefinition.
        :rtype: str
        """
        return self._signature_font

    @signature_font.setter
    def signature_font(self, signature_font):
        """
        Sets the signature_font of this UserSignatureDefinition.
        

        :param signature_font: The signature_font of this UserSignatureDefinition.
        :type: str
        """

        self._signature_font = signature_font

    @property
    def signature_id(self):
        """
        Gets the signature_id of this UserSignatureDefinition.
        Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as \"&\", \"<\", \">\") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.

        :return: The signature_id of this UserSignatureDefinition.
        :rtype: str
        """
        return self._signature_id

    @signature_id.setter
    def signature_id(self, signature_id):
        """
        Sets the signature_id of this UserSignatureDefinition.
        Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as \"&\", \"<\", \">\") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.

        :param signature_id: The signature_id of this UserSignatureDefinition.
        :type: str
        """

        self._signature_id = signature_id

    @property
    def signature_initials(self):
        """
        Gets the signature_initials of this UserSignatureDefinition.
        

        :return: The signature_initials of this UserSignatureDefinition.
        :rtype: str
        """
        return self._signature_initials

    @signature_initials.setter
    def signature_initials(self, signature_initials):
        """
        Sets the signature_initials of this UserSignatureDefinition.
        

        :param signature_initials: The signature_initials of this UserSignatureDefinition.
        :type: str
        """

        self._signature_initials = signature_initials

    @property
    def signature_name(self):
        """
        Gets the signature_name of this UserSignatureDefinition.
        Specifies the user signature name.

        :return: The signature_name of this UserSignatureDefinition.
        :rtype: str
        """
        return self._signature_name

    @signature_name.setter
    def signature_name(self, signature_name):
        """
        Sets the signature_name of this UserSignatureDefinition.
        Specifies the user signature name.

        :param signature_name: The signature_name of this UserSignatureDefinition.
        :type: str
        """

        self._signature_name = signature_name

    @property
    def stamp_format(self):
        """
        Gets the stamp_format of this UserSignatureDefinition.
        

        :return: The stamp_format of this UserSignatureDefinition.
        :rtype: str
        """
        return self._stamp_format

    @stamp_format.setter
    def stamp_format(self, stamp_format):
        """
        Sets the stamp_format of this UserSignatureDefinition.
        

        :param stamp_format: The stamp_format of this UserSignatureDefinition.
        :type: str
        """

        self._stamp_format = stamp_format

    @property
    def stamp_size_mm(self):
        """
        Gets the stamp_size_mm of this UserSignatureDefinition.
        

        :return: The stamp_size_mm of this UserSignatureDefinition.
        :rtype: str
        """
        return self._stamp_size_mm

    @stamp_size_mm.setter
    def stamp_size_mm(self, stamp_size_mm):
        """
        Sets the stamp_size_mm of this UserSignatureDefinition.
        

        :param stamp_size_mm: The stamp_size_mm of this UserSignatureDefinition.
        :type: str
        """

        self._stamp_size_mm = stamp_size_mm

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
