# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class MergeField(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, allow_sender_to_edit=None, allow_sender_to_edit_metadata=None, configuration_type=None, configuration_type_metadata=None, path=None, path_extended=None, path_extended_metadata=None, path_metadata=None, row=None, row_metadata=None, write_back=None, write_back_metadata=None):
        """
        MergeField - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'allow_sender_to_edit': 'str',
            'allow_sender_to_edit_metadata': 'PropertyMetadata',
            'configuration_type': 'str',
            'configuration_type_metadata': 'PropertyMetadata',
            'path': 'str',
            'path_extended': 'list[PathExtendedElement]',
            'path_extended_metadata': 'PropertyMetadata',
            'path_metadata': 'PropertyMetadata',
            'row': 'str',
            'row_metadata': 'PropertyMetadata',
            'write_back': 'str',
            'write_back_metadata': 'PropertyMetadata'
        }

        self.attribute_map = {
            'allow_sender_to_edit': 'allowSenderToEdit',
            'allow_sender_to_edit_metadata': 'allowSenderToEditMetadata',
            'configuration_type': 'configurationType',
            'configuration_type_metadata': 'configurationTypeMetadata',
            'path': 'path',
            'path_extended': 'pathExtended',
            'path_extended_metadata': 'pathExtendedMetadata',
            'path_metadata': 'pathMetadata',
            'row': 'row',
            'row_metadata': 'rowMetadata',
            'write_back': 'writeBack',
            'write_back_metadata': 'writeBackMetadata'
        }

        self._allow_sender_to_edit = allow_sender_to_edit
        self._allow_sender_to_edit_metadata = allow_sender_to_edit_metadata
        self._configuration_type = configuration_type
        self._configuration_type_metadata = configuration_type_metadata
        self._path = path
        self._path_extended = path_extended
        self._path_extended_metadata = path_extended_metadata
        self._path_metadata = path_metadata
        self._row = row
        self._row_metadata = row_metadata
        self._write_back = write_back
        self._write_back_metadata = write_back_metadata

    @property
    def allow_sender_to_edit(self):
        """
        Gets the allow_sender_to_edit of this MergeField.
        When set to **true**, the sender can modify the value of the custom tab during the sending process.

        :return: The allow_sender_to_edit of this MergeField.
        :rtype: str
        """
        return self._allow_sender_to_edit

    @allow_sender_to_edit.setter
    def allow_sender_to_edit(self, allow_sender_to_edit):
        """
        Sets the allow_sender_to_edit of this MergeField.
        When set to **true**, the sender can modify the value of the custom tab during the sending process.

        :param allow_sender_to_edit: The allow_sender_to_edit of this MergeField.
        :type: str
        """

        self._allow_sender_to_edit = allow_sender_to_edit

    @property
    def allow_sender_to_edit_metadata(self):
        """
        Gets the allow_sender_to_edit_metadata of this MergeField.

        :return: The allow_sender_to_edit_metadata of this MergeField.
        :rtype: PropertyMetadata
        """
        return self._allow_sender_to_edit_metadata

    @allow_sender_to_edit_metadata.setter
    def allow_sender_to_edit_metadata(self, allow_sender_to_edit_metadata):
        """
        Sets the allow_sender_to_edit_metadata of this MergeField.

        :param allow_sender_to_edit_metadata: The allow_sender_to_edit_metadata of this MergeField.
        :type: PropertyMetadata
        """

        self._allow_sender_to_edit_metadata = allow_sender_to_edit_metadata

    @property
    def configuration_type(self):
        """
        Gets the configuration_type of this MergeField.
        If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.

        :return: The configuration_type of this MergeField.
        :rtype: str
        """
        return self._configuration_type

    @configuration_type.setter
    def configuration_type(self, configuration_type):
        """
        Sets the configuration_type of this MergeField.
        If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.

        :param configuration_type: The configuration_type of this MergeField.
        :type: str
        """

        self._configuration_type = configuration_type

    @property
    def configuration_type_metadata(self):
        """
        Gets the configuration_type_metadata of this MergeField.

        :return: The configuration_type_metadata of this MergeField.
        :rtype: PropertyMetadata
        """
        return self._configuration_type_metadata

    @configuration_type_metadata.setter
    def configuration_type_metadata(self, configuration_type_metadata):
        """
        Sets the configuration_type_metadata of this MergeField.

        :param configuration_type_metadata: The configuration_type_metadata of this MergeField.
        :type: PropertyMetadata
        """

        self._configuration_type_metadata = configuration_type_metadata

    @property
    def path(self):
        """
        Gets the path of this MergeField.
        Sets the object associated with the custom tab. Currently this is the Salesforce Object.

        :return: The path of this MergeField.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Sets the path of this MergeField.
        Sets the object associated with the custom tab. Currently this is the Salesforce Object.

        :param path: The path of this MergeField.
        :type: str
        """

        self._path = path

    @property
    def path_extended(self):
        """
        Gets the path_extended of this MergeField.
        

        :return: The path_extended of this MergeField.
        :rtype: list[PathExtendedElement]
        """
        return self._path_extended

    @path_extended.setter
    def path_extended(self, path_extended):
        """
        Sets the path_extended of this MergeField.
        

        :param path_extended: The path_extended of this MergeField.
        :type: list[PathExtendedElement]
        """

        self._path_extended = path_extended

    @property
    def path_extended_metadata(self):
        """
        Gets the path_extended_metadata of this MergeField.

        :return: The path_extended_metadata of this MergeField.
        :rtype: PropertyMetadata
        """
        return self._path_extended_metadata

    @path_extended_metadata.setter
    def path_extended_metadata(self, path_extended_metadata):
        """
        Sets the path_extended_metadata of this MergeField.

        :param path_extended_metadata: The path_extended_metadata of this MergeField.
        :type: PropertyMetadata
        """

        self._path_extended_metadata = path_extended_metadata

    @property
    def path_metadata(self):
        """
        Gets the path_metadata of this MergeField.

        :return: The path_metadata of this MergeField.
        :rtype: PropertyMetadata
        """
        return self._path_metadata

    @path_metadata.setter
    def path_metadata(self, path_metadata):
        """
        Sets the path_metadata of this MergeField.

        :param path_metadata: The path_metadata of this MergeField.
        :type: PropertyMetadata
        """

        self._path_metadata = path_metadata

    @property
    def row(self):
        """
        Gets the row of this MergeField.
        Specifies the row number in a Salesforce table that the merge field value corresponds to.

        :return: The row of this MergeField.
        :rtype: str
        """
        return self._row

    @row.setter
    def row(self, row):
        """
        Sets the row of this MergeField.
        Specifies the row number in a Salesforce table that the merge field value corresponds to.

        :param row: The row of this MergeField.
        :type: str
        """

        self._row = row

    @property
    def row_metadata(self):
        """
        Gets the row_metadata of this MergeField.

        :return: The row_metadata of this MergeField.
        :rtype: PropertyMetadata
        """
        return self._row_metadata

    @row_metadata.setter
    def row_metadata(self, row_metadata):
        """
        Sets the row_metadata of this MergeField.

        :param row_metadata: The row_metadata of this MergeField.
        :type: PropertyMetadata
        """

        self._row_metadata = row_metadata

    @property
    def write_back(self):
        """
        Gets the write_back of this MergeField.
        When wet to true, the information entered in the tab automatically updates the related Salesforce data when an envelope is completed.

        :return: The write_back of this MergeField.
        :rtype: str
        """
        return self._write_back

    @write_back.setter
    def write_back(self, write_back):
        """
        Sets the write_back of this MergeField.
        When wet to true, the information entered in the tab automatically updates the related Salesforce data when an envelope is completed.

        :param write_back: The write_back of this MergeField.
        :type: str
        """

        self._write_back = write_back

    @property
    def write_back_metadata(self):
        """
        Gets the write_back_metadata of this MergeField.

        :return: The write_back_metadata of this MergeField.
        :rtype: PropertyMetadata
        """
        return self._write_back_metadata

    @write_back_metadata.setter
    def write_back_metadata(self, write_back_metadata):
        """
        Sets the write_back_metadata of this MergeField.

        :param write_back_metadata: The write_back_metadata of this MergeField.
        :type: PropertyMetadata
        """

        self._write_back_metadata = write_back_metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
