# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class FolderSharedItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, error_details=None, folder_id=None, name=None, owner=None, parent_folder_id=None, parent_folder_uri=None, shared=None, shared_groups=None, shared_users=None, uri=None, user=None):
        """
        FolderSharedItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'error_details': 'ErrorDetails',
            'folder_id': 'str',
            'name': 'str',
            'owner': 'UserInfo',
            'parent_folder_id': 'str',
            'parent_folder_uri': 'str',
            'shared': 'str',
            'shared_groups': 'list[MemberGroupSharedItem]',
            'shared_users': 'list[UserSharedItem]',
            'uri': 'str',
            'user': 'UserInfo'
        }

        self.attribute_map = {
            'error_details': 'errorDetails',
            'folder_id': 'folderId',
            'name': 'name',
            'owner': 'owner',
            'parent_folder_id': 'parentFolderId',
            'parent_folder_uri': 'parentFolderUri',
            'shared': 'shared',
            'shared_groups': 'sharedGroups',
            'shared_users': 'sharedUsers',
            'uri': 'uri',
            'user': 'user'
        }

        self._error_details = error_details
        self._folder_id = folder_id
        self._name = name
        self._owner = owner
        self._parent_folder_id = parent_folder_id
        self._parent_folder_uri = parent_folder_uri
        self._shared = shared
        self._shared_groups = shared_groups
        self._shared_users = shared_users
        self._uri = uri
        self._user = user

    @property
    def error_details(self):
        """
        Gets the error_details of this FolderSharedItem.

        :return: The error_details of this FolderSharedItem.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this FolderSharedItem.

        :param error_details: The error_details of this FolderSharedItem.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def folder_id(self):
        """
        Gets the folder_id of this FolderSharedItem.
        

        :return: The folder_id of this FolderSharedItem.
        :rtype: str
        """
        return self._folder_id

    @folder_id.setter
    def folder_id(self, folder_id):
        """
        Sets the folder_id of this FolderSharedItem.
        

        :param folder_id: The folder_id of this FolderSharedItem.
        :type: str
        """

        self._folder_id = folder_id

    @property
    def name(self):
        """
        Gets the name of this FolderSharedItem.
        

        :return: The name of this FolderSharedItem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FolderSharedItem.
        

        :param name: The name of this FolderSharedItem.
        :type: str
        """

        self._name = name

    @property
    def owner(self):
        """
        Gets the owner of this FolderSharedItem.

        :return: The owner of this FolderSharedItem.
        :rtype: UserInfo
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this FolderSharedItem.

        :param owner: The owner of this FolderSharedItem.
        :type: UserInfo
        """

        self._owner = owner

    @property
    def parent_folder_id(self):
        """
        Gets the parent_folder_id of this FolderSharedItem.
        

        :return: The parent_folder_id of this FolderSharedItem.
        :rtype: str
        """
        return self._parent_folder_id

    @parent_folder_id.setter
    def parent_folder_id(self, parent_folder_id):
        """
        Sets the parent_folder_id of this FolderSharedItem.
        

        :param parent_folder_id: The parent_folder_id of this FolderSharedItem.
        :type: str
        """

        self._parent_folder_id = parent_folder_id

    @property
    def parent_folder_uri(self):
        """
        Gets the parent_folder_uri of this FolderSharedItem.
        

        :return: The parent_folder_uri of this FolderSharedItem.
        :rtype: str
        """
        return self._parent_folder_uri

    @parent_folder_uri.setter
    def parent_folder_uri(self, parent_folder_uri):
        """
        Sets the parent_folder_uri of this FolderSharedItem.
        

        :param parent_folder_uri: The parent_folder_uri of this FolderSharedItem.
        :type: str
        """

        self._parent_folder_uri = parent_folder_uri

    @property
    def shared(self):
        """
        Gets the shared of this FolderSharedItem.
        When set to **true**, this custom tab is shared.

        :return: The shared of this FolderSharedItem.
        :rtype: str
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """
        Sets the shared of this FolderSharedItem.
        When set to **true**, this custom tab is shared.

        :param shared: The shared of this FolderSharedItem.
        :type: str
        """

        self._shared = shared

    @property
    def shared_groups(self):
        """
        Gets the shared_groups of this FolderSharedItem.
        

        :return: The shared_groups of this FolderSharedItem.
        :rtype: list[MemberGroupSharedItem]
        """
        return self._shared_groups

    @shared_groups.setter
    def shared_groups(self, shared_groups):
        """
        Sets the shared_groups of this FolderSharedItem.
        

        :param shared_groups: The shared_groups of this FolderSharedItem.
        :type: list[MemberGroupSharedItem]
        """

        self._shared_groups = shared_groups

    @property
    def shared_users(self):
        """
        Gets the shared_users of this FolderSharedItem.
        

        :return: The shared_users of this FolderSharedItem.
        :rtype: list[UserSharedItem]
        """
        return self._shared_users

    @shared_users.setter
    def shared_users(self, shared_users):
        """
        Sets the shared_users of this FolderSharedItem.
        

        :param shared_users: The shared_users of this FolderSharedItem.
        :type: list[UserSharedItem]
        """

        self._shared_users = shared_users

    @property
    def uri(self):
        """
        Gets the uri of this FolderSharedItem.
        

        :return: The uri of this FolderSharedItem.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this FolderSharedItem.
        

        :param uri: The uri of this FolderSharedItem.
        :type: str
        """

        self._uri = uri

    @property
    def user(self):
        """
        Gets the user of this FolderSharedItem.

        :return: The user of this FolderSharedItem.
        :rtype: UserInfo
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this FolderSharedItem.

        :param user: The user of this FolderSharedItem.
        :type: UserInfo
        """

        self._user = user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
