# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class FeatureSet(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, currency_feature_set_prices=None, envelope_fee=None, feature_set_id=None, fixed_fee=None, is21_cfr_part11=None, is_active=None, is_enabled=None, name=None, seat_fee=None):
        """
        FeatureSet - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'currency_feature_set_prices': 'list[CurrencyFeatureSetPrice]',
            'envelope_fee': 'str',
            'feature_set_id': 'str',
            'fixed_fee': 'str',
            'is21_cfr_part11': 'str',
            'is_active': 'str',
            'is_enabled': 'str',
            'name': 'str',
            'seat_fee': 'str'
        }

        self.attribute_map = {
            'currency_feature_set_prices': 'currencyFeatureSetPrices',
            'envelope_fee': 'envelopeFee',
            'feature_set_id': 'featureSetId',
            'fixed_fee': 'fixedFee',
            'is21_cfr_part11': 'is21CFRPart11',
            'is_active': 'isActive',
            'is_enabled': 'isEnabled',
            'name': 'name',
            'seat_fee': 'seatFee'
        }

        self._currency_feature_set_prices = currency_feature_set_prices
        self._envelope_fee = envelope_fee
        self._feature_set_id = feature_set_id
        self._fixed_fee = fixed_fee
        self._is21_cfr_part11 = is21_cfr_part11
        self._is_active = is_active
        self._is_enabled = is_enabled
        self._name = name
        self._seat_fee = seat_fee

    @property
    def currency_feature_set_prices(self):
        """
        Gets the currency_feature_set_prices of this FeatureSet.
        A complex type that contains alternate currency values that are configured for this plan feature set.

        :return: The currency_feature_set_prices of this FeatureSet.
        :rtype: list[CurrencyFeatureSetPrice]
        """
        return self._currency_feature_set_prices

    @currency_feature_set_prices.setter
    def currency_feature_set_prices(self, currency_feature_set_prices):
        """
        Sets the currency_feature_set_prices of this FeatureSet.
        A complex type that contains alternate currency values that are configured for this plan feature set.

        :param currency_feature_set_prices: The currency_feature_set_prices of this FeatureSet.
        :type: list[CurrencyFeatureSetPrice]
        """

        self._currency_feature_set_prices = currency_feature_set_prices

    @property
    def envelope_fee(self):
        """
        Gets the envelope_fee of this FeatureSet.
        

        :return: The envelope_fee of this FeatureSet.
        :rtype: str
        """
        return self._envelope_fee

    @envelope_fee.setter
    def envelope_fee(self, envelope_fee):
        """
        Sets the envelope_fee of this FeatureSet.
        

        :param envelope_fee: The envelope_fee of this FeatureSet.
        :type: str
        """

        self._envelope_fee = envelope_fee

    @property
    def feature_set_id(self):
        """
        Gets the feature_set_id of this FeatureSet.
        A unique ID for the feature set.

        :return: The feature_set_id of this FeatureSet.
        :rtype: str
        """
        return self._feature_set_id

    @feature_set_id.setter
    def feature_set_id(self, feature_set_id):
        """
        Sets the feature_set_id of this FeatureSet.
        A unique ID for the feature set.

        :param feature_set_id: The feature_set_id of this FeatureSet.
        :type: str
        """

        self._feature_set_id = feature_set_id

    @property
    def fixed_fee(self):
        """
        Gets the fixed_fee of this FeatureSet.
        

        :return: The fixed_fee of this FeatureSet.
        :rtype: str
        """
        return self._fixed_fee

    @fixed_fee.setter
    def fixed_fee(self, fixed_fee):
        """
        Sets the fixed_fee of this FeatureSet.
        

        :param fixed_fee: The fixed_fee of this FeatureSet.
        :type: str
        """

        self._fixed_fee = fixed_fee

    @property
    def is21_cfr_part11(self):
        """
        Gets the is21_cfr_part11 of this FeatureSet.
        When set to **true**, indicates that this module is enabled on the account.

        :return: The is21_cfr_part11 of this FeatureSet.
        :rtype: str
        """
        return self._is21_cfr_part11

    @is21_cfr_part11.setter
    def is21_cfr_part11(self, is21_cfr_part11):
        """
        Sets the is21_cfr_part11 of this FeatureSet.
        When set to **true**, indicates that this module is enabled on the account.

        :param is21_cfr_part11: The is21_cfr_part11 of this FeatureSet.
        :type: str
        """

        self._is21_cfr_part11 = is21_cfr_part11

    @property
    def is_active(self):
        """
        Gets the is_active of this FeatureSet.
        

        :return: The is_active of this FeatureSet.
        :rtype: str
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """
        Sets the is_active of this FeatureSet.
        

        :param is_active: The is_active of this FeatureSet.
        :type: str
        """

        self._is_active = is_active

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this FeatureSet.
        Specifies whether the feature set is actively enabled as part of the plan.

        :return: The is_enabled of this FeatureSet.
        :rtype: str
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this FeatureSet.
        Specifies whether the feature set is actively enabled as part of the plan.

        :param is_enabled: The is_enabled of this FeatureSet.
        :type: str
        """

        self._is_enabled = is_enabled

    @property
    def name(self):
        """
        Gets the name of this FeatureSet.
        

        :return: The name of this FeatureSet.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FeatureSet.
        

        :param name: The name of this FeatureSet.
        :type: str
        """

        self._name = name

    @property
    def seat_fee(self):
        """
        Gets the seat_fee of this FeatureSet.
        An incremental seat cost for seat-based plans. Only valid when isEnabled for the feature set is set to true.

        :return: The seat_fee of this FeatureSet.
        :rtype: str
        """
        return self._seat_fee

    @seat_fee.setter
    def seat_fee(self, seat_fee):
        """
        Sets the seat_fee of this FeatureSet.
        An incremental seat cost for seat-based plans. Only valid when isEnabled for the feature set is set to true.

        :param seat_fee: The seat_fee of this FeatureSet.
        :type: str
        """

        self._seat_fee = seat_fee

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
