# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BulkEnvelope(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, bulk_recipient_row=None, bulk_status=None, email=None, envelope_id=None, envelope_uri=None, error_details=None, name=None, submitted_date_time=None, transaction_id=None):
        """
        BulkEnvelope - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'bulk_recipient_row': 'str',
            'bulk_status': 'str',
            'email': 'str',
            'envelope_id': 'str',
            'envelope_uri': 'str',
            'error_details': 'ErrorDetails',
            'name': 'str',
            'submitted_date_time': 'str',
            'transaction_id': 'str'
        }

        self.attribute_map = {
            'bulk_recipient_row': 'bulkRecipientRow',
            'bulk_status': 'bulkStatus',
            'email': 'email',
            'envelope_id': 'envelopeId',
            'envelope_uri': 'envelopeUri',
            'error_details': 'errorDetails',
            'name': 'name',
            'submitted_date_time': 'submittedDateTime',
            'transaction_id': 'transactionId'
        }

        self._bulk_recipient_row = bulk_recipient_row
        self._bulk_status = bulk_status
        self._email = email
        self._envelope_id = envelope_id
        self._envelope_uri = envelope_uri
        self._error_details = error_details
        self._name = name
        self._submitted_date_time = submitted_date_time
        self._transaction_id = transaction_id

    @property
    def bulk_recipient_row(self):
        """
        Gets the bulk_recipient_row of this BulkEnvelope.
        Reserved: TBD

        :return: The bulk_recipient_row of this BulkEnvelope.
        :rtype: str
        """
        return self._bulk_recipient_row

    @bulk_recipient_row.setter
    def bulk_recipient_row(self, bulk_recipient_row):
        """
        Sets the bulk_recipient_row of this BulkEnvelope.
        Reserved: TBD

        :param bulk_recipient_row: The bulk_recipient_row of this BulkEnvelope.
        :type: str
        """

        self._bulk_recipient_row = bulk_recipient_row

    @property
    def bulk_status(self):
        """
        Gets the bulk_status of this BulkEnvelope.
        Indicates the status of the bulk send operation. Returned values can be: * queued * processing * sent * failed

        :return: The bulk_status of this BulkEnvelope.
        :rtype: str
        """
        return self._bulk_status

    @bulk_status.setter
    def bulk_status(self, bulk_status):
        """
        Sets the bulk_status of this BulkEnvelope.
        Indicates the status of the bulk send operation. Returned values can be: * queued * processing * sent * failed

        :param bulk_status: The bulk_status of this BulkEnvelope.
        :type: str
        """

        self._bulk_status = bulk_status

    @property
    def email(self):
        """
        Gets the email of this BulkEnvelope.
        

        :return: The email of this BulkEnvelope.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this BulkEnvelope.
        

        :param email: The email of this BulkEnvelope.
        :type: str
        """

        self._email = email

    @property
    def envelope_id(self):
        """
        Gets the envelope_id of this BulkEnvelope.
        The envelope ID of the envelope status that failed to post.

        :return: The envelope_id of this BulkEnvelope.
        :rtype: str
        """
        return self._envelope_id

    @envelope_id.setter
    def envelope_id(self, envelope_id):
        """
        Sets the envelope_id of this BulkEnvelope.
        The envelope ID of the envelope status that failed to post.

        :param envelope_id: The envelope_id of this BulkEnvelope.
        :type: str
        """

        self._envelope_id = envelope_id

    @property
    def envelope_uri(self):
        """
        Gets the envelope_uri of this BulkEnvelope.
        Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.

        :return: The envelope_uri of this BulkEnvelope.
        :rtype: str
        """
        return self._envelope_uri

    @envelope_uri.setter
    def envelope_uri(self, envelope_uri):
        """
        Sets the envelope_uri of this BulkEnvelope.
        Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.

        :param envelope_uri: The envelope_uri of this BulkEnvelope.
        :type: str
        """

        self._envelope_uri = envelope_uri

    @property
    def error_details(self):
        """
        Gets the error_details of this BulkEnvelope.

        :return: The error_details of this BulkEnvelope.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this BulkEnvelope.

        :param error_details: The error_details of this BulkEnvelope.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def name(self):
        """
        Gets the name of this BulkEnvelope.
        

        :return: The name of this BulkEnvelope.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this BulkEnvelope.
        

        :param name: The name of this BulkEnvelope.
        :type: str
        """

        self._name = name

    @property
    def submitted_date_time(self):
        """
        Gets the submitted_date_time of this BulkEnvelope.
        

        :return: The submitted_date_time of this BulkEnvelope.
        :rtype: str
        """
        return self._submitted_date_time

    @submitted_date_time.setter
    def submitted_date_time(self, submitted_date_time):
        """
        Sets the submitted_date_time of this BulkEnvelope.
        

        :param submitted_date_time: The submitted_date_time of this BulkEnvelope.
        :type: str
        """

        self._submitted_date_time = submitted_date_time

    @property
    def transaction_id(self):
        """
        Gets the transaction_id of this BulkEnvelope.
         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.

        :return: The transaction_id of this BulkEnvelope.
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """
        Sets the transaction_id of this BulkEnvelope.
         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.

        :param transaction_id: The transaction_id of this BulkEnvelope.
        :type: str
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
