# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class WorkspacesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_workspace(self, account_id, **kwargs):
        """
        Create a Workspace
        Creates a new workspace.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_workspace(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param Workspace workspace:
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_workspace_with_http_info(account_id, **kwargs)
        else:
            (data) = self.create_workspace_with_http_info(account_id, **kwargs)
            return data

    def create_workspace_with_http_info(self, account_id, **kwargs):
        """
        Create a Workspace
        Creates a new workspace.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_workspace_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param Workspace workspace:
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'workspace']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_workspace`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workspace' in params:
            body_params = params['workspace']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Workspace',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_workspace_file(self, account_id, folder_id, workspace_id, **kwargs):
        """
        Creates a workspace file.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_workspace_file(account_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :return: WorkspaceItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_workspace_file_with_http_info(account_id, folder_id, workspace_id, **kwargs)
        else:
            (data) = self.create_workspace_file_with_http_info(account_id, folder_id, workspace_id, **kwargs)
            return data

    def create_workspace_file_with_http_info(self, account_id, folder_id, workspace_id, **kwargs):
        """
        Creates a workspace file.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_workspace_file_with_http_info(account_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :return: WorkspaceItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'folder_id', 'workspace_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workspace_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_workspace_file`")
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `create_workspace_file`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `create_workspace_file`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WorkspaceItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_workspace(self, account_id, workspace_id, **kwargs):
        """
        Delete Workspace
        Deletes an existing workspace (logically).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workspace(account_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_workspace_with_http_info(account_id, workspace_id, **kwargs)
        else:
            (data) = self.delete_workspace_with_http_info(account_id, workspace_id, **kwargs)
            return data

    def delete_workspace_with_http_info(self, account_id, workspace_id, **kwargs):
        """
        Delete Workspace
        Deletes an existing workspace (logically).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workspace_with_http_info(account_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'workspace_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_workspace`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `delete_workspace`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Workspace',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_workspace_folder_items(self, account_id, folder_id, workspace_id, **kwargs):
        """
        Deletes workspace one or more specific files/folders from the given folder or root.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workspace_folder_items(account_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param WorkspaceItemList workspace_item_list:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_workspace_folder_items_with_http_info(account_id, folder_id, workspace_id, **kwargs)
        else:
            (data) = self.delete_workspace_folder_items_with_http_info(account_id, folder_id, workspace_id, **kwargs)
            return data

    def delete_workspace_folder_items_with_http_info(self, account_id, folder_id, workspace_id, **kwargs):
        """
        Deletes workspace one or more specific files/folders from the given folder or root.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workspace_folder_items_with_http_info(account_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param WorkspaceItemList workspace_item_list:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'folder_id', 'workspace_id', 'workspace_item_list']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workspace_folder_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_workspace_folder_items`")
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `delete_workspace_folder_items`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `delete_workspace_folder_items`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workspace_item_list' in params:
            body_params = params['workspace_item_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workspace(self, account_id, workspace_id, **kwargs):
        """
        Get Workspace
        Retrives properties about a workspace given a unique workspaceId. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspace(account_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workspace_with_http_info(account_id, workspace_id, **kwargs)
        else:
            (data) = self.get_workspace_with_http_info(account_id, workspace_id, **kwargs)
            return data

    def get_workspace_with_http_info(self, account_id, workspace_id, **kwargs):
        """
        Get Workspace
        Retrives properties about a workspace given a unique workspaceId. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspace_with_http_info(account_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'workspace_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_workspace`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_workspace`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Workspace',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workspace_file(self, account_id, file_id, folder_id, workspace_id, **kwargs):
        """
        Get Workspace File
        Retrieves a workspace file (the binary).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspace_file(account_id, file_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str file_id: Specifies the room file ID GUID. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param str is_download: When set to **true**, the Content-Disposition header is set in the response. The value of the header provides the filename of the file. Default is **false**.
        :param str pdf_version: When set to **true** the file returned as a PDF.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workspace_file_with_http_info(account_id, file_id, folder_id, workspace_id, **kwargs)
        else:
            (data) = self.get_workspace_file_with_http_info(account_id, file_id, folder_id, workspace_id, **kwargs)
            return data

    def get_workspace_file_with_http_info(self, account_id, file_id, folder_id, workspace_id, **kwargs):
        """
        Get Workspace File
        Retrieves a workspace file (the binary).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspace_file_with_http_info(account_id, file_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str file_id: Specifies the room file ID GUID. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param str is_download: When set to **true**, the Content-Disposition header is set in the response. The value of the header provides the filename of the file. Default is **false**.
        :param str pdf_version: When set to **true** the file returned as a PDF.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'file_id', 'folder_id', 'workspace_id', 'is_download', 'pdf_version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspace_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_workspace_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_workspace_file`")
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `get_workspace_file`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_workspace_file`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'is_download' in params:
            query_params['is_download'] = params['is_download']
        if 'pdf_version' in params:
            query_params['pdf_version'] = params['pdf_version']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_workspace_file_pages(self, account_id, file_id, folder_id, workspace_id, **kwargs):
        """
        List File Pages
        Retrieves a workspace file as rasterized pages.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_workspace_file_pages(account_id, file_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str file_id: Specifies the room file ID GUID. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param str count: The maximum number of results to be returned by this request.
        :param str dpi: Number of dots per inch for the resulting image. The default if not used is 94. The range is 1-310.
        :param str max_height: Sets the maximum height (in pixels) of the returned image.
        :param str max_width: Sets the maximum width (in pixels) of the returned image.
        :param str start_position: The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.
        :return: PageImages
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_workspace_file_pages_with_http_info(account_id, file_id, folder_id, workspace_id, **kwargs)
        else:
            (data) = self.list_workspace_file_pages_with_http_info(account_id, file_id, folder_id, workspace_id, **kwargs)
            return data

    def list_workspace_file_pages_with_http_info(self, account_id, file_id, folder_id, workspace_id, **kwargs):
        """
        List File Pages
        Retrieves a workspace file as rasterized pages.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_workspace_file_pages_with_http_info(account_id, file_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str file_id: Specifies the room file ID GUID. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param str count: The maximum number of results to be returned by this request.
        :param str dpi: Number of dots per inch for the resulting image. The default if not used is 94. The range is 1-310.
        :param str max_height: Sets the maximum height (in pixels) of the returned image.
        :param str max_width: Sets the maximum width (in pixels) of the returned image.
        :param str start_position: The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.
        :return: PageImages
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'file_id', 'folder_id', 'workspace_id', 'count', 'dpi', 'max_height', 'max_width', 'start_position']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workspace_file_pages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_workspace_file_pages`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `list_workspace_file_pages`")
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `list_workspace_file_pages`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `list_workspace_file_pages`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}/pages'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'dpi' in params:
            query_params['dpi'] = params['dpi']
        if 'max_height' in params:
            query_params['max_height'] = params['max_height']
        if 'max_width' in params:
            query_params['max_width'] = params['max_width']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PageImages',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_workspace_folder_items(self, account_id, folder_id, workspace_id, **kwargs):
        """
        List Workspace Folder Contents
        Retrieves workspace folder contents, which can include sub folders and files.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_workspace_folder_items(account_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param str count: The maximum number of results to be returned by this request.
        :param str include_files: When set to **true**, file information is returned in the response along with folder information. The default is **false**.
        :param str include_sub_folders: When set to **true**, information about the sub-folders of the current folder is returned. The default is **false**.
        :param str include_thumbnails: When set to **true**, thumbnails are returned as part of the response.  The default is **false**.
        :param str include_user_detail: Set to **true** to return extended details about the user. The default is **false**.
        :param str start_position: The position within the total result set from which to start returning values.
        :param str workspace_user_id: If set, then the results are filtered to those associated with the specified userId.
        :return: WorkspaceFolderContents
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_workspace_folder_items_with_http_info(account_id, folder_id, workspace_id, **kwargs)
        else:
            (data) = self.list_workspace_folder_items_with_http_info(account_id, folder_id, workspace_id, **kwargs)
            return data

    def list_workspace_folder_items_with_http_info(self, account_id, folder_id, workspace_id, **kwargs):
        """
        List Workspace Folder Contents
        Retrieves workspace folder contents, which can include sub folders and files.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_workspace_folder_items_with_http_info(account_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param str count: The maximum number of results to be returned by this request.
        :param str include_files: When set to **true**, file information is returned in the response along with folder information. The default is **false**.
        :param str include_sub_folders: When set to **true**, information about the sub-folders of the current folder is returned. The default is **false**.
        :param str include_thumbnails: When set to **true**, thumbnails are returned as part of the response.  The default is **false**.
        :param str include_user_detail: Set to **true** to return extended details about the user. The default is **false**.
        :param str start_position: The position within the total result set from which to start returning values.
        :param str workspace_user_id: If set, then the results are filtered to those associated with the specified userId.
        :return: WorkspaceFolderContents
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'folder_id', 'workspace_id', 'count', 'include_files', 'include_sub_folders', 'include_thumbnails', 'include_user_detail', 'start_position', 'workspace_user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workspace_folder_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_workspace_folder_items`")
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `list_workspace_folder_items`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `list_workspace_folder_items`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'include_files' in params:
            query_params['include_files'] = params['include_files']
        if 'include_sub_folders' in params:
            query_params['include_sub_folders'] = params['include_sub_folders']
        if 'include_thumbnails' in params:
            query_params['include_thumbnails'] = params['include_thumbnails']
        if 'include_user_detail' in params:
            query_params['include_user_detail'] = params['include_user_detail']
        if 'start_position' in params:
            query_params['start_position'] = params['start_position']
        if 'workspace_user_id' in params:
            query_params['workspace_user_id'] = params['workspace_user_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WorkspaceFolderContents',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_workspaces(self, account_id, **kwargs):
        """
        List Workspaces
        Gets information about the Workspaces that have been created.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_workspaces(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :return: WorkspaceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_workspaces_with_http_info(account_id, **kwargs)
        else:
            (data) = self.list_workspaces_with_http_info(account_id, **kwargs)
            return data

    def list_workspaces_with_http_info(self, account_id, **kwargs):
        """
        List Workspaces
        Gets information about the Workspaces that have been created.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_workspaces_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :return: WorkspaceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workspaces" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_workspaces`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WorkspaceList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_workspace(self, account_id, workspace_id, **kwargs):
        """
        Update Workspace
        Updates information about a specific workspace.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_workspace(account_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param Workspace workspace:
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_workspace_with_http_info(account_id, workspace_id, **kwargs)
        else:
            (data) = self.update_workspace_with_http_info(account_id, workspace_id, **kwargs)
            return data

    def update_workspace_with_http_info(self, account_id, workspace_id, **kwargs):
        """
        Update Workspace
        Updates information about a specific workspace.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_workspace_with_http_info(account_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :param Workspace workspace:
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'workspace_id', 'workspace']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_workspace`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `update_workspace`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workspace' in params:
            body_params = params['workspace']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Workspace',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_workspace_file(self, account_id, file_id, folder_id, workspace_id, **kwargs):
        """
        Update Workspace File Metadata
        Updates workspace item metadata for one or more specific files/folders.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_workspace_file(account_id, file_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str file_id: Specifies the room file ID GUID. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :return: WorkspaceItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_workspace_file_with_http_info(account_id, file_id, folder_id, workspace_id, **kwargs)
        else:
            (data) = self.update_workspace_file_with_http_info(account_id, file_id, folder_id, workspace_id, **kwargs)
            return data

    def update_workspace_file_with_http_info(self, account_id, file_id, folder_id, workspace_id, **kwargs):
        """
        Update Workspace File Metadata
        Updates workspace item metadata for one or more specific files/folders.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_workspace_file_with_http_info(account_id, file_id, folder_id, workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: The external account number (int) or account ID Guid. (required)
        :param str file_id: Specifies the room file ID GUID. (required)
        :param str folder_id: The ID of the folder being accessed. (required)
        :param str workspace_id: Specifies the workspace ID GUID. (required)
        :return: WorkspaceItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'file_id', 'folder_id', 'workspace_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workspace_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_workspace_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `update_workspace_file`")
        # verify the required parameter 'folder_id' is set
        if ('folder_id' not in params) or (params['folder_id'] is None):
            raise ValueError("Missing the required parameter `folder_id` when calling `update_workspace_file`")
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `update_workspace_file`")


        collection_formats = {}

        resource_path = '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']
        if 'folder_id' in params:
            path_params['folderId'] = params['folder_id']
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WorkspaceItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
