# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UserSignature(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, adopted_date_time=None, created_date_time=None, custom_field=None, date_stamp_properties=None, disallow_user_resize_stamp=None, error_details=None, external_id=None, image_base64=None, image_type=None, initials150_image_id=None, initials_image_uri=None, is_default=None, last_modified_date_time=None, nrds_id=None, nrds_last_name=None, nrds_status=None, phonetic_name=None, signature150_image_id=None, signature_font=None, signature_id=None, signature_image_uri=None, signature_initials=None, signature_name=None, signature_rights=None, signature_type=None, stamp_format=None, stamp_image_uri=None, stamp_size_mm=None, stamp_type=None, status=None):
        """
        UserSignature - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'adopted_date_time': 'str',
            'created_date_time': 'str',
            'custom_field': 'str',
            'date_stamp_properties': 'DateStampProperties',
            'disallow_user_resize_stamp': 'str',
            'error_details': 'ErrorDetails',
            'external_id': 'str',
            'image_base64': 'str',
            'image_type': 'str',
            'initials150_image_id': 'str',
            'initials_image_uri': 'str',
            'is_default': 'str',
            'last_modified_date_time': 'str',
            'nrds_id': 'str',
            'nrds_last_name': 'str',
            'nrds_status': 'str',
            'phonetic_name': 'str',
            'signature150_image_id': 'str',
            'signature_font': 'str',
            'signature_id': 'str',
            'signature_image_uri': 'str',
            'signature_initials': 'str',
            'signature_name': 'str',
            'signature_rights': 'str',
            'signature_type': 'str',
            'stamp_format': 'str',
            'stamp_image_uri': 'str',
            'stamp_size_mm': 'str',
            'stamp_type': 'str',
            'status': 'str'
        }

        self.attribute_map = {
            'adopted_date_time': 'adoptedDateTime',
            'created_date_time': 'createdDateTime',
            'custom_field': 'customField',
            'date_stamp_properties': 'dateStampProperties',
            'disallow_user_resize_stamp': 'disallowUserResizeStamp',
            'error_details': 'errorDetails',
            'external_id': 'externalID',
            'image_base64': 'imageBase64',
            'image_type': 'imageType',
            'initials150_image_id': 'initials150ImageId',
            'initials_image_uri': 'initialsImageUri',
            'is_default': 'isDefault',
            'last_modified_date_time': 'lastModifiedDateTime',
            'nrds_id': 'nrdsId',
            'nrds_last_name': 'nrdsLastName',
            'nrds_status': 'nrdsStatus',
            'phonetic_name': 'phoneticName',
            'signature150_image_id': 'signature150ImageId',
            'signature_font': 'signatureFont',
            'signature_id': 'signatureId',
            'signature_image_uri': 'signatureImageUri',
            'signature_initials': 'signatureInitials',
            'signature_name': 'signatureName',
            'signature_rights': 'signatureRights',
            'signature_type': 'signatureType',
            'stamp_format': 'stampFormat',
            'stamp_image_uri': 'stampImageUri',
            'stamp_size_mm': 'stampSizeMM',
            'stamp_type': 'stampType',
            'status': 'status'
        }

        self._adopted_date_time = adopted_date_time
        self._created_date_time = created_date_time
        self._custom_field = custom_field
        self._date_stamp_properties = date_stamp_properties
        self._disallow_user_resize_stamp = disallow_user_resize_stamp
        self._error_details = error_details
        self._external_id = external_id
        self._image_base64 = image_base64
        self._image_type = image_type
        self._initials150_image_id = initials150_image_id
        self._initials_image_uri = initials_image_uri
        self._is_default = is_default
        self._last_modified_date_time = last_modified_date_time
        self._nrds_id = nrds_id
        self._nrds_last_name = nrds_last_name
        self._nrds_status = nrds_status
        self._phonetic_name = phonetic_name
        self._signature150_image_id = signature150_image_id
        self._signature_font = signature_font
        self._signature_id = signature_id
        self._signature_image_uri = signature_image_uri
        self._signature_initials = signature_initials
        self._signature_name = signature_name
        self._signature_rights = signature_rights
        self._signature_type = signature_type
        self._stamp_format = stamp_format
        self._stamp_image_uri = stamp_image_uri
        self._stamp_size_mm = stamp_size_mm
        self._stamp_type = stamp_type
        self._status = status

    @property
    def adopted_date_time(self):
        """
        Gets the adopted_date_time of this UserSignature.
        The date and time the user adopted their signature.

        :return: The adopted_date_time of this UserSignature.
        :rtype: str
        """
        return self._adopted_date_time

    @adopted_date_time.setter
    def adopted_date_time(self, adopted_date_time):
        """
        Sets the adopted_date_time of this UserSignature.
        The date and time the user adopted their signature.

        :param adopted_date_time: The adopted_date_time of this UserSignature.
        :type: str
        """

        self._adopted_date_time = adopted_date_time

    @property
    def created_date_time(self):
        """
        Gets the created_date_time of this UserSignature.
        Indicates the date and time the item was created.

        :return: The created_date_time of this UserSignature.
        :rtype: str
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """
        Sets the created_date_time of this UserSignature.
        Indicates the date and time the item was created.

        :param created_date_time: The created_date_time of this UserSignature.
        :type: str
        """

        self._created_date_time = created_date_time

    @property
    def custom_field(self):
        """
        Gets the custom_field of this UserSignature.
        

        :return: The custom_field of this UserSignature.
        :rtype: str
        """
        return self._custom_field

    @custom_field.setter
    def custom_field(self, custom_field):
        """
        Sets the custom_field of this UserSignature.
        

        :param custom_field: The custom_field of this UserSignature.
        :type: str
        """

        self._custom_field = custom_field

    @property
    def date_stamp_properties(self):
        """
        Gets the date_stamp_properties of this UserSignature.

        :return: The date_stamp_properties of this UserSignature.
        :rtype: DateStampProperties
        """
        return self._date_stamp_properties

    @date_stamp_properties.setter
    def date_stamp_properties(self, date_stamp_properties):
        """
        Sets the date_stamp_properties of this UserSignature.

        :param date_stamp_properties: The date_stamp_properties of this UserSignature.
        :type: DateStampProperties
        """

        self._date_stamp_properties = date_stamp_properties

    @property
    def disallow_user_resize_stamp(self):
        """
        Gets the disallow_user_resize_stamp of this UserSignature.
        

        :return: The disallow_user_resize_stamp of this UserSignature.
        :rtype: str
        """
        return self._disallow_user_resize_stamp

    @disallow_user_resize_stamp.setter
    def disallow_user_resize_stamp(self, disallow_user_resize_stamp):
        """
        Sets the disallow_user_resize_stamp of this UserSignature.
        

        :param disallow_user_resize_stamp: The disallow_user_resize_stamp of this UserSignature.
        :type: str
        """

        self._disallow_user_resize_stamp = disallow_user_resize_stamp

    @property
    def error_details(self):
        """
        Gets the error_details of this UserSignature.

        :return: The error_details of this UserSignature.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this UserSignature.

        :param error_details: The error_details of this UserSignature.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def external_id(self):
        """
        Gets the external_id of this UserSignature.
        

        :return: The external_id of this UserSignature.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this UserSignature.
        

        :param external_id: The external_id of this UserSignature.
        :type: str
        """

        self._external_id = external_id

    @property
    def image_base64(self):
        """
        Gets the image_base64 of this UserSignature.
        

        :return: The image_base64 of this UserSignature.
        :rtype: str
        """
        return self._image_base64

    @image_base64.setter
    def image_base64(self, image_base64):
        """
        Sets the image_base64 of this UserSignature.
        

        :param image_base64: The image_base64 of this UserSignature.
        :type: str
        """

        self._image_base64 = image_base64

    @property
    def image_type(self):
        """
        Gets the image_type of this UserSignature.
        

        :return: The image_type of this UserSignature.
        :rtype: str
        """
        return self._image_type

    @image_type.setter
    def image_type(self, image_type):
        """
        Sets the image_type of this UserSignature.
        

        :param image_type: The image_type of this UserSignature.
        :type: str
        """

        self._image_type = image_type

    @property
    def initials150_image_id(self):
        """
        Gets the initials150_image_id of this UserSignature.
        

        :return: The initials150_image_id of this UserSignature.
        :rtype: str
        """
        return self._initials150_image_id

    @initials150_image_id.setter
    def initials150_image_id(self, initials150_image_id):
        """
        Sets the initials150_image_id of this UserSignature.
        

        :param initials150_image_id: The initials150_image_id of this UserSignature.
        :type: str
        """

        self._initials150_image_id = initials150_image_id

    @property
    def initials_image_uri(self):
        """
        Gets the initials_image_uri of this UserSignature.
        Contains the URI for an endpoint that you can use to retrieve the initials image.

        :return: The initials_image_uri of this UserSignature.
        :rtype: str
        """
        return self._initials_image_uri

    @initials_image_uri.setter
    def initials_image_uri(self, initials_image_uri):
        """
        Sets the initials_image_uri of this UserSignature.
        Contains the URI for an endpoint that you can use to retrieve the initials image.

        :param initials_image_uri: The initials_image_uri of this UserSignature.
        :type: str
        """

        self._initials_image_uri = initials_image_uri

    @property
    def is_default(self):
        """
        Gets the is_default of this UserSignature.
        

        :return: The is_default of this UserSignature.
        :rtype: str
        """
        return self._is_default

    @is_default.setter
    def is_default(self, is_default):
        """
        Sets the is_default of this UserSignature.
        

        :param is_default: The is_default of this UserSignature.
        :type: str
        """

        self._is_default = is_default

    @property
    def last_modified_date_time(self):
        """
        Gets the last_modified_date_time of this UserSignature.
        The date and time the item was last modified.

        :return: The last_modified_date_time of this UserSignature.
        :rtype: str
        """
        return self._last_modified_date_time

    @last_modified_date_time.setter
    def last_modified_date_time(self, last_modified_date_time):
        """
        Sets the last_modified_date_time of this UserSignature.
        The date and time the item was last modified.

        :param last_modified_date_time: The last_modified_date_time of this UserSignature.
        :type: str
        """

        self._last_modified_date_time = last_modified_date_time

    @property
    def nrds_id(self):
        """
        Gets the nrds_id of this UserSignature.
        

        :return: The nrds_id of this UserSignature.
        :rtype: str
        """
        return self._nrds_id

    @nrds_id.setter
    def nrds_id(self, nrds_id):
        """
        Sets the nrds_id of this UserSignature.
        

        :param nrds_id: The nrds_id of this UserSignature.
        :type: str
        """

        self._nrds_id = nrds_id

    @property
    def nrds_last_name(self):
        """
        Gets the nrds_last_name of this UserSignature.
        

        :return: The nrds_last_name of this UserSignature.
        :rtype: str
        """
        return self._nrds_last_name

    @nrds_last_name.setter
    def nrds_last_name(self, nrds_last_name):
        """
        Sets the nrds_last_name of this UserSignature.
        

        :param nrds_last_name: The nrds_last_name of this UserSignature.
        :type: str
        """

        self._nrds_last_name = nrds_last_name

    @property
    def nrds_status(self):
        """
        Gets the nrds_status of this UserSignature.
        

        :return: The nrds_status of this UserSignature.
        :rtype: str
        """
        return self._nrds_status

    @nrds_status.setter
    def nrds_status(self, nrds_status):
        """
        Sets the nrds_status of this UserSignature.
        

        :param nrds_status: The nrds_status of this UserSignature.
        :type: str
        """

        self._nrds_status = nrds_status

    @property
    def phonetic_name(self):
        """
        Gets the phonetic_name of this UserSignature.
        

        :return: The phonetic_name of this UserSignature.
        :rtype: str
        """
        return self._phonetic_name

    @phonetic_name.setter
    def phonetic_name(self, phonetic_name):
        """
        Sets the phonetic_name of this UserSignature.
        

        :param phonetic_name: The phonetic_name of this UserSignature.
        :type: str
        """

        self._phonetic_name = phonetic_name

    @property
    def signature150_image_id(self):
        """
        Gets the signature150_image_id of this UserSignature.
        

        :return: The signature150_image_id of this UserSignature.
        :rtype: str
        """
        return self._signature150_image_id

    @signature150_image_id.setter
    def signature150_image_id(self, signature150_image_id):
        """
        Sets the signature150_image_id of this UserSignature.
        

        :param signature150_image_id: The signature150_image_id of this UserSignature.
        :type: str
        """

        self._signature150_image_id = signature150_image_id

    @property
    def signature_font(self):
        """
        Gets the signature_font of this UserSignature.
        The font type for the signature, if the signature is not drawn. The supported font types are:  \"7_DocuSign\", \"1_DocuSign\", \"6_DocuSign\", \"8_DocuSign\", \"3_DocuSign\", \"Mistral\", \"4_DocuSign\", \"2_DocuSign\", \"5_DocuSign\", \"Rage Italic\" 

        :return: The signature_font of this UserSignature.
        :rtype: str
        """
        return self._signature_font

    @signature_font.setter
    def signature_font(self, signature_font):
        """
        Sets the signature_font of this UserSignature.
        The font type for the signature, if the signature is not drawn. The supported font types are:  \"7_DocuSign\", \"1_DocuSign\", \"6_DocuSign\", \"8_DocuSign\", \"3_DocuSign\", \"Mistral\", \"4_DocuSign\", \"2_DocuSign\", \"5_DocuSign\", \"Rage Italic\" 

        :param signature_font: The signature_font of this UserSignature.
        :type: str
        """

        self._signature_font = signature_font

    @property
    def signature_id(self):
        """
        Gets the signature_id of this UserSignature.
        Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as \"&\", \"<\", \">\") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.

        :return: The signature_id of this UserSignature.
        :rtype: str
        """
        return self._signature_id

    @signature_id.setter
    def signature_id(self, signature_id):
        """
        Sets the signature_id of this UserSignature.
        Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as \"&\", \"<\", \">\") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.

        :param signature_id: The signature_id of this UserSignature.
        :type: str
        """

        self._signature_id = signature_id

    @property
    def signature_image_uri(self):
        """
        Gets the signature_image_uri of this UserSignature.
        Contains the URI for an endpoint that you can use to retrieve the signature image.

        :return: The signature_image_uri of this UserSignature.
        :rtype: str
        """
        return self._signature_image_uri

    @signature_image_uri.setter
    def signature_image_uri(self, signature_image_uri):
        """
        Sets the signature_image_uri of this UserSignature.
        Contains the URI for an endpoint that you can use to retrieve the signature image.

        :param signature_image_uri: The signature_image_uri of this UserSignature.
        :type: str
        """

        self._signature_image_uri = signature_image_uri

    @property
    def signature_initials(self):
        """
        Gets the signature_initials of this UserSignature.
         The initials associated with the signature.

        :return: The signature_initials of this UserSignature.
        :rtype: str
        """
        return self._signature_initials

    @signature_initials.setter
    def signature_initials(self, signature_initials):
        """
        Sets the signature_initials of this UserSignature.
         The initials associated with the signature.

        :param signature_initials: The signature_initials of this UserSignature.
        :type: str
        """

        self._signature_initials = signature_initials

    @property
    def signature_name(self):
        """
        Gets the signature_name of this UserSignature.
        Specifies the user signature name.

        :return: The signature_name of this UserSignature.
        :rtype: str
        """
        return self._signature_name

    @signature_name.setter
    def signature_name(self, signature_name):
        """
        Sets the signature_name of this UserSignature.
        Specifies the user signature name.

        :param signature_name: The signature_name of this UserSignature.
        :type: str
        """

        self._signature_name = signature_name

    @property
    def signature_rights(self):
        """
        Gets the signature_rights of this UserSignature.
        

        :return: The signature_rights of this UserSignature.
        :rtype: str
        """
        return self._signature_rights

    @signature_rights.setter
    def signature_rights(self, signature_rights):
        """
        Sets the signature_rights of this UserSignature.
        

        :param signature_rights: The signature_rights of this UserSignature.
        :type: str
        """

        self._signature_rights = signature_rights

    @property
    def signature_type(self):
        """
        Gets the signature_type of this UserSignature.
        

        :return: The signature_type of this UserSignature.
        :rtype: str
        """
        return self._signature_type

    @signature_type.setter
    def signature_type(self, signature_type):
        """
        Sets the signature_type of this UserSignature.
        

        :param signature_type: The signature_type of this UserSignature.
        :type: str
        """

        self._signature_type = signature_type

    @property
    def stamp_format(self):
        """
        Gets the stamp_format of this UserSignature.
        

        :return: The stamp_format of this UserSignature.
        :rtype: str
        """
        return self._stamp_format

    @stamp_format.setter
    def stamp_format(self, stamp_format):
        """
        Sets the stamp_format of this UserSignature.
        

        :param stamp_format: The stamp_format of this UserSignature.
        :type: str
        """

        self._stamp_format = stamp_format

    @property
    def stamp_image_uri(self):
        """
        Gets the stamp_image_uri of this UserSignature.
        

        :return: The stamp_image_uri of this UserSignature.
        :rtype: str
        """
        return self._stamp_image_uri

    @stamp_image_uri.setter
    def stamp_image_uri(self, stamp_image_uri):
        """
        Sets the stamp_image_uri of this UserSignature.
        

        :param stamp_image_uri: The stamp_image_uri of this UserSignature.
        :type: str
        """

        self._stamp_image_uri = stamp_image_uri

    @property
    def stamp_size_mm(self):
        """
        Gets the stamp_size_mm of this UserSignature.
        

        :return: The stamp_size_mm of this UserSignature.
        :rtype: str
        """
        return self._stamp_size_mm

    @stamp_size_mm.setter
    def stamp_size_mm(self, stamp_size_mm):
        """
        Sets the stamp_size_mm of this UserSignature.
        

        :param stamp_size_mm: The stamp_size_mm of this UserSignature.
        :type: str
        """

        self._stamp_size_mm = stamp_size_mm

    @property
    def stamp_type(self):
        """
        Gets the stamp_type of this UserSignature.
        

        :return: The stamp_type of this UserSignature.
        :rtype: str
        """
        return self._stamp_type

    @stamp_type.setter
    def stamp_type(self, stamp_type):
        """
        Sets the stamp_type of this UserSignature.
        

        :param stamp_type: The stamp_type of this UserSignature.
        :type: str
        """

        self._stamp_type = stamp_type

    @property
    def status(self):
        """
        Gets the status of this UserSignature.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :return: The status of this UserSignature.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this UserSignature.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :param status: The status of this UserSignature.
        :type: str
        """

        self._status = status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
