# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SignSessionInfoRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, certificate=None, max_signature_length=None, return_format=None, signing_location=None):
        """
        SignSessionInfoRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'certificate': 'str',
            'max_signature_length': 'str',
            'return_format': 'str',
            'signing_location': 'str'
        }

        self.attribute_map = {
            'certificate': 'certificate',
            'max_signature_length': 'maxSignatureLength',
            'return_format': 'returnFormat',
            'signing_location': 'signingLocation'
        }

        self._certificate = certificate
        self._max_signature_length = max_signature_length
        self._return_format = return_format
        self._signing_location = signing_location

    @property
    def certificate(self):
        """
        Gets the certificate of this SignSessionInfoRequest.
        

        :return: The certificate of this SignSessionInfoRequest.
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate):
        """
        Sets the certificate of this SignSessionInfoRequest.
        

        :param certificate: The certificate of this SignSessionInfoRequest.
        :type: str
        """

        self._certificate = certificate

    @property
    def max_signature_length(self):
        """
        Gets the max_signature_length of this SignSessionInfoRequest.
        

        :return: The max_signature_length of this SignSessionInfoRequest.
        :rtype: str
        """
        return self._max_signature_length

    @max_signature_length.setter
    def max_signature_length(self, max_signature_length):
        """
        Sets the max_signature_length of this SignSessionInfoRequest.
        

        :param max_signature_length: The max_signature_length of this SignSessionInfoRequest.
        :type: str
        """

        self._max_signature_length = max_signature_length

    @property
    def return_format(self):
        """
        Gets the return_format of this SignSessionInfoRequest.
        

        :return: The return_format of this SignSessionInfoRequest.
        :rtype: str
        """
        return self._return_format

    @return_format.setter
    def return_format(self, return_format):
        """
        Sets the return_format of this SignSessionInfoRequest.
        

        :param return_format: The return_format of this SignSessionInfoRequest.
        :type: str
        """

        self._return_format = return_format

    @property
    def signing_location(self):
        """
        Gets the signing_location of this SignSessionInfoRequest.
        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.

        :return: The signing_location of this SignSessionInfoRequest.
        :rtype: str
        """
        return self._signing_location

    @signing_location.setter
    def signing_location(self, signing_location):
        """
        Sets the signing_location of this SignSessionInfoRequest.
        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.

        :param signing_location: The signing_location of this SignSessionInfoRequest.
        :type: str
        """

        self._signing_location = signing_location

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
