# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RadioGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, conditional_parent_label=None, conditional_parent_label_metadata=None, conditional_parent_value=None, conditional_parent_value_metadata=None, document_id=None, document_id_metadata=None, group_name=None, group_name_metadata=None, radios=None, recipient_id=None, recipient_id_guid=None, recipient_id_guid_metadata=None, recipient_id_metadata=None, require_all=None, require_all_metadata=None, require_initial_on_shared_change=None, require_initial_on_shared_change_metadata=None, shared=None, shared_metadata=None, tab_type=None, tab_type_metadata=None, template_locked=None, template_locked_metadata=None, template_required=None, template_required_metadata=None, tooltip=None, tooltip_metadata=None):
        """
        RadioGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conditional_parent_label': 'str',
            'conditional_parent_label_metadata': 'PropertyMetadata',
            'conditional_parent_value': 'str',
            'conditional_parent_value_metadata': 'PropertyMetadata',
            'document_id': 'str',
            'document_id_metadata': 'PropertyMetadata',
            'group_name': 'str',
            'group_name_metadata': 'PropertyMetadata',
            'radios': 'list[Radio]',
            'recipient_id': 'str',
            'recipient_id_guid': 'str',
            'recipient_id_guid_metadata': 'PropertyMetadata',
            'recipient_id_metadata': 'PropertyMetadata',
            'require_all': 'str',
            'require_all_metadata': 'PropertyMetadata',
            'require_initial_on_shared_change': 'str',
            'require_initial_on_shared_change_metadata': 'PropertyMetadata',
            'shared': 'str',
            'shared_metadata': 'PropertyMetadata',
            'tab_type': 'str',
            'tab_type_metadata': 'PropertyMetadata',
            'template_locked': 'str',
            'template_locked_metadata': 'PropertyMetadata',
            'template_required': 'str',
            'template_required_metadata': 'PropertyMetadata',
            'tooltip': 'str',
            'tooltip_metadata': 'PropertyMetadata'
        }

        self.attribute_map = {
            'conditional_parent_label': 'conditionalParentLabel',
            'conditional_parent_label_metadata': 'conditionalParentLabelMetadata',
            'conditional_parent_value': 'conditionalParentValue',
            'conditional_parent_value_metadata': 'conditionalParentValueMetadata',
            'document_id': 'documentId',
            'document_id_metadata': 'documentIdMetadata',
            'group_name': 'groupName',
            'group_name_metadata': 'groupNameMetadata',
            'radios': 'radios',
            'recipient_id': 'recipientId',
            'recipient_id_guid': 'recipientIdGuid',
            'recipient_id_guid_metadata': 'recipientIdGuidMetadata',
            'recipient_id_metadata': 'recipientIdMetadata',
            'require_all': 'requireAll',
            'require_all_metadata': 'requireAllMetadata',
            'require_initial_on_shared_change': 'requireInitialOnSharedChange',
            'require_initial_on_shared_change_metadata': 'requireInitialOnSharedChangeMetadata',
            'shared': 'shared',
            'shared_metadata': 'sharedMetadata',
            'tab_type': 'tabType',
            'tab_type_metadata': 'tabTypeMetadata',
            'template_locked': 'templateLocked',
            'template_locked_metadata': 'templateLockedMetadata',
            'template_required': 'templateRequired',
            'template_required_metadata': 'templateRequiredMetadata',
            'tooltip': 'tooltip',
            'tooltip_metadata': 'tooltipMetadata'
        }

        self._conditional_parent_label = conditional_parent_label
        self._conditional_parent_label_metadata = conditional_parent_label_metadata
        self._conditional_parent_value = conditional_parent_value
        self._conditional_parent_value_metadata = conditional_parent_value_metadata
        self._document_id = document_id
        self._document_id_metadata = document_id_metadata
        self._group_name = group_name
        self._group_name_metadata = group_name_metadata
        self._radios = radios
        self._recipient_id = recipient_id
        self._recipient_id_guid = recipient_id_guid
        self._recipient_id_guid_metadata = recipient_id_guid_metadata
        self._recipient_id_metadata = recipient_id_metadata
        self._require_all = require_all
        self._require_all_metadata = require_all_metadata
        self._require_initial_on_shared_change = require_initial_on_shared_change
        self._require_initial_on_shared_change_metadata = require_initial_on_shared_change_metadata
        self._shared = shared
        self._shared_metadata = shared_metadata
        self._tab_type = tab_type
        self._tab_type_metadata = tab_type_metadata
        self._template_locked = template_locked
        self._template_locked_metadata = template_locked_metadata
        self._template_required = template_required
        self._template_required_metadata = template_required_metadata
        self._tooltip = tooltip
        self._tooltip_metadata = tooltip_metadata

    @property
    def conditional_parent_label(self):
        """
        Gets the conditional_parent_label of this RadioGroup.
        For conditional fields this is the TabLabel of the parent tab that controls this tab's visibility.

        :return: The conditional_parent_label of this RadioGroup.
        :rtype: str
        """
        return self._conditional_parent_label

    @conditional_parent_label.setter
    def conditional_parent_label(self, conditional_parent_label):
        """
        Sets the conditional_parent_label of this RadioGroup.
        For conditional fields this is the TabLabel of the parent tab that controls this tab's visibility.

        :param conditional_parent_label: The conditional_parent_label of this RadioGroup.
        :type: str
        """

        self._conditional_parent_label = conditional_parent_label

    @property
    def conditional_parent_label_metadata(self):
        """
        Gets the conditional_parent_label_metadata of this RadioGroup.

        :return: The conditional_parent_label_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._conditional_parent_label_metadata

    @conditional_parent_label_metadata.setter
    def conditional_parent_label_metadata(self, conditional_parent_label_metadata):
        """
        Sets the conditional_parent_label_metadata of this RadioGroup.

        :param conditional_parent_label_metadata: The conditional_parent_label_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._conditional_parent_label_metadata = conditional_parent_label_metadata

    @property
    def conditional_parent_value(self):
        """
        Gets the conditional_parent_value of this RadioGroup.
        For conditional fields, this is the value of the parent tab that controls the tab's visibility.  If the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use \"on\" as the value to show that the parent tab is active. 

        :return: The conditional_parent_value of this RadioGroup.
        :rtype: str
        """
        return self._conditional_parent_value

    @conditional_parent_value.setter
    def conditional_parent_value(self, conditional_parent_value):
        """
        Sets the conditional_parent_value of this RadioGroup.
        For conditional fields, this is the value of the parent tab that controls the tab's visibility.  If the parent tab is a Checkbox, Radio button, Optional Signature, or Optional Initial use \"on\" as the value to show that the parent tab is active. 

        :param conditional_parent_value: The conditional_parent_value of this RadioGroup.
        :type: str
        """

        self._conditional_parent_value = conditional_parent_value

    @property
    def conditional_parent_value_metadata(self):
        """
        Gets the conditional_parent_value_metadata of this RadioGroup.

        :return: The conditional_parent_value_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._conditional_parent_value_metadata

    @conditional_parent_value_metadata.setter
    def conditional_parent_value_metadata(self, conditional_parent_value_metadata):
        """
        Sets the conditional_parent_value_metadata of this RadioGroup.

        :param conditional_parent_value_metadata: The conditional_parent_value_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._conditional_parent_value_metadata = conditional_parent_value_metadata

    @property
    def document_id(self):
        """
        Gets the document_id of this RadioGroup.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :return: The document_id of this RadioGroup.
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """
        Sets the document_id of this RadioGroup.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :param document_id: The document_id of this RadioGroup.
        :type: str
        """

        self._document_id = document_id

    @property
    def document_id_metadata(self):
        """
        Gets the document_id_metadata of this RadioGroup.

        :return: The document_id_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._document_id_metadata

    @document_id_metadata.setter
    def document_id_metadata(self, document_id_metadata):
        """
        Sets the document_id_metadata of this RadioGroup.

        :param document_id_metadata: The document_id_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._document_id_metadata = document_id_metadata

    @property
    def group_name(self):
        """
        Gets the group_name of this RadioGroup.
        The name of the group.

        :return: The group_name of this RadioGroup.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """
        Sets the group_name of this RadioGroup.
        The name of the group.

        :param group_name: The group_name of this RadioGroup.
        :type: str
        """

        self._group_name = group_name

    @property
    def group_name_metadata(self):
        """
        Gets the group_name_metadata of this RadioGroup.

        :return: The group_name_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._group_name_metadata

    @group_name_metadata.setter
    def group_name_metadata(self, group_name_metadata):
        """
        Sets the group_name_metadata of this RadioGroup.

        :param group_name_metadata: The group_name_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._group_name_metadata = group_name_metadata

    @property
    def radios(self):
        """
        Gets the radios of this RadioGroup.
        Specifies the locations and status for radio buttons that are grouped together.

        :return: The radios of this RadioGroup.
        :rtype: list[Radio]
        """
        return self._radios

    @radios.setter
    def radios(self, radios):
        """
        Sets the radios of this RadioGroup.
        Specifies the locations and status for radio buttons that are grouped together.

        :param radios: The radios of this RadioGroup.
        :type: list[Radio]
        """

        self._radios = radios

    @property
    def recipient_id(self):
        """
        Gets the recipient_id of this RadioGroup.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :return: The recipient_id of this RadioGroup.
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """
        Sets the recipient_id of this RadioGroup.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :param recipient_id: The recipient_id of this RadioGroup.
        :type: str
        """

        self._recipient_id = recipient_id

    @property
    def recipient_id_guid(self):
        """
        Gets the recipient_id_guid of this RadioGroup.
        

        :return: The recipient_id_guid of this RadioGroup.
        :rtype: str
        """
        return self._recipient_id_guid

    @recipient_id_guid.setter
    def recipient_id_guid(self, recipient_id_guid):
        """
        Sets the recipient_id_guid of this RadioGroup.
        

        :param recipient_id_guid: The recipient_id_guid of this RadioGroup.
        :type: str
        """

        self._recipient_id_guid = recipient_id_guid

    @property
    def recipient_id_guid_metadata(self):
        """
        Gets the recipient_id_guid_metadata of this RadioGroup.

        :return: The recipient_id_guid_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._recipient_id_guid_metadata

    @recipient_id_guid_metadata.setter
    def recipient_id_guid_metadata(self, recipient_id_guid_metadata):
        """
        Sets the recipient_id_guid_metadata of this RadioGroup.

        :param recipient_id_guid_metadata: The recipient_id_guid_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._recipient_id_guid_metadata = recipient_id_guid_metadata

    @property
    def recipient_id_metadata(self):
        """
        Gets the recipient_id_metadata of this RadioGroup.

        :return: The recipient_id_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._recipient_id_metadata

    @recipient_id_metadata.setter
    def recipient_id_metadata(self, recipient_id_metadata):
        """
        Sets the recipient_id_metadata of this RadioGroup.

        :param recipient_id_metadata: The recipient_id_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._recipient_id_metadata = recipient_id_metadata

    @property
    def require_all(self):
        """
        Gets the require_all of this RadioGroup.
        When set to **true** and shared is true, information must be entered in this field to complete the envelope. 

        :return: The require_all of this RadioGroup.
        :rtype: str
        """
        return self._require_all

    @require_all.setter
    def require_all(self, require_all):
        """
        Sets the require_all of this RadioGroup.
        When set to **true** and shared is true, information must be entered in this field to complete the envelope. 

        :param require_all: The require_all of this RadioGroup.
        :type: str
        """

        self._require_all = require_all

    @property
    def require_all_metadata(self):
        """
        Gets the require_all_metadata of this RadioGroup.

        :return: The require_all_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._require_all_metadata

    @require_all_metadata.setter
    def require_all_metadata(self, require_all_metadata):
        """
        Sets the require_all_metadata of this RadioGroup.

        :param require_all_metadata: The require_all_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._require_all_metadata = require_all_metadata

    @property
    def require_initial_on_shared_change(self):
        """
        Gets the require_initial_on_shared_change of this RadioGroup.
        Optional element for field markup. When set to **true**, the signer is required to initial when they modify a shared field.

        :return: The require_initial_on_shared_change of this RadioGroup.
        :rtype: str
        """
        return self._require_initial_on_shared_change

    @require_initial_on_shared_change.setter
    def require_initial_on_shared_change(self, require_initial_on_shared_change):
        """
        Sets the require_initial_on_shared_change of this RadioGroup.
        Optional element for field markup. When set to **true**, the signer is required to initial when they modify a shared field.

        :param require_initial_on_shared_change: The require_initial_on_shared_change of this RadioGroup.
        :type: str
        """

        self._require_initial_on_shared_change = require_initial_on_shared_change

    @property
    def require_initial_on_shared_change_metadata(self):
        """
        Gets the require_initial_on_shared_change_metadata of this RadioGroup.

        :return: The require_initial_on_shared_change_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._require_initial_on_shared_change_metadata

    @require_initial_on_shared_change_metadata.setter
    def require_initial_on_shared_change_metadata(self, require_initial_on_shared_change_metadata):
        """
        Sets the require_initial_on_shared_change_metadata of this RadioGroup.

        :param require_initial_on_shared_change_metadata: The require_initial_on_shared_change_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._require_initial_on_shared_change_metadata = require_initial_on_shared_change_metadata

    @property
    def shared(self):
        """
        Gets the shared of this RadioGroup.
        When set to **true**, this custom tab is shared.

        :return: The shared of this RadioGroup.
        :rtype: str
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """
        Sets the shared of this RadioGroup.
        When set to **true**, this custom tab is shared.

        :param shared: The shared of this RadioGroup.
        :type: str
        """

        self._shared = shared

    @property
    def shared_metadata(self):
        """
        Gets the shared_metadata of this RadioGroup.

        :return: The shared_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._shared_metadata

    @shared_metadata.setter
    def shared_metadata(self, shared_metadata):
        """
        Sets the shared_metadata of this RadioGroup.

        :param shared_metadata: The shared_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._shared_metadata = shared_metadata

    @property
    def tab_type(self):
        """
        Gets the tab_type of this RadioGroup.
        

        :return: The tab_type of this RadioGroup.
        :rtype: str
        """
        return self._tab_type

    @tab_type.setter
    def tab_type(self, tab_type):
        """
        Sets the tab_type of this RadioGroup.
        

        :param tab_type: The tab_type of this RadioGroup.
        :type: str
        """

        self._tab_type = tab_type

    @property
    def tab_type_metadata(self):
        """
        Gets the tab_type_metadata of this RadioGroup.

        :return: The tab_type_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._tab_type_metadata

    @tab_type_metadata.setter
    def tab_type_metadata(self, tab_type_metadata):
        """
        Sets the tab_type_metadata of this RadioGroup.

        :param tab_type_metadata: The tab_type_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._tab_type_metadata = tab_type_metadata

    @property
    def template_locked(self):
        """
        Gets the template_locked of this RadioGroup.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :return: The template_locked of this RadioGroup.
        :rtype: str
        """
        return self._template_locked

    @template_locked.setter
    def template_locked(self, template_locked):
        """
        Sets the template_locked of this RadioGroup.
        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients. 

        :param template_locked: The template_locked of this RadioGroup.
        :type: str
        """

        self._template_locked = template_locked

    @property
    def template_locked_metadata(self):
        """
        Gets the template_locked_metadata of this RadioGroup.

        :return: The template_locked_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._template_locked_metadata

    @template_locked_metadata.setter
    def template_locked_metadata(self, template_locked_metadata):
        """
        Sets the template_locked_metadata of this RadioGroup.

        :param template_locked_metadata: The template_locked_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._template_locked_metadata = template_locked_metadata

    @property
    def template_required(self):
        """
        Gets the template_required of this RadioGroup.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :return: The template_required of this RadioGroup.
        :rtype: str
        """
        return self._template_required

    @template_required.setter
    def template_required(self, template_required):
        """
        Sets the template_required of this RadioGroup.
        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.

        :param template_required: The template_required of this RadioGroup.
        :type: str
        """

        self._template_required = template_required

    @property
    def template_required_metadata(self):
        """
        Gets the template_required_metadata of this RadioGroup.

        :return: The template_required_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._template_required_metadata

    @template_required_metadata.setter
    def template_required_metadata(self, template_required_metadata):
        """
        Sets the template_required_metadata of this RadioGroup.

        :param template_required_metadata: The template_required_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._template_required_metadata = template_required_metadata

    @property
    def tooltip(self):
        """
        Gets the tooltip of this RadioGroup.
        

        :return: The tooltip of this RadioGroup.
        :rtype: str
        """
        return self._tooltip

    @tooltip.setter
    def tooltip(self, tooltip):
        """
        Sets the tooltip of this RadioGroup.
        

        :param tooltip: The tooltip of this RadioGroup.
        :type: str
        """

        self._tooltip = tooltip

    @property
    def tooltip_metadata(self):
        """
        Gets the tooltip_metadata of this RadioGroup.

        :return: The tooltip_metadata of this RadioGroup.
        :rtype: PropertyMetadata
        """
        return self._tooltip_metadata

    @tooltip_metadata.setter
    def tooltip_metadata(self, tooltip_metadata):
        """
        Sets the tooltip_metadata of this RadioGroup.

        :param tooltip_metadata: The tooltip_metadata of this RadioGroup.
        :type: PropertyMetadata
        """

        self._tooltip_metadata = tooltip_metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
