# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PaymentGatewayAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, allow_custom_metadata=None, config=None, display_name=None, is_enabled=None, is_legacy=None, last_modified=None, payment_gateway=None, payment_gateway_account_id=None, payment_gateway_display_name=None, pay_pal_legacy_settings=None, supported_currencies=None, supported_payment_methods=None, supported_payment_methods_with_options=None):
        """
        PaymentGatewayAccount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'allow_custom_metadata': 'bool',
            'config': 'PaymentGatewayAccountSetting',
            'display_name': 'str',
            'is_enabled': 'str',
            'is_legacy': 'str',
            'last_modified': 'str',
            'payment_gateway': 'str',
            'payment_gateway_account_id': 'str',
            'payment_gateway_display_name': 'str',
            'pay_pal_legacy_settings': 'PayPalLegacySettings',
            'supported_currencies': 'list[str]',
            'supported_payment_methods': 'list[str]',
            'supported_payment_methods_with_options': 'list[PaymentMethodWithOptions]'
        }

        self.attribute_map = {
            'allow_custom_metadata': 'allowCustomMetadata',
            'config': 'config',
            'display_name': 'displayName',
            'is_enabled': 'isEnabled',
            'is_legacy': 'isLegacy',
            'last_modified': 'lastModified',
            'payment_gateway': 'paymentGateway',
            'payment_gateway_account_id': 'paymentGatewayAccountId',
            'payment_gateway_display_name': 'paymentGatewayDisplayName',
            'pay_pal_legacy_settings': 'payPalLegacySettings',
            'supported_currencies': 'supportedCurrencies',
            'supported_payment_methods': 'supportedPaymentMethods',
            'supported_payment_methods_with_options': 'supportedPaymentMethodsWithOptions'
        }

        self._allow_custom_metadata = allow_custom_metadata
        self._config = config
        self._display_name = display_name
        self._is_enabled = is_enabled
        self._is_legacy = is_legacy
        self._last_modified = last_modified
        self._payment_gateway = payment_gateway
        self._payment_gateway_account_id = payment_gateway_account_id
        self._payment_gateway_display_name = payment_gateway_display_name
        self._pay_pal_legacy_settings = pay_pal_legacy_settings
        self._supported_currencies = supported_currencies
        self._supported_payment_methods = supported_payment_methods
        self._supported_payment_methods_with_options = supported_payment_methods_with_options

    @property
    def allow_custom_metadata(self):
        """
        Gets the allow_custom_metadata of this PaymentGatewayAccount.
        

        :return: The allow_custom_metadata of this PaymentGatewayAccount.
        :rtype: bool
        """
        return self._allow_custom_metadata

    @allow_custom_metadata.setter
    def allow_custom_metadata(self, allow_custom_metadata):
        """
        Sets the allow_custom_metadata of this PaymentGatewayAccount.
        

        :param allow_custom_metadata: The allow_custom_metadata of this PaymentGatewayAccount.
        :type: bool
        """

        self._allow_custom_metadata = allow_custom_metadata

    @property
    def config(self):
        """
        Gets the config of this PaymentGatewayAccount.

        :return: The config of this PaymentGatewayAccount.
        :rtype: PaymentGatewayAccountSetting
        """
        return self._config

    @config.setter
    def config(self, config):
        """
        Sets the config of this PaymentGatewayAccount.

        :param config: The config of this PaymentGatewayAccount.
        :type: PaymentGatewayAccountSetting
        """

        self._config = config

    @property
    def display_name(self):
        """
        Gets the display_name of this PaymentGatewayAccount.
        

        :return: The display_name of this PaymentGatewayAccount.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PaymentGatewayAccount.
        

        :param display_name: The display_name of this PaymentGatewayAccount.
        :type: str
        """

        self._display_name = display_name

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this PaymentGatewayAccount.
        

        :return: The is_enabled of this PaymentGatewayAccount.
        :rtype: str
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this PaymentGatewayAccount.
        

        :param is_enabled: The is_enabled of this PaymentGatewayAccount.
        :type: str
        """

        self._is_enabled = is_enabled

    @property
    def is_legacy(self):
        """
        Gets the is_legacy of this PaymentGatewayAccount.
        

        :return: The is_legacy of this PaymentGatewayAccount.
        :rtype: str
        """
        return self._is_legacy

    @is_legacy.setter
    def is_legacy(self, is_legacy):
        """
        Sets the is_legacy of this PaymentGatewayAccount.
        

        :param is_legacy: The is_legacy of this PaymentGatewayAccount.
        :type: str
        """

        self._is_legacy = is_legacy

    @property
    def last_modified(self):
        """
        Gets the last_modified of this PaymentGatewayAccount.
        

        :return: The last_modified of this PaymentGatewayAccount.
        :rtype: str
        """
        return self._last_modified

    @last_modified.setter
    def last_modified(self, last_modified):
        """
        Sets the last_modified of this PaymentGatewayAccount.
        

        :param last_modified: The last_modified of this PaymentGatewayAccount.
        :type: str
        """

        self._last_modified = last_modified

    @property
    def payment_gateway(self):
        """
        Gets the payment_gateway of this PaymentGatewayAccount.
        

        :return: The payment_gateway of this PaymentGatewayAccount.
        :rtype: str
        """
        return self._payment_gateway

    @payment_gateway.setter
    def payment_gateway(self, payment_gateway):
        """
        Sets the payment_gateway of this PaymentGatewayAccount.
        

        :param payment_gateway: The payment_gateway of this PaymentGatewayAccount.
        :type: str
        """

        self._payment_gateway = payment_gateway

    @property
    def payment_gateway_account_id(self):
        """
        Gets the payment_gateway_account_id of this PaymentGatewayAccount.
        

        :return: The payment_gateway_account_id of this PaymentGatewayAccount.
        :rtype: str
        """
        return self._payment_gateway_account_id

    @payment_gateway_account_id.setter
    def payment_gateway_account_id(self, payment_gateway_account_id):
        """
        Sets the payment_gateway_account_id of this PaymentGatewayAccount.
        

        :param payment_gateway_account_id: The payment_gateway_account_id of this PaymentGatewayAccount.
        :type: str
        """

        self._payment_gateway_account_id = payment_gateway_account_id

    @property
    def payment_gateway_display_name(self):
        """
        Gets the payment_gateway_display_name of this PaymentGatewayAccount.
        

        :return: The payment_gateway_display_name of this PaymentGatewayAccount.
        :rtype: str
        """
        return self._payment_gateway_display_name

    @payment_gateway_display_name.setter
    def payment_gateway_display_name(self, payment_gateway_display_name):
        """
        Sets the payment_gateway_display_name of this PaymentGatewayAccount.
        

        :param payment_gateway_display_name: The payment_gateway_display_name of this PaymentGatewayAccount.
        :type: str
        """

        self._payment_gateway_display_name = payment_gateway_display_name

    @property
    def pay_pal_legacy_settings(self):
        """
        Gets the pay_pal_legacy_settings of this PaymentGatewayAccount.

        :return: The pay_pal_legacy_settings of this PaymentGatewayAccount.
        :rtype: PayPalLegacySettings
        """
        return self._pay_pal_legacy_settings

    @pay_pal_legacy_settings.setter
    def pay_pal_legacy_settings(self, pay_pal_legacy_settings):
        """
        Sets the pay_pal_legacy_settings of this PaymentGatewayAccount.

        :param pay_pal_legacy_settings: The pay_pal_legacy_settings of this PaymentGatewayAccount.
        :type: PayPalLegacySettings
        """

        self._pay_pal_legacy_settings = pay_pal_legacy_settings

    @property
    def supported_currencies(self):
        """
        Gets the supported_currencies of this PaymentGatewayAccount.
        

        :return: The supported_currencies of this PaymentGatewayAccount.
        :rtype: list[str]
        """
        return self._supported_currencies

    @supported_currencies.setter
    def supported_currencies(self, supported_currencies):
        """
        Sets the supported_currencies of this PaymentGatewayAccount.
        

        :param supported_currencies: The supported_currencies of this PaymentGatewayAccount.
        :type: list[str]
        """

        self._supported_currencies = supported_currencies

    @property
    def supported_payment_methods(self):
        """
        Gets the supported_payment_methods of this PaymentGatewayAccount.
        

        :return: The supported_payment_methods of this PaymentGatewayAccount.
        :rtype: list[str]
        """
        return self._supported_payment_methods

    @supported_payment_methods.setter
    def supported_payment_methods(self, supported_payment_methods):
        """
        Sets the supported_payment_methods of this PaymentGatewayAccount.
        

        :param supported_payment_methods: The supported_payment_methods of this PaymentGatewayAccount.
        :type: list[str]
        """

        self._supported_payment_methods = supported_payment_methods

    @property
    def supported_payment_methods_with_options(self):
        """
        Gets the supported_payment_methods_with_options of this PaymentGatewayAccount.
        

        :return: The supported_payment_methods_with_options of this PaymentGatewayAccount.
        :rtype: list[PaymentMethodWithOptions]
        """
        return self._supported_payment_methods_with_options

    @supported_payment_methods_with_options.setter
    def supported_payment_methods_with_options(self, supported_payment_methods_with_options):
        """
        Sets the supported_payment_methods_with_options of this PaymentGatewayAccount.
        

        :param supported_payment_methods_with_options: The supported_payment_methods_with_options of this PaymentGatewayAccount.
        :type: list[PaymentMethodWithOptions]
        """

        self._supported_payment_methods_with_options = supported_payment_methods_with_options

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
