# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class OfflineAttributes(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, account_esign_id=None, device_model=None, device_name=None, gps_latitude=None, gps_longitude=None, offline_signing_hash=None):
        """
        OfflineAttributes - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'account_esign_id': 'str',
            'device_model': 'str',
            'device_name': 'str',
            'gps_latitude': 'str',
            'gps_longitude': 'str',
            'offline_signing_hash': 'str'
        }

        self.attribute_map = {
            'account_esign_id': 'accountEsignId',
            'device_model': 'deviceModel',
            'device_name': 'deviceName',
            'gps_latitude': 'gpsLatitude',
            'gps_longitude': 'gpsLongitude',
            'offline_signing_hash': 'offlineSigningHash'
        }

        self._account_esign_id = account_esign_id
        self._device_model = device_model
        self._device_name = device_name
        self._gps_latitude = gps_latitude
        self._gps_longitude = gps_longitude
        self._offline_signing_hash = offline_signing_hash

    @property
    def account_esign_id(self):
        """
        Gets the account_esign_id of this OfflineAttributes.
        A GUID identifying the account associated with the consumer disclosure

        :return: The account_esign_id of this OfflineAttributes.
        :rtype: str
        """
        return self._account_esign_id

    @account_esign_id.setter
    def account_esign_id(self, account_esign_id):
        """
        Sets the account_esign_id of this OfflineAttributes.
        A GUID identifying the account associated with the consumer disclosure

        :param account_esign_id: The account_esign_id of this OfflineAttributes.
        :type: str
        """

        self._account_esign_id = account_esign_id

    @property
    def device_model(self):
        """
        Gets the device_model of this OfflineAttributes.
        A string containing information about the model of the device used for offline signing.

        :return: The device_model of this OfflineAttributes.
        :rtype: str
        """
        return self._device_model

    @device_model.setter
    def device_model(self, device_model):
        """
        Sets the device_model of this OfflineAttributes.
        A string containing information about the model of the device used for offline signing.

        :param device_model: The device_model of this OfflineAttributes.
        :type: str
        """

        self._device_model = device_model

    @property
    def device_name(self):
        """
        Gets the device_name of this OfflineAttributes.
        A string containing information about the type of device used for offline signing.

        :return: The device_name of this OfflineAttributes.
        :rtype: str
        """
        return self._device_name

    @device_name.setter
    def device_name(self, device_name):
        """
        Sets the device_name of this OfflineAttributes.
        A string containing information about the type of device used for offline signing.

        :param device_name: The device_name of this OfflineAttributes.
        :type: str
        """

        self._device_name = device_name

    @property
    def gps_latitude(self):
        """
        Gets the gps_latitude of this OfflineAttributes.
        A string containing the latitude of the device location at the time of signing.

        :return: The gps_latitude of this OfflineAttributes.
        :rtype: str
        """
        return self._gps_latitude

    @gps_latitude.setter
    def gps_latitude(self, gps_latitude):
        """
        Sets the gps_latitude of this OfflineAttributes.
        A string containing the latitude of the device location at the time of signing.

        :param gps_latitude: The gps_latitude of this OfflineAttributes.
        :type: str
        """

        self._gps_latitude = gps_latitude

    @property
    def gps_longitude(self):
        """
        Gets the gps_longitude of this OfflineAttributes.
        A string containing the longitude of the device location at the time of signing.

        :return: The gps_longitude of this OfflineAttributes.
        :rtype: str
        """
        return self._gps_longitude

    @gps_longitude.setter
    def gps_longitude(self, gps_longitude):
        """
        Sets the gps_longitude of this OfflineAttributes.
        A string containing the longitude of the device location at the time of signing.

        :param gps_longitude: The gps_longitude of this OfflineAttributes.
        :type: str
        """

        self._gps_longitude = gps_longitude

    @property
    def offline_signing_hash(self):
        """
        Gets the offline_signing_hash of this OfflineAttributes.
        

        :return: The offline_signing_hash of this OfflineAttributes.
        :rtype: str
        """
        return self._offline_signing_hash

    @offline_signing_hash.setter
    def offline_signing_hash(self, offline_signing_hash):
        """
        Sets the offline_signing_hash of this OfflineAttributes.
        

        :param offline_signing_hash: The offline_signing_hash of this OfflineAttributes.
        :type: str
        """

        self._offline_signing_hash = offline_signing_hash

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
