# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class InlineTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, custom_fields=None, documents=None, envelope=None, recipients=None, sequence=None):
        """
        InlineTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'custom_fields': 'CustomFields',
            'documents': 'list[Document]',
            'envelope': 'Envelope',
            'recipients': 'Recipients',
            'sequence': 'str'
        }

        self.attribute_map = {
            'custom_fields': 'customFields',
            'documents': 'documents',
            'envelope': 'envelope',
            'recipients': 'recipients',
            'sequence': 'sequence'
        }

        self._custom_fields = custom_fields
        self._documents = documents
        self._envelope = envelope
        self._recipients = recipients
        self._sequence = sequence

    @property
    def custom_fields(self):
        """
        Gets the custom_fields of this InlineTemplate.

        :return: The custom_fields of this InlineTemplate.
        :rtype: CustomFields
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """
        Sets the custom_fields of this InlineTemplate.

        :param custom_fields: The custom_fields of this InlineTemplate.
        :type: CustomFields
        """

        self._custom_fields = custom_fields

    @property
    def documents(self):
        """
        Gets the documents of this InlineTemplate.
        Complex element contains the details on the documents in the envelope.

        :return: The documents of this InlineTemplate.
        :rtype: list[Document]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this InlineTemplate.
        Complex element contains the details on the documents in the envelope.

        :param documents: The documents of this InlineTemplate.
        :type: list[Document]
        """

        self._documents = documents

    @property
    def envelope(self):
        """
        Gets the envelope of this InlineTemplate.

        :return: The envelope of this InlineTemplate.
        :rtype: Envelope
        """
        return self._envelope

    @envelope.setter
    def envelope(self, envelope):
        """
        Sets the envelope of this InlineTemplate.

        :param envelope: The envelope of this InlineTemplate.
        :type: Envelope
        """

        self._envelope = envelope

    @property
    def recipients(self):
        """
        Gets the recipients of this InlineTemplate.

        :return: The recipients of this InlineTemplate.
        :rtype: Recipients
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """
        Sets the recipients of this InlineTemplate.

        :param recipients: The recipients of this InlineTemplate.
        :type: Recipients
        """

        self._recipients = recipients

    @property
    def sequence(self):
        """
        Gets the sequence of this InlineTemplate.
        Specifies the order in which templates are overlaid.

        :return: The sequence of this InlineTemplate.
        :rtype: str
        """
        return self._sequence

    @sequence.setter
    def sequence(self, sequence):
        """
        Sets the sequence of this InlineTemplate.
        Specifies the order in which templates are overlaid.

        :param sequence: The sequence of this InlineTemplate.
        :type: str
        """

        self._sequence = sequence

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
