# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EnvelopeTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, access_control_list_base64=None, allow_comments=None, allow_markup=None, allow_reassign=None, allow_view_history=None, any_signer=None, asynchronous=None, attachments_uri=None, authoritative_copy=None, authoritative_copy_default=None, auto_match=None, auto_match_specified_by_user=None, auto_navigation=None, brand_id=None, brand_lock=None, certificate_uri=None, completed_date_time=None, copy_recipient_data=None, created=None, created_date_time=None, custom_fields=None, custom_fields_uri=None, declined_date_time=None, deleted_date_time=None, delivered_date_time=None, description=None, disable_responsive_document=None, documents=None, documents_combined_uri=None, documents_uri=None, email_blurb=None, email_settings=None, email_subject=None, enable_wet_sign=None, enforce_signer_visibility=None, envelope_attachments=None, envelope_documents=None, envelope_id=None, envelope_id_stamping=None, envelope_location=None, envelope_metadata=None, envelope_uri=None, expire_after=None, expire_date_time=None, expire_enabled=None, external_envelope_id=None, favorited_by_me=None, folder_id=None, folder_ids=None, folder_name=None, folders=None, has_comments=None, has_form_data_changed=None, has_wav_file=None, holder=None, initial_sent_date_time=None, is21_cfr_part11=None, is_dynamic_envelope=None, is_signature_provider_envelope=None, last_modified=None, last_modified_by=None, last_modified_date_time=None, last_used=None, location=None, lock_information=None, message_lock=None, name=None, new_password=None, notification=None, notification_uri=None, owner=None, page_count=None, password=None, password_protected=None, power_form=None, power_forms=None, purge_completed_date=None, purge_request_date=None, purge_state=None, recipients=None, recipients_lock=None, recipients_uri=None, sender=None, sent_date_time=None, shared=None, signer_can_sign_on_mobile=None, signing_location=None, status=None, status_changed_date_time=None, status_date_time=None, template_id=None, templates_uri=None, transaction_id=None, uri=None, use_disclosure=None, voided_date_time=None, voided_reason=None):
        """
        EnvelopeTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'access_control_list_base64': 'str',
            'allow_comments': 'str',
            'allow_markup': 'str',
            'allow_reassign': 'str',
            'allow_view_history': 'str',
            'any_signer': 'str',
            'asynchronous': 'str',
            'attachments_uri': 'str',
            'authoritative_copy': 'str',
            'authoritative_copy_default': 'str',
            'auto_match': 'str',
            'auto_match_specified_by_user': 'str',
            'auto_navigation': 'str',
            'brand_id': 'str',
            'brand_lock': 'str',
            'certificate_uri': 'str',
            'completed_date_time': 'str',
            'copy_recipient_data': 'str',
            'created': 'str',
            'created_date_time': 'str',
            'custom_fields': 'CustomFields',
            'custom_fields_uri': 'str',
            'declined_date_time': 'str',
            'deleted_date_time': 'str',
            'delivered_date_time': 'str',
            'description': 'str',
            'disable_responsive_document': 'str',
            'documents': 'list[Document]',
            'documents_combined_uri': 'str',
            'documents_uri': 'str',
            'email_blurb': 'str',
            'email_settings': 'EmailSettings',
            'email_subject': 'str',
            'enable_wet_sign': 'str',
            'enforce_signer_visibility': 'str',
            'envelope_attachments': 'list[Attachment]',
            'envelope_documents': 'list[EnvelopeDocument]',
            'envelope_id': 'str',
            'envelope_id_stamping': 'str',
            'envelope_location': 'str',
            'envelope_metadata': 'EnvelopeMetadata',
            'envelope_uri': 'str',
            'expire_after': 'str',
            'expire_date_time': 'str',
            'expire_enabled': 'str',
            'external_envelope_id': 'str',
            'favorited_by_me': 'str',
            'folder_id': 'str',
            'folder_ids': 'list[str]',
            'folder_name': 'str',
            'folders': 'list[Folder]',
            'has_comments': 'str',
            'has_form_data_changed': 'str',
            'has_wav_file': 'str',
            'holder': 'str',
            'initial_sent_date_time': 'str',
            'is21_cfr_part11': 'str',
            'is_dynamic_envelope': 'str',
            'is_signature_provider_envelope': 'str',
            'last_modified': 'str',
            'last_modified_by': 'UserInfo',
            'last_modified_date_time': 'str',
            'last_used': 'str',
            'location': 'str',
            'lock_information': 'LockInformation',
            'message_lock': 'str',
            'name': 'str',
            'new_password': 'str',
            'notification': 'Notification',
            'notification_uri': 'str',
            'owner': 'UserInfo',
            'page_count': 'str',
            'password': 'str',
            'password_protected': 'str',
            'power_form': 'PowerForm',
            'power_forms': 'list[PowerForm]',
            'purge_completed_date': 'str',
            'purge_request_date': 'str',
            'purge_state': 'str',
            'recipients': 'Recipients',
            'recipients_lock': 'str',
            'recipients_uri': 'str',
            'sender': 'UserInfo',
            'sent_date_time': 'str',
            'shared': 'str',
            'signer_can_sign_on_mobile': 'str',
            'signing_location': 'str',
            'status': 'str',
            'status_changed_date_time': 'str',
            'status_date_time': 'str',
            'template_id': 'str',
            'templates_uri': 'str',
            'transaction_id': 'str',
            'uri': 'str',
            'use_disclosure': 'str',
            'voided_date_time': 'str',
            'voided_reason': 'str'
        }

        self.attribute_map = {
            'access_control_list_base64': 'accessControlListBase64',
            'allow_comments': 'allowComments',
            'allow_markup': 'allowMarkup',
            'allow_reassign': 'allowReassign',
            'allow_view_history': 'allowViewHistory',
            'any_signer': 'anySigner',
            'asynchronous': 'asynchronous',
            'attachments_uri': 'attachmentsUri',
            'authoritative_copy': 'authoritativeCopy',
            'authoritative_copy_default': 'authoritativeCopyDefault',
            'auto_match': 'autoMatch',
            'auto_match_specified_by_user': 'autoMatchSpecifiedByUser',
            'auto_navigation': 'autoNavigation',
            'brand_id': 'brandId',
            'brand_lock': 'brandLock',
            'certificate_uri': 'certificateUri',
            'completed_date_time': 'completedDateTime',
            'copy_recipient_data': 'copyRecipientData',
            'created': 'created',
            'created_date_time': 'createdDateTime',
            'custom_fields': 'customFields',
            'custom_fields_uri': 'customFieldsUri',
            'declined_date_time': 'declinedDateTime',
            'deleted_date_time': 'deletedDateTime',
            'delivered_date_time': 'deliveredDateTime',
            'description': 'description',
            'disable_responsive_document': 'disableResponsiveDocument',
            'documents': 'documents',
            'documents_combined_uri': 'documentsCombinedUri',
            'documents_uri': 'documentsUri',
            'email_blurb': 'emailBlurb',
            'email_settings': 'emailSettings',
            'email_subject': 'emailSubject',
            'enable_wet_sign': 'enableWetSign',
            'enforce_signer_visibility': 'enforceSignerVisibility',
            'envelope_attachments': 'envelopeAttachments',
            'envelope_documents': 'envelopeDocuments',
            'envelope_id': 'envelopeId',
            'envelope_id_stamping': 'envelopeIdStamping',
            'envelope_location': 'envelopeLocation',
            'envelope_metadata': 'envelopeMetadata',
            'envelope_uri': 'envelopeUri',
            'expire_after': 'expireAfter',
            'expire_date_time': 'expireDateTime',
            'expire_enabled': 'expireEnabled',
            'external_envelope_id': 'externalEnvelopeId',
            'favorited_by_me': 'favoritedByMe',
            'folder_id': 'folderId',
            'folder_ids': 'folderIds',
            'folder_name': 'folderName',
            'folders': 'folders',
            'has_comments': 'hasComments',
            'has_form_data_changed': 'hasFormDataChanged',
            'has_wav_file': 'hasWavFile',
            'holder': 'holder',
            'initial_sent_date_time': 'initialSentDateTime',
            'is21_cfr_part11': 'is21CFRPart11',
            'is_dynamic_envelope': 'isDynamicEnvelope',
            'is_signature_provider_envelope': 'isSignatureProviderEnvelope',
            'last_modified': 'lastModified',
            'last_modified_by': 'lastModifiedBy',
            'last_modified_date_time': 'lastModifiedDateTime',
            'last_used': 'lastUsed',
            'location': 'location',
            'lock_information': 'lockInformation',
            'message_lock': 'messageLock',
            'name': 'name',
            'new_password': 'newPassword',
            'notification': 'notification',
            'notification_uri': 'notificationUri',
            'owner': 'owner',
            'page_count': 'pageCount',
            'password': 'password',
            'password_protected': 'passwordProtected',
            'power_form': 'powerForm',
            'power_forms': 'powerForms',
            'purge_completed_date': 'purgeCompletedDate',
            'purge_request_date': 'purgeRequestDate',
            'purge_state': 'purgeState',
            'recipients': 'recipients',
            'recipients_lock': 'recipientsLock',
            'recipients_uri': 'recipientsUri',
            'sender': 'sender',
            'sent_date_time': 'sentDateTime',
            'shared': 'shared',
            'signer_can_sign_on_mobile': 'signerCanSignOnMobile',
            'signing_location': 'signingLocation',
            'status': 'status',
            'status_changed_date_time': 'statusChangedDateTime',
            'status_date_time': 'statusDateTime',
            'template_id': 'templateId',
            'templates_uri': 'templatesUri',
            'transaction_id': 'transactionId',
            'uri': 'uri',
            'use_disclosure': 'useDisclosure',
            'voided_date_time': 'voidedDateTime',
            'voided_reason': 'voidedReason'
        }

        self._access_control_list_base64 = access_control_list_base64
        self._allow_comments = allow_comments
        self._allow_markup = allow_markup
        self._allow_reassign = allow_reassign
        self._allow_view_history = allow_view_history
        self._any_signer = any_signer
        self._asynchronous = asynchronous
        self._attachments_uri = attachments_uri
        self._authoritative_copy = authoritative_copy
        self._authoritative_copy_default = authoritative_copy_default
        self._auto_match = auto_match
        self._auto_match_specified_by_user = auto_match_specified_by_user
        self._auto_navigation = auto_navigation
        self._brand_id = brand_id
        self._brand_lock = brand_lock
        self._certificate_uri = certificate_uri
        self._completed_date_time = completed_date_time
        self._copy_recipient_data = copy_recipient_data
        self._created = created
        self._created_date_time = created_date_time
        self._custom_fields = custom_fields
        self._custom_fields_uri = custom_fields_uri
        self._declined_date_time = declined_date_time
        self._deleted_date_time = deleted_date_time
        self._delivered_date_time = delivered_date_time
        self._description = description
        self._disable_responsive_document = disable_responsive_document
        self._documents = documents
        self._documents_combined_uri = documents_combined_uri
        self._documents_uri = documents_uri
        self._email_blurb = email_blurb
        self._email_settings = email_settings
        self._email_subject = email_subject
        self._enable_wet_sign = enable_wet_sign
        self._enforce_signer_visibility = enforce_signer_visibility
        self._envelope_attachments = envelope_attachments
        self._envelope_documents = envelope_documents
        self._envelope_id = envelope_id
        self._envelope_id_stamping = envelope_id_stamping
        self._envelope_location = envelope_location
        self._envelope_metadata = envelope_metadata
        self._envelope_uri = envelope_uri
        self._expire_after = expire_after
        self._expire_date_time = expire_date_time
        self._expire_enabled = expire_enabled
        self._external_envelope_id = external_envelope_id
        self._favorited_by_me = favorited_by_me
        self._folder_id = folder_id
        self._folder_ids = folder_ids
        self._folder_name = folder_name
        self._folders = folders
        self._has_comments = has_comments
        self._has_form_data_changed = has_form_data_changed
        self._has_wav_file = has_wav_file
        self._holder = holder
        self._initial_sent_date_time = initial_sent_date_time
        self._is21_cfr_part11 = is21_cfr_part11
        self._is_dynamic_envelope = is_dynamic_envelope
        self._is_signature_provider_envelope = is_signature_provider_envelope
        self._last_modified = last_modified
        self._last_modified_by = last_modified_by
        self._last_modified_date_time = last_modified_date_time
        self._last_used = last_used
        self._location = location
        self._lock_information = lock_information
        self._message_lock = message_lock
        self._name = name
        self._new_password = new_password
        self._notification = notification
        self._notification_uri = notification_uri
        self._owner = owner
        self._page_count = page_count
        self._password = password
        self._password_protected = password_protected
        self._power_form = power_form
        self._power_forms = power_forms
        self._purge_completed_date = purge_completed_date
        self._purge_request_date = purge_request_date
        self._purge_state = purge_state
        self._recipients = recipients
        self._recipients_lock = recipients_lock
        self._recipients_uri = recipients_uri
        self._sender = sender
        self._sent_date_time = sent_date_time
        self._shared = shared
        self._signer_can_sign_on_mobile = signer_can_sign_on_mobile
        self._signing_location = signing_location
        self._status = status
        self._status_changed_date_time = status_changed_date_time
        self._status_date_time = status_date_time
        self._template_id = template_id
        self._templates_uri = templates_uri
        self._transaction_id = transaction_id
        self._uri = uri
        self._use_disclosure = use_disclosure
        self._voided_date_time = voided_date_time
        self._voided_reason = voided_reason

    @property
    def access_control_list_base64(self):
        """
        Gets the access_control_list_base64 of this EnvelopeTemplate.
        

        :return: The access_control_list_base64 of this EnvelopeTemplate.
        :rtype: str
        """
        return self._access_control_list_base64

    @access_control_list_base64.setter
    def access_control_list_base64(self, access_control_list_base64):
        """
        Sets the access_control_list_base64 of this EnvelopeTemplate.
        

        :param access_control_list_base64: The access_control_list_base64 of this EnvelopeTemplate.
        :type: str
        """

        self._access_control_list_base64 = access_control_list_base64

    @property
    def allow_comments(self):
        """
        Gets the allow_comments of this EnvelopeTemplate.
        

        :return: The allow_comments of this EnvelopeTemplate.
        :rtype: str
        """
        return self._allow_comments

    @allow_comments.setter
    def allow_comments(self, allow_comments):
        """
        Sets the allow_comments of this EnvelopeTemplate.
        

        :param allow_comments: The allow_comments of this EnvelopeTemplate.
        :type: str
        """

        self._allow_comments = allow_comments

    @property
    def allow_markup(self):
        """
        Gets the allow_markup of this EnvelopeTemplate.
        When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this

        :return: The allow_markup of this EnvelopeTemplate.
        :rtype: str
        """
        return self._allow_markup

    @allow_markup.setter
    def allow_markup(self, allow_markup):
        """
        Sets the allow_markup of this EnvelopeTemplate.
        When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this

        :param allow_markup: The allow_markup of this EnvelopeTemplate.
        :type: str
        """

        self._allow_markup = allow_markup

    @property
    def allow_reassign(self):
        """
        Gets the allow_reassign of this EnvelopeTemplate.
        When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.

        :return: The allow_reassign of this EnvelopeTemplate.
        :rtype: str
        """
        return self._allow_reassign

    @allow_reassign.setter
    def allow_reassign(self, allow_reassign):
        """
        Sets the allow_reassign of this EnvelopeTemplate.
        When set to **true**, the recipient can redirect an envelope to a more appropriate recipient.

        :param allow_reassign: The allow_reassign of this EnvelopeTemplate.
        :type: str
        """

        self._allow_reassign = allow_reassign

    @property
    def allow_view_history(self):
        """
        Gets the allow_view_history of this EnvelopeTemplate.
        

        :return: The allow_view_history of this EnvelopeTemplate.
        :rtype: str
        """
        return self._allow_view_history

    @allow_view_history.setter
    def allow_view_history(self, allow_view_history):
        """
        Sets the allow_view_history of this EnvelopeTemplate.
        

        :param allow_view_history: The allow_view_history of this EnvelopeTemplate.
        :type: str
        """

        self._allow_view_history = allow_view_history

    @property
    def any_signer(self):
        """
        Gets the any_signer of this EnvelopeTemplate.
        

        :return: The any_signer of this EnvelopeTemplate.
        :rtype: str
        """
        return self._any_signer

    @any_signer.setter
    def any_signer(self, any_signer):
        """
        Sets the any_signer of this EnvelopeTemplate.
        

        :param any_signer: The any_signer of this EnvelopeTemplate.
        :type: str
        """

        self._any_signer = any_signer

    @property
    def asynchronous(self):
        """
        Gets the asynchronous of this EnvelopeTemplate.
        When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.

        :return: The asynchronous of this EnvelopeTemplate.
        :rtype: str
        """
        return self._asynchronous

    @asynchronous.setter
    def asynchronous(self, asynchronous):
        """
        Sets the asynchronous of this EnvelopeTemplate.
        When set to **true**, the envelope is queued for processing and the value of the `status` property is set to 'Processing'. Additionally, get status calls return 'Processing' until completed.

        :param asynchronous: The asynchronous of this EnvelopeTemplate.
        :type: str
        """

        self._asynchronous = asynchronous

    @property
    def attachments_uri(self):
        """
        Gets the attachments_uri of this EnvelopeTemplate.
        

        :return: The attachments_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._attachments_uri

    @attachments_uri.setter
    def attachments_uri(self, attachments_uri):
        """
        Sets the attachments_uri of this EnvelopeTemplate.
        

        :param attachments_uri: The attachments_uri of this EnvelopeTemplate.
        :type: str
        """

        self._attachments_uri = attachments_uri

    @property
    def authoritative_copy(self):
        """
        Gets the authoritative_copy of this EnvelopeTemplate.
        Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.

        :return: The authoritative_copy of this EnvelopeTemplate.
        :rtype: str
        """
        return self._authoritative_copy

    @authoritative_copy.setter
    def authoritative_copy(self, authoritative_copy):
        """
        Sets the authoritative_copy of this EnvelopeTemplate.
        Specifies the Authoritative copy feature. If set to true the Authoritative copy feature is enabled.

        :param authoritative_copy: The authoritative_copy of this EnvelopeTemplate.
        :type: str
        """

        self._authoritative_copy = authoritative_copy

    @property
    def authoritative_copy_default(self):
        """
        Gets the authoritative_copy_default of this EnvelopeTemplate.
        

        :return: The authoritative_copy_default of this EnvelopeTemplate.
        :rtype: str
        """
        return self._authoritative_copy_default

    @authoritative_copy_default.setter
    def authoritative_copy_default(self, authoritative_copy_default):
        """
        Sets the authoritative_copy_default of this EnvelopeTemplate.
        

        :param authoritative_copy_default: The authoritative_copy_default of this EnvelopeTemplate.
        :type: str
        """

        self._authoritative_copy_default = authoritative_copy_default

    @property
    def auto_match(self):
        """
        Gets the auto_match of this EnvelopeTemplate.
        

        :return: The auto_match of this EnvelopeTemplate.
        :rtype: str
        """
        return self._auto_match

    @auto_match.setter
    def auto_match(self, auto_match):
        """
        Sets the auto_match of this EnvelopeTemplate.
        

        :param auto_match: The auto_match of this EnvelopeTemplate.
        :type: str
        """

        self._auto_match = auto_match

    @property
    def auto_match_specified_by_user(self):
        """
        Gets the auto_match_specified_by_user of this EnvelopeTemplate.
        

        :return: The auto_match_specified_by_user of this EnvelopeTemplate.
        :rtype: str
        """
        return self._auto_match_specified_by_user

    @auto_match_specified_by_user.setter
    def auto_match_specified_by_user(self, auto_match_specified_by_user):
        """
        Sets the auto_match_specified_by_user of this EnvelopeTemplate.
        

        :param auto_match_specified_by_user: The auto_match_specified_by_user of this EnvelopeTemplate.
        :type: str
        """

        self._auto_match_specified_by_user = auto_match_specified_by_user

    @property
    def auto_navigation(self):
        """
        Gets the auto_navigation of this EnvelopeTemplate.
        

        :return: The auto_navigation of this EnvelopeTemplate.
        :rtype: str
        """
        return self._auto_navigation

    @auto_navigation.setter
    def auto_navigation(self, auto_navigation):
        """
        Sets the auto_navigation of this EnvelopeTemplate.
        

        :param auto_navigation: The auto_navigation of this EnvelopeTemplate.
        :type: str
        """

        self._auto_navigation = auto_navigation

    @property
    def brand_id(self):
        """
        Gets the brand_id of this EnvelopeTemplate.
        

        :return: The brand_id of this EnvelopeTemplate.
        :rtype: str
        """
        return self._brand_id

    @brand_id.setter
    def brand_id(self, brand_id):
        """
        Sets the brand_id of this EnvelopeTemplate.
        

        :param brand_id: The brand_id of this EnvelopeTemplate.
        :type: str
        """

        self._brand_id = brand_id

    @property
    def brand_lock(self):
        """
        Gets the brand_lock of this EnvelopeTemplate.
        

        :return: The brand_lock of this EnvelopeTemplate.
        :rtype: str
        """
        return self._brand_lock

    @brand_lock.setter
    def brand_lock(self, brand_lock):
        """
        Sets the brand_lock of this EnvelopeTemplate.
        

        :param brand_lock: The brand_lock of this EnvelopeTemplate.
        :type: str
        """

        self._brand_lock = brand_lock

    @property
    def certificate_uri(self):
        """
        Gets the certificate_uri of this EnvelopeTemplate.
        Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.

        :return: The certificate_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._certificate_uri

    @certificate_uri.setter
    def certificate_uri(self, certificate_uri):
        """
        Sets the certificate_uri of this EnvelopeTemplate.
        Retrieves a URI for an endpoint that allows you to easily retrieve certificate information.

        :param certificate_uri: The certificate_uri of this EnvelopeTemplate.
        :type: str
        """

        self._certificate_uri = certificate_uri

    @property
    def completed_date_time(self):
        """
        Gets the completed_date_time of this EnvelopeTemplate.
        Specifies the date and time this item was completed.

        :return: The completed_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._completed_date_time

    @completed_date_time.setter
    def completed_date_time(self, completed_date_time):
        """
        Sets the completed_date_time of this EnvelopeTemplate.
        Specifies the date and time this item was completed.

        :param completed_date_time: The completed_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._completed_date_time = completed_date_time

    @property
    def copy_recipient_data(self):
        """
        Gets the copy_recipient_data of this EnvelopeTemplate.
        

        :return: The copy_recipient_data of this EnvelopeTemplate.
        :rtype: str
        """
        return self._copy_recipient_data

    @copy_recipient_data.setter
    def copy_recipient_data(self, copy_recipient_data):
        """
        Sets the copy_recipient_data of this EnvelopeTemplate.
        

        :param copy_recipient_data: The copy_recipient_data of this EnvelopeTemplate.
        :type: str
        """

        self._copy_recipient_data = copy_recipient_data

    @property
    def created(self):
        """
        Gets the created of this EnvelopeTemplate.
        

        :return: The created of this EnvelopeTemplate.
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """
        Sets the created of this EnvelopeTemplate.
        

        :param created: The created of this EnvelopeTemplate.
        :type: str
        """

        self._created = created

    @property
    def created_date_time(self):
        """
        Gets the created_date_time of this EnvelopeTemplate.
        Indicates the date and time the item was created.

        :return: The created_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """
        Sets the created_date_time of this EnvelopeTemplate.
        Indicates the date and time the item was created.

        :param created_date_time: The created_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._created_date_time = created_date_time

    @property
    def custom_fields(self):
        """
        Gets the custom_fields of this EnvelopeTemplate.

        :return: The custom_fields of this EnvelopeTemplate.
        :rtype: CustomFields
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """
        Sets the custom_fields of this EnvelopeTemplate.

        :param custom_fields: The custom_fields of this EnvelopeTemplate.
        :type: CustomFields
        """

        self._custom_fields = custom_fields

    @property
    def custom_fields_uri(self):
        """
        Gets the custom_fields_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the custom fields.

        :return: The custom_fields_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._custom_fields_uri

    @custom_fields_uri.setter
    def custom_fields_uri(self, custom_fields_uri):
        """
        Sets the custom_fields_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the custom fields.

        :param custom_fields_uri: The custom_fields_uri of this EnvelopeTemplate.
        :type: str
        """

        self._custom_fields_uri = custom_fields_uri

    @property
    def declined_date_time(self):
        """
        Gets the declined_date_time of this EnvelopeTemplate.
        The date and time the recipient declined the document.

        :return: The declined_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._declined_date_time

    @declined_date_time.setter
    def declined_date_time(self, declined_date_time):
        """
        Sets the declined_date_time of this EnvelopeTemplate.
        The date and time the recipient declined the document.

        :param declined_date_time: The declined_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._declined_date_time = declined_date_time

    @property
    def deleted_date_time(self):
        """
        Gets the deleted_date_time of this EnvelopeTemplate.
        Specifies the data and time the item was deleted.

        :return: The deleted_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._deleted_date_time

    @deleted_date_time.setter
    def deleted_date_time(self, deleted_date_time):
        """
        Sets the deleted_date_time of this EnvelopeTemplate.
        Specifies the data and time the item was deleted.

        :param deleted_date_time: The deleted_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._deleted_date_time = deleted_date_time

    @property
    def delivered_date_time(self):
        """
        Gets the delivered_date_time of this EnvelopeTemplate.
        Reserved: For DocuSign use only.

        :return: The delivered_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._delivered_date_time

    @delivered_date_time.setter
    def delivered_date_time(self, delivered_date_time):
        """
        Sets the delivered_date_time of this EnvelopeTemplate.
        Reserved: For DocuSign use only.

        :param delivered_date_time: The delivered_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._delivered_date_time = delivered_date_time

    @property
    def description(self):
        """
        Gets the description of this EnvelopeTemplate.
        

        :return: The description of this EnvelopeTemplate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EnvelopeTemplate.
        

        :param description: The description of this EnvelopeTemplate.
        :type: str
        """

        self._description = description

    @property
    def disable_responsive_document(self):
        """
        Gets the disable_responsive_document of this EnvelopeTemplate.
        

        :return: The disable_responsive_document of this EnvelopeTemplate.
        :rtype: str
        """
        return self._disable_responsive_document

    @disable_responsive_document.setter
    def disable_responsive_document(self, disable_responsive_document):
        """
        Sets the disable_responsive_document of this EnvelopeTemplate.
        

        :param disable_responsive_document: The disable_responsive_document of this EnvelopeTemplate.
        :type: str
        """

        self._disable_responsive_document = disable_responsive_document

    @property
    def documents(self):
        """
        Gets the documents of this EnvelopeTemplate.
        Complex element contains the details on the documents in the envelope.

        :return: The documents of this EnvelopeTemplate.
        :rtype: list[Document]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this EnvelopeTemplate.
        Complex element contains the details on the documents in the envelope.

        :param documents: The documents of this EnvelopeTemplate.
        :type: list[Document]
        """

        self._documents = documents

    @property
    def documents_combined_uri(self):
        """
        Gets the documents_combined_uri of this EnvelopeTemplate.
        

        :return: The documents_combined_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._documents_combined_uri

    @documents_combined_uri.setter
    def documents_combined_uri(self, documents_combined_uri):
        """
        Sets the documents_combined_uri of this EnvelopeTemplate.
        

        :param documents_combined_uri: The documents_combined_uri of this EnvelopeTemplate.
        :type: str
        """

        self._documents_combined_uri = documents_combined_uri

    @property
    def documents_uri(self):
        """
        Gets the documents_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the documents.

        :return: The documents_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._documents_uri

    @documents_uri.setter
    def documents_uri(self, documents_uri):
        """
        Sets the documents_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the documents.

        :param documents_uri: The documents_uri of this EnvelopeTemplate.
        :type: str
        """

        self._documents_uri = documents_uri

    @property
    def email_blurb(self):
        """
        Gets the email_blurb of this EnvelopeTemplate.
        

        :return: The email_blurb of this EnvelopeTemplate.
        :rtype: str
        """
        return self._email_blurb

    @email_blurb.setter
    def email_blurb(self, email_blurb):
        """
        Sets the email_blurb of this EnvelopeTemplate.
        

        :param email_blurb: The email_blurb of this EnvelopeTemplate.
        :type: str
        """

        self._email_blurb = email_blurb

    @property
    def email_settings(self):
        """
        Gets the email_settings of this EnvelopeTemplate.

        :return: The email_settings of this EnvelopeTemplate.
        :rtype: EmailSettings
        """
        return self._email_settings

    @email_settings.setter
    def email_settings(self, email_settings):
        """
        Sets the email_settings of this EnvelopeTemplate.

        :param email_settings: The email_settings of this EnvelopeTemplate.
        :type: EmailSettings
        """

        self._email_settings = email_settings

    @property
    def email_subject(self):
        """
        Gets the email_subject of this EnvelopeTemplate.
        Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.

        :return: The email_subject of this EnvelopeTemplate.
        :rtype: str
        """
        return self._email_subject

    @email_subject.setter
    def email_subject(self, email_subject):
        """
        Sets the email_subject of this EnvelopeTemplate.
        Specifies the subject of the email that is sent to all recipients.  See [ML:Template Email Subject Merge Fields] for information about adding merge field information to the email subject.

        :param email_subject: The email_subject of this EnvelopeTemplate.
        :type: str
        """

        self._email_subject = email_subject

    @property
    def enable_wet_sign(self):
        """
        Gets the enable_wet_sign of this EnvelopeTemplate.
        When set to **true**, the signer is allowed to print the document and sign it on paper.

        :return: The enable_wet_sign of this EnvelopeTemplate.
        :rtype: str
        """
        return self._enable_wet_sign

    @enable_wet_sign.setter
    def enable_wet_sign(self, enable_wet_sign):
        """
        Sets the enable_wet_sign of this EnvelopeTemplate.
        When set to **true**, the signer is allowed to print the document and sign it on paper.

        :param enable_wet_sign: The enable_wet_sign of this EnvelopeTemplate.
        :type: str
        """

        self._enable_wet_sign = enable_wet_sign

    @property
    def enforce_signer_visibility(self):
        """
        Gets the enforce_signer_visibility of this EnvelopeTemplate.
        When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.

        :return: The enforce_signer_visibility of this EnvelopeTemplate.
        :rtype: str
        """
        return self._enforce_signer_visibility

    @enforce_signer_visibility.setter
    def enforce_signer_visibility(self, enforce_signer_visibility):
        """
        Sets the enforce_signer_visibility of this EnvelopeTemplate.
        When set to **true**, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.  Your account must have Document Visibility enabled to use this.

        :param enforce_signer_visibility: The enforce_signer_visibility of this EnvelopeTemplate.
        :type: str
        """

        self._enforce_signer_visibility = enforce_signer_visibility

    @property
    def envelope_attachments(self):
        """
        Gets the envelope_attachments of this EnvelopeTemplate.
        

        :return: The envelope_attachments of this EnvelopeTemplate.
        :rtype: list[Attachment]
        """
        return self._envelope_attachments

    @envelope_attachments.setter
    def envelope_attachments(self, envelope_attachments):
        """
        Sets the envelope_attachments of this EnvelopeTemplate.
        

        :param envelope_attachments: The envelope_attachments of this EnvelopeTemplate.
        :type: list[Attachment]
        """

        self._envelope_attachments = envelope_attachments

    @property
    def envelope_documents(self):
        """
        Gets the envelope_documents of this EnvelopeTemplate.
        

        :return: The envelope_documents of this EnvelopeTemplate.
        :rtype: list[EnvelopeDocument]
        """
        return self._envelope_documents

    @envelope_documents.setter
    def envelope_documents(self, envelope_documents):
        """
        Sets the envelope_documents of this EnvelopeTemplate.
        

        :param envelope_documents: The envelope_documents of this EnvelopeTemplate.
        :type: list[EnvelopeDocument]
        """

        self._envelope_documents = envelope_documents

    @property
    def envelope_id(self):
        """
        Gets the envelope_id of this EnvelopeTemplate.
        The envelope ID of the envelope status that failed to post.

        :return: The envelope_id of this EnvelopeTemplate.
        :rtype: str
        """
        return self._envelope_id

    @envelope_id.setter
    def envelope_id(self, envelope_id):
        """
        Sets the envelope_id of this EnvelopeTemplate.
        The envelope ID of the envelope status that failed to post.

        :param envelope_id: The envelope_id of this EnvelopeTemplate.
        :type: str
        """

        self._envelope_id = envelope_id

    @property
    def envelope_id_stamping(self):
        """
        Gets the envelope_id_stamping of this EnvelopeTemplate.
        When set to **true**, Envelope ID Stamping is enabled.

        :return: The envelope_id_stamping of this EnvelopeTemplate.
        :rtype: str
        """
        return self._envelope_id_stamping

    @envelope_id_stamping.setter
    def envelope_id_stamping(self, envelope_id_stamping):
        """
        Sets the envelope_id_stamping of this EnvelopeTemplate.
        When set to **true**, Envelope ID Stamping is enabled.

        :param envelope_id_stamping: The envelope_id_stamping of this EnvelopeTemplate.
        :type: str
        """

        self._envelope_id_stamping = envelope_id_stamping

    @property
    def envelope_location(self):
        """
        Gets the envelope_location of this EnvelopeTemplate.
        

        :return: The envelope_location of this EnvelopeTemplate.
        :rtype: str
        """
        return self._envelope_location

    @envelope_location.setter
    def envelope_location(self, envelope_location):
        """
        Sets the envelope_location of this EnvelopeTemplate.
        

        :param envelope_location: The envelope_location of this EnvelopeTemplate.
        :type: str
        """

        self._envelope_location = envelope_location

    @property
    def envelope_metadata(self):
        """
        Gets the envelope_metadata of this EnvelopeTemplate.

        :return: The envelope_metadata of this EnvelopeTemplate.
        :rtype: EnvelopeMetadata
        """
        return self._envelope_metadata

    @envelope_metadata.setter
    def envelope_metadata(self, envelope_metadata):
        """
        Sets the envelope_metadata of this EnvelopeTemplate.

        :param envelope_metadata: The envelope_metadata of this EnvelopeTemplate.
        :type: EnvelopeMetadata
        """

        self._envelope_metadata = envelope_metadata

    @property
    def envelope_uri(self):
        """
        Gets the envelope_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.

        :return: The envelope_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._envelope_uri

    @envelope_uri.setter
    def envelope_uri(self, envelope_uri):
        """
        Sets the envelope_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.

        :param envelope_uri: The envelope_uri of this EnvelopeTemplate.
        :type: str
        """

        self._envelope_uri = envelope_uri

    @property
    def expire_after(self):
        """
        Gets the expire_after of this EnvelopeTemplate.
        

        :return: The expire_after of this EnvelopeTemplate.
        :rtype: str
        """
        return self._expire_after

    @expire_after.setter
    def expire_after(self, expire_after):
        """
        Sets the expire_after of this EnvelopeTemplate.
        

        :param expire_after: The expire_after of this EnvelopeTemplate.
        :type: str
        """

        self._expire_after = expire_after

    @property
    def expire_date_time(self):
        """
        Gets the expire_date_time of this EnvelopeTemplate.
        

        :return: The expire_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._expire_date_time

    @expire_date_time.setter
    def expire_date_time(self, expire_date_time):
        """
        Sets the expire_date_time of this EnvelopeTemplate.
        

        :param expire_date_time: The expire_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._expire_date_time = expire_date_time

    @property
    def expire_enabled(self):
        """
        Gets the expire_enabled of this EnvelopeTemplate.
        

        :return: The expire_enabled of this EnvelopeTemplate.
        :rtype: str
        """
        return self._expire_enabled

    @expire_enabled.setter
    def expire_enabled(self, expire_enabled):
        """
        Sets the expire_enabled of this EnvelopeTemplate.
        

        :param expire_enabled: The expire_enabled of this EnvelopeTemplate.
        :type: str
        """

        self._expire_enabled = expire_enabled

    @property
    def external_envelope_id(self):
        """
        Gets the external_envelope_id of this EnvelopeTemplate.
        

        :return: The external_envelope_id of this EnvelopeTemplate.
        :rtype: str
        """
        return self._external_envelope_id

    @external_envelope_id.setter
    def external_envelope_id(self, external_envelope_id):
        """
        Sets the external_envelope_id of this EnvelopeTemplate.
        

        :param external_envelope_id: The external_envelope_id of this EnvelopeTemplate.
        :type: str
        """

        self._external_envelope_id = external_envelope_id

    @property
    def favorited_by_me(self):
        """
        Gets the favorited_by_me of this EnvelopeTemplate.
        

        :return: The favorited_by_me of this EnvelopeTemplate.
        :rtype: str
        """
        return self._favorited_by_me

    @favorited_by_me.setter
    def favorited_by_me(self, favorited_by_me):
        """
        Sets the favorited_by_me of this EnvelopeTemplate.
        

        :param favorited_by_me: The favorited_by_me of this EnvelopeTemplate.
        :type: str
        """

        self._favorited_by_me = favorited_by_me

    @property
    def folder_id(self):
        """
        Gets the folder_id of this EnvelopeTemplate.
        

        :return: The folder_id of this EnvelopeTemplate.
        :rtype: str
        """
        return self._folder_id

    @folder_id.setter
    def folder_id(self, folder_id):
        """
        Sets the folder_id of this EnvelopeTemplate.
        

        :param folder_id: The folder_id of this EnvelopeTemplate.
        :type: str
        """

        self._folder_id = folder_id

    @property
    def folder_ids(self):
        """
        Gets the folder_ids of this EnvelopeTemplate.
        

        :return: The folder_ids of this EnvelopeTemplate.
        :rtype: list[str]
        """
        return self._folder_ids

    @folder_ids.setter
    def folder_ids(self, folder_ids):
        """
        Sets the folder_ids of this EnvelopeTemplate.
        

        :param folder_ids: The folder_ids of this EnvelopeTemplate.
        :type: list[str]
        """

        self._folder_ids = folder_ids

    @property
    def folder_name(self):
        """
        Gets the folder_name of this EnvelopeTemplate.
        

        :return: The folder_name of this EnvelopeTemplate.
        :rtype: str
        """
        return self._folder_name

    @folder_name.setter
    def folder_name(self, folder_name):
        """
        Sets the folder_name of this EnvelopeTemplate.
        

        :param folder_name: The folder_name of this EnvelopeTemplate.
        :type: str
        """

        self._folder_name = folder_name

    @property
    def folders(self):
        """
        Gets the folders of this EnvelopeTemplate.
        

        :return: The folders of this EnvelopeTemplate.
        :rtype: list[Folder]
        """
        return self._folders

    @folders.setter
    def folders(self, folders):
        """
        Sets the folders of this EnvelopeTemplate.
        

        :param folders: The folders of this EnvelopeTemplate.
        :type: list[Folder]
        """

        self._folders = folders

    @property
    def has_comments(self):
        """
        Gets the has_comments of this EnvelopeTemplate.
        

        :return: The has_comments of this EnvelopeTemplate.
        :rtype: str
        """
        return self._has_comments

    @has_comments.setter
    def has_comments(self, has_comments):
        """
        Sets the has_comments of this EnvelopeTemplate.
        

        :param has_comments: The has_comments of this EnvelopeTemplate.
        :type: str
        """

        self._has_comments = has_comments

    @property
    def has_form_data_changed(self):
        """
        Gets the has_form_data_changed of this EnvelopeTemplate.
        

        :return: The has_form_data_changed of this EnvelopeTemplate.
        :rtype: str
        """
        return self._has_form_data_changed

    @has_form_data_changed.setter
    def has_form_data_changed(self, has_form_data_changed):
        """
        Sets the has_form_data_changed of this EnvelopeTemplate.
        

        :param has_form_data_changed: The has_form_data_changed of this EnvelopeTemplate.
        :type: str
        """

        self._has_form_data_changed = has_form_data_changed

    @property
    def has_wav_file(self):
        """
        Gets the has_wav_file of this EnvelopeTemplate.
        

        :return: The has_wav_file of this EnvelopeTemplate.
        :rtype: str
        """
        return self._has_wav_file

    @has_wav_file.setter
    def has_wav_file(self, has_wav_file):
        """
        Sets the has_wav_file of this EnvelopeTemplate.
        

        :param has_wav_file: The has_wav_file of this EnvelopeTemplate.
        :type: str
        """

        self._has_wav_file = has_wav_file

    @property
    def holder(self):
        """
        Gets the holder of this EnvelopeTemplate.
        

        :return: The holder of this EnvelopeTemplate.
        :rtype: str
        """
        return self._holder

    @holder.setter
    def holder(self, holder):
        """
        Sets the holder of this EnvelopeTemplate.
        

        :param holder: The holder of this EnvelopeTemplate.
        :type: str
        """

        self._holder = holder

    @property
    def initial_sent_date_time(self):
        """
        Gets the initial_sent_date_time of this EnvelopeTemplate.
        

        :return: The initial_sent_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._initial_sent_date_time

    @initial_sent_date_time.setter
    def initial_sent_date_time(self, initial_sent_date_time):
        """
        Sets the initial_sent_date_time of this EnvelopeTemplate.
        

        :param initial_sent_date_time: The initial_sent_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._initial_sent_date_time = initial_sent_date_time

    @property
    def is21_cfr_part11(self):
        """
        Gets the is21_cfr_part11 of this EnvelopeTemplate.
        When set to **true**, indicates that this module is enabled on the account.

        :return: The is21_cfr_part11 of this EnvelopeTemplate.
        :rtype: str
        """
        return self._is21_cfr_part11

    @is21_cfr_part11.setter
    def is21_cfr_part11(self, is21_cfr_part11):
        """
        Sets the is21_cfr_part11 of this EnvelopeTemplate.
        When set to **true**, indicates that this module is enabled on the account.

        :param is21_cfr_part11: The is21_cfr_part11 of this EnvelopeTemplate.
        :type: str
        """

        self._is21_cfr_part11 = is21_cfr_part11

    @property
    def is_dynamic_envelope(self):
        """
        Gets the is_dynamic_envelope of this EnvelopeTemplate.
        

        :return: The is_dynamic_envelope of this EnvelopeTemplate.
        :rtype: str
        """
        return self._is_dynamic_envelope

    @is_dynamic_envelope.setter
    def is_dynamic_envelope(self, is_dynamic_envelope):
        """
        Sets the is_dynamic_envelope of this EnvelopeTemplate.
        

        :param is_dynamic_envelope: The is_dynamic_envelope of this EnvelopeTemplate.
        :type: str
        """

        self._is_dynamic_envelope = is_dynamic_envelope

    @property
    def is_signature_provider_envelope(self):
        """
        Gets the is_signature_provider_envelope of this EnvelopeTemplate.
        

        :return: The is_signature_provider_envelope of this EnvelopeTemplate.
        :rtype: str
        """
        return self._is_signature_provider_envelope

    @is_signature_provider_envelope.setter
    def is_signature_provider_envelope(self, is_signature_provider_envelope):
        """
        Sets the is_signature_provider_envelope of this EnvelopeTemplate.
        

        :param is_signature_provider_envelope: The is_signature_provider_envelope of this EnvelopeTemplate.
        :type: str
        """

        self._is_signature_provider_envelope = is_signature_provider_envelope

    @property
    def last_modified(self):
        """
        Gets the last_modified of this EnvelopeTemplate.
        

        :return: The last_modified of this EnvelopeTemplate.
        :rtype: str
        """
        return self._last_modified

    @last_modified.setter
    def last_modified(self, last_modified):
        """
        Sets the last_modified of this EnvelopeTemplate.
        

        :param last_modified: The last_modified of this EnvelopeTemplate.
        :type: str
        """

        self._last_modified = last_modified

    @property
    def last_modified_by(self):
        """
        Gets the last_modified_by of this EnvelopeTemplate.

        :return: The last_modified_by of this EnvelopeTemplate.
        :rtype: UserInfo
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """
        Sets the last_modified_by of this EnvelopeTemplate.

        :param last_modified_by: The last_modified_by of this EnvelopeTemplate.
        :type: UserInfo
        """

        self._last_modified_by = last_modified_by

    @property
    def last_modified_date_time(self):
        """
        Gets the last_modified_date_time of this EnvelopeTemplate.
        The date and time the item was last modified.

        :return: The last_modified_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._last_modified_date_time

    @last_modified_date_time.setter
    def last_modified_date_time(self, last_modified_date_time):
        """
        Sets the last_modified_date_time of this EnvelopeTemplate.
        The date and time the item was last modified.

        :param last_modified_date_time: The last_modified_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._last_modified_date_time = last_modified_date_time

    @property
    def last_used(self):
        """
        Gets the last_used of this EnvelopeTemplate.
        

        :return: The last_used of this EnvelopeTemplate.
        :rtype: str
        """
        return self._last_used

    @last_used.setter
    def last_used(self, last_used):
        """
        Sets the last_used of this EnvelopeTemplate.
        

        :param last_used: The last_used of this EnvelopeTemplate.
        :type: str
        """

        self._last_used = last_used

    @property
    def location(self):
        """
        Gets the location of this EnvelopeTemplate.
        

        :return: The location of this EnvelopeTemplate.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this EnvelopeTemplate.
        

        :param location: The location of this EnvelopeTemplate.
        :type: str
        """

        self._location = location

    @property
    def lock_information(self):
        """
        Gets the lock_information of this EnvelopeTemplate.

        :return: The lock_information of this EnvelopeTemplate.
        :rtype: LockInformation
        """
        return self._lock_information

    @lock_information.setter
    def lock_information(self, lock_information):
        """
        Sets the lock_information of this EnvelopeTemplate.

        :param lock_information: The lock_information of this EnvelopeTemplate.
        :type: LockInformation
        """

        self._lock_information = lock_information

    @property
    def message_lock(self):
        """
        Gets the message_lock of this EnvelopeTemplate.
        When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.

        :return: The message_lock of this EnvelopeTemplate.
        :rtype: str
        """
        return self._message_lock

    @message_lock.setter
    def message_lock(self, message_lock):
        """
        Sets the message_lock of this EnvelopeTemplate.
        When set to **true**, prevents senders from changing the contents of `emailBlurb` and `emailSubject` properties for the envelope.   Additionally, this prevents users from making changes to the contents of `emailBlurb` and `emailSubject` properties when correcting envelopes.   However, if the `messageLock` node is set to true**** and the `emailSubject` property is empty, senders and correctors are able to add a subject to the envelope.

        :param message_lock: The message_lock of this EnvelopeTemplate.
        :type: str
        """

        self._message_lock = message_lock

    @property
    def name(self):
        """
        Gets the name of this EnvelopeTemplate.
        

        :return: The name of this EnvelopeTemplate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EnvelopeTemplate.
        

        :param name: The name of this EnvelopeTemplate.
        :type: str
        """

        self._name = name

    @property
    def new_password(self):
        """
        Gets the new_password of this EnvelopeTemplate.
        

        :return: The new_password of this EnvelopeTemplate.
        :rtype: str
        """
        return self._new_password

    @new_password.setter
    def new_password(self, new_password):
        """
        Sets the new_password of this EnvelopeTemplate.
        

        :param new_password: The new_password of this EnvelopeTemplate.
        :type: str
        """

        self._new_password = new_password

    @property
    def notification(self):
        """
        Gets the notification of this EnvelopeTemplate.

        :return: The notification of this EnvelopeTemplate.
        :rtype: Notification
        """
        return self._notification

    @notification.setter
    def notification(self, notification):
        """
        Sets the notification of this EnvelopeTemplate.

        :param notification: The notification of this EnvelopeTemplate.
        :type: Notification
        """

        self._notification = notification

    @property
    def notification_uri(self):
        """
        Gets the notification_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the notifications.

        :return: The notification_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._notification_uri

    @notification_uri.setter
    def notification_uri(self, notification_uri):
        """
        Sets the notification_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the notifications.

        :param notification_uri: The notification_uri of this EnvelopeTemplate.
        :type: str
        """

        self._notification_uri = notification_uri

    @property
    def owner(self):
        """
        Gets the owner of this EnvelopeTemplate.

        :return: The owner of this EnvelopeTemplate.
        :rtype: UserInfo
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this EnvelopeTemplate.

        :param owner: The owner of this EnvelopeTemplate.
        :type: UserInfo
        """

        self._owner = owner

    @property
    def page_count(self):
        """
        Gets the page_count of this EnvelopeTemplate.
        

        :return: The page_count of this EnvelopeTemplate.
        :rtype: str
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count):
        """
        Sets the page_count of this EnvelopeTemplate.
        

        :param page_count: The page_count of this EnvelopeTemplate.
        :type: str
        """

        self._page_count = page_count

    @property
    def password(self):
        """
        Gets the password of this EnvelopeTemplate.
        

        :return: The password of this EnvelopeTemplate.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this EnvelopeTemplate.
        

        :param password: The password of this EnvelopeTemplate.
        :type: str
        """

        self._password = password

    @property
    def password_protected(self):
        """
        Gets the password_protected of this EnvelopeTemplate.
        

        :return: The password_protected of this EnvelopeTemplate.
        :rtype: str
        """
        return self._password_protected

    @password_protected.setter
    def password_protected(self, password_protected):
        """
        Sets the password_protected of this EnvelopeTemplate.
        

        :param password_protected: The password_protected of this EnvelopeTemplate.
        :type: str
        """

        self._password_protected = password_protected

    @property
    def power_form(self):
        """
        Gets the power_form of this EnvelopeTemplate.

        :return: The power_form of this EnvelopeTemplate.
        :rtype: PowerForm
        """
        return self._power_form

    @power_form.setter
    def power_form(self, power_form):
        """
        Sets the power_form of this EnvelopeTemplate.

        :param power_form: The power_form of this EnvelopeTemplate.
        :type: PowerForm
        """

        self._power_form = power_form

    @property
    def power_forms(self):
        """
        Gets the power_forms of this EnvelopeTemplate.
        

        :return: The power_forms of this EnvelopeTemplate.
        :rtype: list[PowerForm]
        """
        return self._power_forms

    @power_forms.setter
    def power_forms(self, power_forms):
        """
        Sets the power_forms of this EnvelopeTemplate.
        

        :param power_forms: The power_forms of this EnvelopeTemplate.
        :type: list[PowerForm]
        """

        self._power_forms = power_forms

    @property
    def purge_completed_date(self):
        """
        Gets the purge_completed_date of this EnvelopeTemplate.
        

        :return: The purge_completed_date of this EnvelopeTemplate.
        :rtype: str
        """
        return self._purge_completed_date

    @purge_completed_date.setter
    def purge_completed_date(self, purge_completed_date):
        """
        Sets the purge_completed_date of this EnvelopeTemplate.
        

        :param purge_completed_date: The purge_completed_date of this EnvelopeTemplate.
        :type: str
        """

        self._purge_completed_date = purge_completed_date

    @property
    def purge_request_date(self):
        """
        Gets the purge_request_date of this EnvelopeTemplate.
        

        :return: The purge_request_date of this EnvelopeTemplate.
        :rtype: str
        """
        return self._purge_request_date

    @purge_request_date.setter
    def purge_request_date(self, purge_request_date):
        """
        Sets the purge_request_date of this EnvelopeTemplate.
        

        :param purge_request_date: The purge_request_date of this EnvelopeTemplate.
        :type: str
        """

        self._purge_request_date = purge_request_date

    @property
    def purge_state(self):
        """
        Gets the purge_state of this EnvelopeTemplate.
        

        :return: The purge_state of this EnvelopeTemplate.
        :rtype: str
        """
        return self._purge_state

    @purge_state.setter
    def purge_state(self, purge_state):
        """
        Sets the purge_state of this EnvelopeTemplate.
        

        :param purge_state: The purge_state of this EnvelopeTemplate.
        :type: str
        """

        self._purge_state = purge_state

    @property
    def recipients(self):
        """
        Gets the recipients of this EnvelopeTemplate.

        :return: The recipients of this EnvelopeTemplate.
        :rtype: Recipients
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """
        Sets the recipients of this EnvelopeTemplate.

        :param recipients: The recipients of this EnvelopeTemplate.
        :type: Recipients
        """

        self._recipients = recipients

    @property
    def recipients_lock(self):
        """
        Gets the recipients_lock of this EnvelopeTemplate.
        When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.

        :return: The recipients_lock of this EnvelopeTemplate.
        :rtype: str
        """
        return self._recipients_lock

    @recipients_lock.setter
    def recipients_lock(self, recipients_lock):
        """
        Sets the recipients_lock of this EnvelopeTemplate.
        When set to **true**, prevents senders from changing, correcting, or deleting the recipient information for the envelope.

        :param recipients_lock: The recipients_lock of this EnvelopeTemplate.
        :type: str
        """

        self._recipients_lock = recipients_lock

    @property
    def recipients_uri(self):
        """
        Gets the recipients_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the recipients.

        :return: The recipients_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._recipients_uri

    @recipients_uri.setter
    def recipients_uri(self, recipients_uri):
        """
        Sets the recipients_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint that you can use to retrieve the recipients.

        :param recipients_uri: The recipients_uri of this EnvelopeTemplate.
        :type: str
        """

        self._recipients_uri = recipients_uri

    @property
    def sender(self):
        """
        Gets the sender of this EnvelopeTemplate.

        :return: The sender of this EnvelopeTemplate.
        :rtype: UserInfo
        """
        return self._sender

    @sender.setter
    def sender(self, sender):
        """
        Sets the sender of this EnvelopeTemplate.

        :param sender: The sender of this EnvelopeTemplate.
        :type: UserInfo
        """

        self._sender = sender

    @property
    def sent_date_time(self):
        """
        Gets the sent_date_time of this EnvelopeTemplate.
        The date and time the envelope was sent.

        :return: The sent_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._sent_date_time

    @sent_date_time.setter
    def sent_date_time(self, sent_date_time):
        """
        Sets the sent_date_time of this EnvelopeTemplate.
        The date and time the envelope was sent.

        :param sent_date_time: The sent_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._sent_date_time = sent_date_time

    @property
    def shared(self):
        """
        Gets the shared of this EnvelopeTemplate.
        When set to **true**, this custom tab is shared.

        :return: The shared of this EnvelopeTemplate.
        :rtype: str
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """
        Sets the shared of this EnvelopeTemplate.
        When set to **true**, this custom tab is shared.

        :param shared: The shared of this EnvelopeTemplate.
        :type: str
        """

        self._shared = shared

    @property
    def signer_can_sign_on_mobile(self):
        """
        Gets the signer_can_sign_on_mobile of this EnvelopeTemplate.
        

        :return: The signer_can_sign_on_mobile of this EnvelopeTemplate.
        :rtype: str
        """
        return self._signer_can_sign_on_mobile

    @signer_can_sign_on_mobile.setter
    def signer_can_sign_on_mobile(self, signer_can_sign_on_mobile):
        """
        Sets the signer_can_sign_on_mobile of this EnvelopeTemplate.
        

        :param signer_can_sign_on_mobile: The signer_can_sign_on_mobile of this EnvelopeTemplate.
        :type: str
        """

        self._signer_can_sign_on_mobile = signer_can_sign_on_mobile

    @property
    def signing_location(self):
        """
        Gets the signing_location of this EnvelopeTemplate.
        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.

        :return: The signing_location of this EnvelopeTemplate.
        :rtype: str
        """
        return self._signing_location

    @signing_location.setter
    def signing_location(self, signing_location):
        """
        Sets the signing_location of this EnvelopeTemplate.
        Specifies the physical location where the signing takes place. It can have two enumeration values; InPerson and Online. The default value is Online.

        :param signing_location: The signing_location of this EnvelopeTemplate.
        :type: str
        """

        self._signing_location = signing_location

    @property
    def status(self):
        """
        Gets the status of this EnvelopeTemplate.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :return: The status of this EnvelopeTemplate.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EnvelopeTemplate.
        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.

        :param status: The status of this EnvelopeTemplate.
        :type: str
        """

        self._status = status

    @property
    def status_changed_date_time(self):
        """
        Gets the status_changed_date_time of this EnvelopeTemplate.
        The data and time the status changed.

        :return: The status_changed_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._status_changed_date_time

    @status_changed_date_time.setter
    def status_changed_date_time(self, status_changed_date_time):
        """
        Sets the status_changed_date_time of this EnvelopeTemplate.
        The data and time the status changed.

        :param status_changed_date_time: The status_changed_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._status_changed_date_time = status_changed_date_time

    @property
    def status_date_time(self):
        """
        Gets the status_date_time of this EnvelopeTemplate.
        

        :return: The status_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._status_date_time

    @status_date_time.setter
    def status_date_time(self, status_date_time):
        """
        Sets the status_date_time of this EnvelopeTemplate.
        

        :param status_date_time: The status_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._status_date_time = status_date_time

    @property
    def template_id(self):
        """
        Gets the template_id of this EnvelopeTemplate.
        The unique identifier of the template. If this is not provided, DocuSign will generate a value. 

        :return: The template_id of this EnvelopeTemplate.
        :rtype: str
        """
        return self._template_id

    @template_id.setter
    def template_id(self, template_id):
        """
        Sets the template_id of this EnvelopeTemplate.
        The unique identifier of the template. If this is not provided, DocuSign will generate a value. 

        :param template_id: The template_id of this EnvelopeTemplate.
        :type: str
        """

        self._template_id = template_id

    @property
    def templates_uri(self):
        """
        Gets the templates_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint which you can use to retrieve the templates.

        :return: The templates_uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._templates_uri

    @templates_uri.setter
    def templates_uri(self, templates_uri):
        """
        Sets the templates_uri of this EnvelopeTemplate.
        Contains a URI for an endpoint which you can use to retrieve the templates.

        :param templates_uri: The templates_uri of this EnvelopeTemplate.
        :type: str
        """

        self._templates_uri = templates_uri

    @property
    def transaction_id(self):
        """
        Gets the transaction_id of this EnvelopeTemplate.
         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.

        :return: The transaction_id of this EnvelopeTemplate.
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """
        Sets the transaction_id of this EnvelopeTemplate.
         Used to identify an envelope. The id is a sender-generated value and is valid in the DocuSign system for 7 days. It is recommended that a transaction ID is used for offline signing to ensure that an envelope is not sent multiple times. The `transactionId` property can be used determine an envelope's status (i.e. was it created or not) in cases where the internet connection was lost before the envelope status was returned.

        :param transaction_id: The transaction_id of this EnvelopeTemplate.
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def uri(self):
        """
        Gets the uri of this EnvelopeTemplate.
        

        :return: The uri of this EnvelopeTemplate.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this EnvelopeTemplate.
        

        :param uri: The uri of this EnvelopeTemplate.
        :type: str
        """

        self._uri = uri

    @property
    def use_disclosure(self):
        """
        Gets the use_disclosure of this EnvelopeTemplate.
        When set to **true**, the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.

        :return: The use_disclosure of this EnvelopeTemplate.
        :rtype: str
        """
        return self._use_disclosure

    @use_disclosure.setter
    def use_disclosure(self, use_disclosure):
        """
        Sets the use_disclosure of this EnvelopeTemplate.
        When set to **true**, the disclosure is shown to recipients in accordance with the account's Electronic Record and Signature Disclosure frequency setting. When set to **false**, the Electronic Record and Signature Disclosure is not shown to any envelope recipients.   If the `useDisclosure` property is not set, then the account's normal disclosure setting is used and the value of the `useDisclosure` property is not returned in responses when getting envelope information.

        :param use_disclosure: The use_disclosure of this EnvelopeTemplate.
        :type: str
        """

        self._use_disclosure = use_disclosure

    @property
    def voided_date_time(self):
        """
        Gets the voided_date_time of this EnvelopeTemplate.
        The date and time the envelope or template was voided.

        :return: The voided_date_time of this EnvelopeTemplate.
        :rtype: str
        """
        return self._voided_date_time

    @voided_date_time.setter
    def voided_date_time(self, voided_date_time):
        """
        Sets the voided_date_time of this EnvelopeTemplate.
        The date and time the envelope or template was voided.

        :param voided_date_time: The voided_date_time of this EnvelopeTemplate.
        :type: str
        """

        self._voided_date_time = voided_date_time

    @property
    def voided_reason(self):
        """
        Gets the voided_reason of this EnvelopeTemplate.
        The reason the envelope or template was voided.

        :return: The voided_reason of this EnvelopeTemplate.
        :rtype: str
        """
        return self._voided_reason

    @voided_reason.setter
    def voided_reason(self, voided_reason):
        """
        Sets the voided_reason of this EnvelopeTemplate.
        The reason the envelope or template was voided.

        :param voided_reason: The voided_reason of this EnvelopeTemplate.
        :type: str
        """

        self._voided_reason = voided_reason

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
