# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Comment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, envelope_id=None, hmac=None, id=None, mentions=None, read=None, sent_by_email=None, sent_by_full_name=None, sent_by_image_id=None, sent_by_initials=None, sent_by_recipient_id=None, sent_by_user_id=None, signing_group_id=None, signing_group_name=None, subject=None, tab_id=None, text=None, thread_id=None, thread_originator_id=None, timestamp=None, time_stamp_formatted=None, visible_to=None):
        """
        Comment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'envelope_id': 'str',
            'hmac': 'str',
            'id': 'str',
            'mentions': 'list[str]',
            'read': 'bool',
            'sent_by_email': 'str',
            'sent_by_full_name': 'str',
            'sent_by_image_id': 'str',
            'sent_by_initials': 'str',
            'sent_by_recipient_id': 'str',
            'sent_by_user_id': 'str',
            'signing_group_id': 'str',
            'signing_group_name': 'str',
            'subject': 'str',
            'tab_id': 'str',
            'text': 'str',
            'thread_id': 'str',
            'thread_originator_id': 'str',
            'timestamp': 'str',
            'time_stamp_formatted': 'str',
            'visible_to': 'list[str]'
        }

        self.attribute_map = {
            'envelope_id': 'envelopeId',
            'hmac': 'hmac',
            'id': 'id',
            'mentions': 'mentions',
            'read': 'read',
            'sent_by_email': 'sentByEmail',
            'sent_by_full_name': 'sentByFullName',
            'sent_by_image_id': 'sentByImageId',
            'sent_by_initials': 'sentByInitials',
            'sent_by_recipient_id': 'sentByRecipientId',
            'sent_by_user_id': 'sentByUserId',
            'signing_group_id': 'signingGroupId',
            'signing_group_name': 'signingGroupName',
            'subject': 'subject',
            'tab_id': 'tabId',
            'text': 'text',
            'thread_id': 'threadId',
            'thread_originator_id': 'threadOriginatorId',
            'timestamp': 'timestamp',
            'time_stamp_formatted': 'timeStampFormatted',
            'visible_to': 'visibleTo'
        }

        self._envelope_id = envelope_id
        self._hmac = hmac
        self._id = id
        self._mentions = mentions
        self._read = read
        self._sent_by_email = sent_by_email
        self._sent_by_full_name = sent_by_full_name
        self._sent_by_image_id = sent_by_image_id
        self._sent_by_initials = sent_by_initials
        self._sent_by_recipient_id = sent_by_recipient_id
        self._sent_by_user_id = sent_by_user_id
        self._signing_group_id = signing_group_id
        self._signing_group_name = signing_group_name
        self._subject = subject
        self._tab_id = tab_id
        self._text = text
        self._thread_id = thread_id
        self._thread_originator_id = thread_originator_id
        self._timestamp = timestamp
        self._time_stamp_formatted = time_stamp_formatted
        self._visible_to = visible_to

    @property
    def envelope_id(self):
        """
        Gets the envelope_id of this Comment.
        The envelope ID of the envelope status that failed to post.

        :return: The envelope_id of this Comment.
        :rtype: str
        """
        return self._envelope_id

    @envelope_id.setter
    def envelope_id(self, envelope_id):
        """
        Sets the envelope_id of this Comment.
        The envelope ID of the envelope status that failed to post.

        :param envelope_id: The envelope_id of this Comment.
        :type: str
        """

        self._envelope_id = envelope_id

    @property
    def hmac(self):
        """
        Gets the hmac of this Comment.
        

        :return: The hmac of this Comment.
        :rtype: str
        """
        return self._hmac

    @hmac.setter
    def hmac(self, hmac):
        """
        Sets the hmac of this Comment.
        

        :param hmac: The hmac of this Comment.
        :type: str
        """

        self._hmac = hmac

    @property
    def id(self):
        """
        Gets the id of this Comment.
        

        :return: The id of this Comment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Comment.
        

        :param id: The id of this Comment.
        :type: str
        """

        self._id = id

    @property
    def mentions(self):
        """
        Gets the mentions of this Comment.
        

        :return: The mentions of this Comment.
        :rtype: list[str]
        """
        return self._mentions

    @mentions.setter
    def mentions(self, mentions):
        """
        Sets the mentions of this Comment.
        

        :param mentions: The mentions of this Comment.
        :type: list[str]
        """

        self._mentions = mentions

    @property
    def read(self):
        """
        Gets the read of this Comment.
        

        :return: The read of this Comment.
        :rtype: bool
        """
        return self._read

    @read.setter
    def read(self, read):
        """
        Sets the read of this Comment.
        

        :param read: The read of this Comment.
        :type: bool
        """

        self._read = read

    @property
    def sent_by_email(self):
        """
        Gets the sent_by_email of this Comment.
        

        :return: The sent_by_email of this Comment.
        :rtype: str
        """
        return self._sent_by_email

    @sent_by_email.setter
    def sent_by_email(self, sent_by_email):
        """
        Sets the sent_by_email of this Comment.
        

        :param sent_by_email: The sent_by_email of this Comment.
        :type: str
        """

        self._sent_by_email = sent_by_email

    @property
    def sent_by_full_name(self):
        """
        Gets the sent_by_full_name of this Comment.
        

        :return: The sent_by_full_name of this Comment.
        :rtype: str
        """
        return self._sent_by_full_name

    @sent_by_full_name.setter
    def sent_by_full_name(self, sent_by_full_name):
        """
        Sets the sent_by_full_name of this Comment.
        

        :param sent_by_full_name: The sent_by_full_name of this Comment.
        :type: str
        """

        self._sent_by_full_name = sent_by_full_name

    @property
    def sent_by_image_id(self):
        """
        Gets the sent_by_image_id of this Comment.
        

        :return: The sent_by_image_id of this Comment.
        :rtype: str
        """
        return self._sent_by_image_id

    @sent_by_image_id.setter
    def sent_by_image_id(self, sent_by_image_id):
        """
        Sets the sent_by_image_id of this Comment.
        

        :param sent_by_image_id: The sent_by_image_id of this Comment.
        :type: str
        """

        self._sent_by_image_id = sent_by_image_id

    @property
    def sent_by_initials(self):
        """
        Gets the sent_by_initials of this Comment.
        

        :return: The sent_by_initials of this Comment.
        :rtype: str
        """
        return self._sent_by_initials

    @sent_by_initials.setter
    def sent_by_initials(self, sent_by_initials):
        """
        Sets the sent_by_initials of this Comment.
        

        :param sent_by_initials: The sent_by_initials of this Comment.
        :type: str
        """

        self._sent_by_initials = sent_by_initials

    @property
    def sent_by_recipient_id(self):
        """
        Gets the sent_by_recipient_id of this Comment.
        

        :return: The sent_by_recipient_id of this Comment.
        :rtype: str
        """
        return self._sent_by_recipient_id

    @sent_by_recipient_id.setter
    def sent_by_recipient_id(self, sent_by_recipient_id):
        """
        Sets the sent_by_recipient_id of this Comment.
        

        :param sent_by_recipient_id: The sent_by_recipient_id of this Comment.
        :type: str
        """

        self._sent_by_recipient_id = sent_by_recipient_id

    @property
    def sent_by_user_id(self):
        """
        Gets the sent_by_user_id of this Comment.
        

        :return: The sent_by_user_id of this Comment.
        :rtype: str
        """
        return self._sent_by_user_id

    @sent_by_user_id.setter
    def sent_by_user_id(self, sent_by_user_id):
        """
        Sets the sent_by_user_id of this Comment.
        

        :param sent_by_user_id: The sent_by_user_id of this Comment.
        :type: str
        """

        self._sent_by_user_id = sent_by_user_id

    @property
    def signing_group_id(self):
        """
        Gets the signing_group_id of this Comment.
        When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).

        :return: The signing_group_id of this Comment.
        :rtype: str
        """
        return self._signing_group_id

    @signing_group_id.setter
    def signing_group_id(self, signing_group_id):
        """
        Sets the signing_group_id of this Comment.
        When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).

        :param signing_group_id: The signing_group_id of this Comment.
        :type: str
        """

        self._signing_group_id = signing_group_id

    @property
    def signing_group_name(self):
        """
        Gets the signing_group_name of this Comment.
        The display name for the signing group.   Maximum Length: 100 characters. 

        :return: The signing_group_name of this Comment.
        :rtype: str
        """
        return self._signing_group_name

    @signing_group_name.setter
    def signing_group_name(self, signing_group_name):
        """
        Sets the signing_group_name of this Comment.
        The display name for the signing group.   Maximum Length: 100 characters. 

        :param signing_group_name: The signing_group_name of this Comment.
        :type: str
        """

        self._signing_group_name = signing_group_name

    @property
    def subject(self):
        """
        Gets the subject of this Comment.
        

        :return: The subject of this Comment.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """
        Sets the subject of this Comment.
        

        :param subject: The subject of this Comment.
        :type: str
        """

        self._subject = subject

    @property
    def tab_id(self):
        """
        Gets the tab_id of this Comment.
        The unique identifier for the tab. The tabid can be retrieved with the [ML:GET call].     

        :return: The tab_id of this Comment.
        :rtype: str
        """
        return self._tab_id

    @tab_id.setter
    def tab_id(self, tab_id):
        """
        Sets the tab_id of this Comment.
        The unique identifier for the tab. The tabid can be retrieved with the [ML:GET call].     

        :param tab_id: The tab_id of this Comment.
        :type: str
        """

        self._tab_id = tab_id

    @property
    def text(self):
        """
        Gets the text of this Comment.
        

        :return: The text of this Comment.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this Comment.
        

        :param text: The text of this Comment.
        :type: str
        """

        self._text = text

    @property
    def thread_id(self):
        """
        Gets the thread_id of this Comment.
        

        :return: The thread_id of this Comment.
        :rtype: str
        """
        return self._thread_id

    @thread_id.setter
    def thread_id(self, thread_id):
        """
        Sets the thread_id of this Comment.
        

        :param thread_id: The thread_id of this Comment.
        :type: str
        """

        self._thread_id = thread_id

    @property
    def thread_originator_id(self):
        """
        Gets the thread_originator_id of this Comment.
        

        :return: The thread_originator_id of this Comment.
        :rtype: str
        """
        return self._thread_originator_id

    @thread_originator_id.setter
    def thread_originator_id(self, thread_originator_id):
        """
        Sets the thread_originator_id of this Comment.
        

        :param thread_originator_id: The thread_originator_id of this Comment.
        :type: str
        """

        self._thread_originator_id = thread_originator_id

    @property
    def timestamp(self):
        """
        Gets the timestamp of this Comment.
        

        :return: The timestamp of this Comment.
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Comment.
        

        :param timestamp: The timestamp of this Comment.
        :type: str
        """

        self._timestamp = timestamp

    @property
    def time_stamp_formatted(self):
        """
        Gets the time_stamp_formatted of this Comment.
        

        :return: The time_stamp_formatted of this Comment.
        :rtype: str
        """
        return self._time_stamp_formatted

    @time_stamp_formatted.setter
    def time_stamp_formatted(self, time_stamp_formatted):
        """
        Sets the time_stamp_formatted of this Comment.
        

        :param time_stamp_formatted: The time_stamp_formatted of this Comment.
        :type: str
        """

        self._time_stamp_formatted = time_stamp_formatted

    @property
    def visible_to(self):
        """
        Gets the visible_to of this Comment.
        

        :return: The visible_to of this Comment.
        :rtype: list[str]
        """
        return self._visible_to

    @visible_to.setter
    def visible_to(self, visible_to):
        """
        Sets the visible_to of this Comment.
        

        :param visible_to: The visible_to of this Comment.
        :type: list[str]
        """

        self._visible_to = visible_to

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
