# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['markovpack',
 'markovpack.commands',
 'markovpack.events',
 'markovpack.stars',
 'markovpack.tables']

package_data = \
{'': ['*']}

install_requires = \
['markovify>=0.8.0,<0.9.0',
 'royalnet[telegram,discord,alchemy_easy,bard,constellation,sentry,herald,coloredlogs,matrix]>=5.9.2,<6.0.0']

setup_kwargs = {
    'name': 'markovpack',
    'version': '0.3.2',
    'description': 'A Royalnet pack to have fun with Markovify.',
    'long_description': '# `markovpack`\n\nA [Royalnet](https://github.com/Steffo99/royalnet) pack to have fun with [Markovify](https://github.com/jsvine/markovify)!\n\n## Usage\n\n1. Create a new directory in the working directory of the Royalnet instance.\n2. Place there the `.json` files generated by the `text.to_json()` method of markovify\'s NewLineTexts.\n3. In the `config.toml` of the Royalnet instance, set the following values:\n   ```toml\n   [Packs."markovpack"]\n   Markov.models_directory = "markovpack"  # The name of the directory containing the .json files\n   Markov.default_model = "example"  # The name of the .json file that should be parsed if no arguments are passed to the command \n   Markov.min_words = 5  # The minimum number of words a sentence should have to be sent\n   ```\n4. Start Royalnet with `python -m royalnet` and have fun!',
    'author': 'Stefano Pigozzi',
    'author_email': 'ste.pigozzi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Steffo99/markovpack',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
