"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.countResources = exports.hasResourceProperties = exports.hasResource = exports.findResources = void 0;
const __1 = require("..");
const absent_1 = require("./matchers/absent");
const section_1 = require("./section");
function findResources(template, type, props = {}) {
    var _a;
    const section = (_a = template.Resources) !== null && _a !== void 0 ? _a : {};
    const result = section_1.matchSection(filterType(section, type), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findResources = findResources;
function hasResource(template, type, props) {
    var _a;
    const section = (_a = template.Resources) !== null && _a !== void 0 ? _a : {};
    const result = section_1.matchSection(filterType(section, type), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return `No resource with type ${type} found`;
    }
    return [
        `Template has ${result.analyzedCount} resources with type ${type}, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasResource = hasResource;
function hasResourceProperties(template, type, props) {
    // amended needs to be a deep copy to avoid modifying the template.
    let amended = JSON.parse(JSON.stringify(template));
    // special case to exclude AbsentMatch because adding an empty Properties object will affect its evaluation.
    if (!__1.Matcher.isMatcher(props) || !(props instanceof absent_1.AbsentMatch)) {
        amended = addEmptyProperties(amended);
    }
    return hasResource(amended, type, __1.Match.objectLike({
        Properties: props,
    }));
}
exports.hasResourceProperties = hasResourceProperties;
function countResources(template, type) {
    var _a;
    const section = (_a = template.Resources) !== null && _a !== void 0 ? _a : {};
    const types = filterType(section, type);
    return Object.entries(types).length;
}
exports.countResources = countResources;
function addEmptyProperties(template) {
    var _a;
    let section = (_a = template.Resources) !== null && _a !== void 0 ? _a : {};
    Object.keys(section).map((key) => {
        if (!section[key].hasOwnProperty('Properties')) {
            section[key].Properties = {};
        }
    });
    return template;
}
function filterType(section, type) {
    return Object.entries(section !== null && section !== void 0 ? section : {})
        .filter(([_, v]) => v.Type === type)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
//# sourceMappingURL=data:application/json;base64,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