"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasMessage = exports.findMessage = void 0;
const section_1 = require("./section");
function findMessage(messages, constructPath, props = {}) {
    const section = messages;
    const result = section_1.matchSection(filterPath(section, constructPath), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findMessage = findMessage;
function hasMessage(messages, constructPath, props) {
    const section = messages;
    const result = section_1.matchSection(filterPath(section, constructPath), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No messages found in the stack';
    }
    handleTrace(result.closestResult.target);
    return [
        `Stack has ${result.analyzedCount} messages, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasMessage = hasMessage;
// We redact the stack trace by default because it is unnecessarily long and unintelligible.
// If there is a use case for rendering the trace, we can add it later.
function handleTrace(match, redact = true) {
    var _a;
    if (redact && ((_a = match.entry) === null || _a === void 0 ? void 0 : _a.trace) !== undefined) {
        match.entry.trace = 'redacted';
    }
    ;
}
function filterPath(section, path) {
    // default signal for all paths is '*'
    if (path === '*')
        return section;
    return Object.entries(section !== null && section !== void 0 ? section : {})
        .filter(([_, v]) => v.id === path)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
//# sourceMappingURL=data:application/json;base64,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