"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeliveryChannel = exports.DeliveryChannelProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const config_generated_1 = require("./config.generated");
Object.defineProperty(exports, "DeliveryChannelProperty", { enumerable: true, get: function () { return config_generated_1.RosDeliveryChannel; } });
/**
 * A ROS resource type:  `ALIYUN::Config::DeliveryChannel`
 */
class DeliveryChannel extends ros.Resource {
    /**
     * Create a new `ALIYUN::Config::DeliveryChannel`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDeliveryChannel = new config_generated_1.RosDeliveryChannel(this, id, {
            description: props.description,
            deliveryChannelName: props.deliveryChannelName,
            deliveryChannelTargetArn: props.deliveryChannelTargetArn,
            deliveryChannelAssumeRoleArn: props.deliveryChannelAssumeRoleArn,
            deliveryChannelType: props.deliveryChannelType,
            deliveryChannelCondition: props.deliveryChannelCondition,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDeliveryChannel;
        this.attrDeliveryChannelId = rosDeliveryChannel.attrDeliveryChannelId;
    }
}
exports.DeliveryChannel = DeliveryChannel;
//# sourceMappingURL=data:application/json;base64,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