# Frappe Setup

A Python package to automate Frappe Framework setup with Docker for local development. This tool simplifies the process of setting up Frappe/ERPNext development environment using Docker containers.

## System Requirements

Before installation, ensure your system meets these requirements:

### Software Requirements
- Python 3.6 or higher
- pip (Python package manager)
- Docker Engine
- Docker Compose
- Visual Studio Code
- Git

### Hardware Requirements
- Minimum 4GB RAM (8GB recommended)
- 20GB free disk space
- x86_64 processor architecture

### Operating System
- Ubuntu 20.04 or higher (primary support)
- Other Linux distributions (may work but not officially supported)

## Pre-Installation Steps

1. Install Docker (if not already installed):

## Installation

Access your site at: http://development.localhost:8000

Default credentials:
- Username: Administrator
- Password: admin

## Uninstallation

### Method 1: Using CLI (Recommended)

1. Run the uninstall command: 


## Development Notes

- The development environment runs in a Docker container
- Code changes are synchronized in real-time
- Use VS Code's integrated terminal for bench commands
- Development site uses .localhost domain for local development

## Contributing

1. Fork the repository
2. Create a feature branch
3. Commit your changes
4. Push to the branch
5. Create a Pull Request

## License

MIT License - see LICENSE file for details

## Support

- GitHub Issues: [Create an issue](https://github.com/yourusername/frappe-setup/issues)
- Documentation: [Frappe Framework Documentation](https://frappeframework.com/docs)
- Community Forum: [Frappe Forum](https://discuss.erpnext.com/)

## Acknowledgments

- Frappe Framework Team
- Docker Community
- VS Code Remote Containers Team