"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Prepends the release changelog entry onto the provided project-level changelog
 *
 * Currently assumes a headerless changelog formatted according to
 * [conventional-changelog](https://github.com/conventional-changelog/conventional-changelog)
 * rules.
 *
 * Environment variables:
 *
 * - VERSION_FILE: Current semantic version file
 * - CHANGELOG_FILE: Release changelog
 * - PROJECT_CHANGELOG_FILE: Project-level changelog
 *
 */
const update_changelog_1 = require("./update-changelog");
const inputChangelog = process.env.CHANGELOG;
const outputChangelog = process.env.PROJECT_CHANGELOG_FILE;
const versionFile = process.env.VERSION_FILE;
if (!versionFile) {
    throw new Error("VERSION_FILE is required");
}
if (!inputChangelog) {
    throw new Error("CHANGELOG is required");
}
if (!outputChangelog) {
    throw new Error("PROJECT_CHANGELOG_FILE is required");
}
const opts = {
    inputChangelog,
    outputChangelog,
    versionFile: versionFile,
};
update_changelog_1.updateChangelog(process.cwd(), opts).catch((e) => {
    console.log(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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