"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Generate an annotated release tag using version and changelog files.
 *
 * The tag from the release tag from the release tag file will be used as is.
 *
 * The tag annotation message will be set to the content of the provided changelog
 * file.
 *
 * Environment variables:
 *
 * - RELEASE_TAG_FILE: Release Tag file containing the bumped release tag
 * - CHANGELOG_FILE: Changelog to be used for tag annotation
 *
 */
const tag_version_1 = require("./tag-version");
const changelog = process.env.CHANGELOG;
const releaseTagFile = process.env.RELEASE_TAG_FILE;
if (!releaseTagFile) {
    throw new Error("RELEASE_TAG_FILE is required");
}
if (!changelog) {
    throw new Error("CHANGELOG is required");
}
const opts = {
    changelog,
    releaseTagFile: releaseTagFile,
};
tag_version_1.tag(process.cwd(), opts).catch((e) => {
    console.log(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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