"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitAttributesFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * Assign attributes to file names in a git repository.
 *
 * @see https://git-scm.com/docs/gitattributes
 */
class GitAttributesFile extends file_1.FileBase {
    constructor(project) {
        super(project, ".gitattributes", {
            editGitignore: false,
        });
        this.attributes = new Map();
    }
    /**
     * Maps a set of attributes to a set of files.
     * @param glob Glob pattern to match files in the repo
     * @param attributes Attributes to assign to these files.
     */
    addAttributes(glob, ...attributes) {
        if (!this.attributes.has(glob)) {
            this.attributes.set(glob, new Set());
        }
        const set = this.attributes.get(glob);
        for (const attribute of attributes) {
            set.add(attribute);
        }
    }
    /**
     * Add attributes necessary to mark these files as stored in LFS
     */
    addLfsPattern(glob) {
        this.addAttributes(glob, "filter=lfs", "diff=lfs", "merge=lfs", "-text");
    }
    /**
     * Whether the current gitattributes file has any LFS patterns
     */
    get hasLfsPatterns() {
        return Array.from(this.attributes.values()).some((attrs) => attrs.has("filter=lfs"));
    }
    synthesizeContent(_) {
        // We can assume the file map is never empty.
        const entries = Array.from(this.attributes.entries()).sort(([l], [r]) => l.localeCompare(r));
        if (entries.length === 0) {
            return undefined;
        }
        return [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            ...entries.map(([name, attributes]) => `${name} ${Array.from(attributes).join(" ")}`),
        ].join("\n");
    }
}
exports.GitAttributesFile = GitAttributesFile;
_a = JSII_RTTI_SYMBOL_1;
GitAttributesFile[_a] = { fqn: "projen.GitAttributesFile", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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