"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.LegacyStackSynthesizer=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cxschema=require("../../../cloud-assembly-schema"),cxapi=require("../../../cx-api"),constructs_1=require("constructs"),_shared_1=require("./_shared"),stack_synthesizer_1=require("./stack-synthesizer"),cfn_fn_1=require("../cfn-fn"),asset_parameters_1=require("../private/asset-parameters"),ASSETS_ECR_REPOSITORY_NAME="aws-cdk/assets",ASSETS_ECR_REPOSITORY_NAME_OVERRIDE_CONTEXT_KEY="assets-ecr-repository-name";class LegacyStackSynthesizer extends stack_synthesizer_1.StackSynthesizer{constructor(){super(...arguments),this.cycle=!1,this.addedImageAssets=new Set}addFileAsset(asset){try{jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFileAsset),error}if(this.cycle)return this.doAddFileAsset(asset);this.cycle=!0;try{const stack=this.boundStack;return withoutDeprecationWarnings(()=>stack.addFileAsset(asset))}finally{this.cycle=!1}}addDockerImageAsset(asset){try{jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDockerImageAsset),error}if(this.cycle)return this.doAddDockerImageAsset(asset);this.cycle=!0;try{const stack=this.boundStack;return withoutDeprecationWarnings(()=>stack.addDockerImageAsset(asset))}finally{this.cycle=!1}}synthesize(session){try{jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.synthesize),error}this.synthesizeTemplate(session),this.emitArtifact(session)}reusableBind(stack){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.reusableBind),error}const copy=Object.create(this);return copy.bind(stack),copy}doAddDockerImageAsset(asset){const repositoryNameOverride=this.boundStack.node.tryGetContext(ASSETS_ECR_REPOSITORY_NAME_OVERRIDE_CONTEXT_KEY),repositoryName=asset.repositoryName??repositoryNameOverride??ASSETS_ECR_REPOSITORY_NAME,imageTag=asset.sourceHash,assetId=asset.sourceHash;if(!this.addedImageAssets.has(assetId)){if(!asset.directoryName)throw new Error(`LegacyStackSynthesizer does not support this type of file asset: ${JSON.stringify(asset)}`);const metadata={repositoryName,imageTag,id:assetId,packaging:"container-image",path:asset.directoryName,sourceHash:asset.sourceHash,buildArgs:asset.dockerBuildArgs,target:asset.dockerBuildTarget,file:asset.dockerFile,networkMode:asset.networkMode,platform:asset.platform,outputs:asset.dockerOutputs,cacheFrom:asset.dockerCacheFrom,cacheTo:asset.dockerCacheTo};this.boundStack.node.addMetadata(cxschema.ArtifactMetadataEntryType.ASSET,metadata),this.addedImageAssets.add(assetId)}return{imageUri:`${this.boundStack.account}.dkr.ecr.${this.boundStack.region}.${this.boundStack.urlSuffix}/${repositoryName}:${imageTag}`,repositoryName}}doAddFileAsset(asset){let params=this.assetParameters.node.tryFindChild(asset.sourceHash);if(!params){if(params=new asset_parameters_1.FileAssetParameters(this.assetParameters,asset.sourceHash),!asset.fileName||!asset.packaging)throw new Error(`LegacyStackSynthesizer does not support this type of file asset: ${JSON.stringify(asset)}`);const metadata={path:asset.fileName,id:asset.sourceHash,packaging:asset.packaging,sourceHash:asset.sourceHash,s3BucketParameter:params.bucketNameParameter.logicalId,s3KeyParameter:params.objectKeyParameter.logicalId,artifactHashParameter:params.artifactHashParameter.logicalId};this.boundStack.node.addMetadata(cxschema.ArtifactMetadataEntryType.ASSET,metadata)}const bucketName=params.bucketNameParameter.valueAsString,encodedKey=params.objectKeyParameter.valueAsString,s3Prefix=cfn_fn_1.Fn.select(0,cfn_fn_1.Fn.split(cxapi.ASSET_PREFIX_SEPARATOR,encodedKey)),s3Filename=cfn_fn_1.Fn.select(1,cfn_fn_1.Fn.split(cxapi.ASSET_PREFIX_SEPARATOR,encodedKey)),objectKey=`${s3Prefix}${s3Filename}`,httpUrl=`https://s3.${this.boundStack.region}.${this.boundStack.urlSuffix}/${bucketName}/${objectKey}`,s3ObjectUrl=`s3://${bucketName}/${objectKey}`;return{bucketName,objectKey,httpUrl,s3ObjectUrl,s3Url:httpUrl}}get assetParameters(){return _shared_1.assertBound(this.boundStack),this._assetParameters||(this._assetParameters=new constructs_1.Construct(this.boundStack,"AssetParameters")),this._assetParameters}}exports.LegacyStackSynthesizer=LegacyStackSynthesizer,_a=JSII_RTTI_SYMBOL_1,LegacyStackSynthesizer[_a]={fqn:"aws-cdk-lib.LegacyStackSynthesizer",version:"2.69.0"};function withoutDeprecationWarnings(block){const orig=process.env.JSII_DEPRECATED;process.env.JSII_DEPRECATED="quiet";try{return block()}finally{process.env.JSII_DEPRECATED=orig}}
