"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.resolvedTypeHint=exports.RememberingTokenResolver=exports.findTokens=exports.resolve=exports.INTRINSIC_KEY_PREFIX=void 0;const encoding_1=require("./encoding"),token_map_1=require("./token-map"),resolvable_1=require("../resolvable"),type_hints_1=require("../type-hints"),tokenMap=token_map_1.TokenMap.instance(),RESOLUTION_TYPEHINT_SYM=Symbol.for("@aws-cdk/core.resolvedTypeHint");exports.INTRINSIC_KEY_PREFIX="$IntrinsicKey$";function resolve(obj,options){const prefix=options.prefix||[],pathName="/"+prefix.join("/");function makeContext(appendPath){const newPrefix=appendPath!==void 0?prefix.concat([appendPath]):options.prefix;let postProcessor;const context={preparing:options.preparing,scope:options.scope,documentPath:newPrefix??[],registerPostProcessor(pp){postProcessor=pp},resolve(x,changeOptions){return resolve(x,{...options,...changeOptions,prefix:newPrefix})}};return[context,{postProcess(x){return postProcessor?postProcessor.postProcess(x,context):x}}]}if(prefix.length>200)throw new Error("Unable to resolve object tree with circular reference. Path: "+pathName);const leaveEmpty=options.removeEmpty===!1;if(typeof obj>"u")return;if(obj===null)return null;if(typeof obj=="function")throw new Error(`Trying to resolve a non-data object. Only token are supported for lazy evaluation. Path: ${pathName}. Object: ${obj}`);if(typeof obj=="string"){if(encoding_1.TokenString.forListToken(obj).test())throw new Error("Found an encoded list token string in a scalar string context. Use 'Fn.select(0, list)' (not 'list[0]') to extract elements from token lists.");const str=encoding_1.TokenString.forString(obj);if(str.test()){const fragments=str.split(tokenMap.lookupToken.bind(tokenMap));return tagResolvedValue(options.resolver.resolveString(fragments,makeContext()[0]),type_hints_1.ResolutionTypeHint.STRING)}return obj}if(typeof obj=="number")return tagResolvedValue(resolveNumberToken(obj,makeContext()[0]),type_hints_1.ResolutionTypeHint.NUMBER);if(typeof obj!="object"||obj instanceof Date)return obj;if(Array.isArray(obj))return encoding_1.containsListTokenElement(obj)?tagResolvedValue(options.resolver.resolveList(obj,makeContext()[0]),type_hints_1.ResolutionTypeHint.STRING_LIST):obj.map((x,i)=>makeContext(`${i}`)[0].resolve(x)).filter(x=>leaveEmpty||typeof x<"u");if(encoding_1.unresolved(obj)){const[context,postProcessor]=makeContext();return tagResolvedValue(options.resolver.resolveToken(obj,context,postProcessor),type_hints_1.ResolutionTypeHint.STRING)}if(isConstruct(obj))throw new Error("Trying to resolve() a Construct at "+pathName);const result={};let intrinsicKeyCtr=0;for(const key of Object.keys(obj)){const value=makeContext(String(key))[0].resolve(obj[key]);if(typeof value>"u"){leaveEmpty&&(result[key]=void 0);continue}if(!encoding_1.unresolved(key)){result[key]=value;continue}const resolvedKey=makeContext()[0].resolve(key);if(typeof resolvedKey=="string")result[resolvedKey]=value;else{if(!options.allowIntrinsicKeys)throw new Error(`"${String(key)}" is used as the key in a map so must resolve to a string, but it resolves to: ${JSON.stringify(resolvedKey)}. Consider using "CfnJson" to delay resolution to deployment-time`);result[`${exports.INTRINSIC_KEY_PREFIX}${intrinsicKeyCtr++}`]=[resolvedKey,value]}}const previousTypeHint=resolvedTypeHint(obj);return previousTypeHint?tagResolvedValue(result,previousTypeHint):result}exports.resolve=resolve;function findTokens(scope,fn){const resolver=new RememberingTokenResolver(new resolvable_1.StringConcat);return resolve(fn(),{scope,prefix:[],resolver,preparing:!0}),resolver.tokens}exports.findTokens=findTokens;class RememberingTokenResolver extends resolvable_1.DefaultTokenResolver{constructor(){super(...arguments),this.tokensSeen=new Set}resolveToken(t,context,postProcessor){return this.tokensSeen.add(t),super.resolveToken(t,context,postProcessor)}resolveString(s,context){return super.resolveString(s,context)}get tokens(){return Array.from(this.tokensSeen)}}exports.RememberingTokenResolver=RememberingTokenResolver;function isConstruct(x){return x._children!==void 0&&x._metadata!==void 0}function resolveNumberToken(x,context){const token=token_map_1.TokenMap.instance().lookupNumberToken(x);return token===void 0?x:context.resolve(token)}function tagResolvedValue(value,typeHint){return typeof value!="object"||value==null||Object.defineProperty(value,RESOLUTION_TYPEHINT_SYM,{value:typeHint,configurable:!0}),value}function resolvedTypeHint(value){if(!(typeof value!="object"||value==null))return value[RESOLUTION_TYPEHINT_SYM]}exports.resolvedTypeHint=resolvedTypeHint;
