"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.integrationResourceArn=exports.validatePatternSupported=void 0;const aws_stepfunctions_1=require("../../../aws-stepfunctions"),core_1=require("../../../core");function validatePatternSupported(integrationPattern,supportedPatterns){if(!supportedPatterns.includes(integrationPattern))throw new Error(`Unsupported service integration pattern. Supported Patterns: ${supportedPatterns}. Received: ${integrationPattern}`)}exports.validatePatternSupported=validatePatternSupported;const resourceArnSuffix={[aws_stepfunctions_1.IntegrationPattern.REQUEST_RESPONSE]:"",[aws_stepfunctions_1.IntegrationPattern.RUN_JOB]:".sync",[aws_stepfunctions_1.IntegrationPattern.WAIT_FOR_TASK_TOKEN]:".waitForTaskToken"};function integrationResourceArn(service,api,integrationPattern){if(!service||!api)throw new Error("Both 'service' and 'api' must be provided to build the resource ARN.");return`arn:${core_1.Aws.PARTITION}:states:::${service}:${api}`+(integrationPattern?resourceArnSuffix[integrationPattern]:"")}exports.integrationResourceArn=integrationResourceArn;
