"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.RESERVED_TUNNEL_INSIDE_CIDR=exports.VpnConnection=exports.VpnConnectionBase=exports.VpnGateway=exports.VpnConnectionType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),net=require("net"),cloudwatch=require("../../aws-cloudwatch"),core_1=require("../../core"),ec2_generated_1=require("./ec2.generated");var VpnConnectionType;(function(VpnConnectionType2){VpnConnectionType2.IPSEC_1="ipsec.1",VpnConnectionType2.DUMMY="dummy"})(VpnConnectionType=exports.VpnConnectionType||(exports.VpnConnectionType={}));class VpnGateway extends core_1.Resource{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_VpnGatewayProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,VpnGateway),error}const vpnGW=new ec2_generated_1.CfnVPNGateway(this,"Default",props);this.gatewayId=vpnGW.ref}}exports.VpnGateway=VpnGateway,_a=JSII_RTTI_SYMBOL_1,VpnGateway[_a]={fqn:"aws-cdk-lib.aws_ec2.VpnGateway",version:"2.69.0"};class VpnConnectionBase extends core_1.Resource{}exports.VpnConnectionBase=VpnConnectionBase,_b=JSII_RTTI_SYMBOL_1,VpnConnectionBase[_b]={fqn:"aws-cdk-lib.aws_ec2.VpnConnectionBase",version:"2.69.0"};class VpnConnection extends VpnConnectionBase{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_VpnConnectionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,VpnConnection),error}if(props.vpc.vpnGatewayId||props.vpc.enableVpnGateway({type:"ipsec.1",amazonSideAsn:props.asn}),!core_1.Token.isUnresolved(props.ip)&&!net.isIPv4(props.ip))throw new Error(`The \`ip\` ${props.ip} is not a valid IPv4 address.`);const type=VpnConnectionType.IPSEC_1,bgpAsn=props.asn||65e3,customerGateway=new ec2_generated_1.CfnCustomerGateway(this,"CustomerGateway",{bgpAsn,ipAddress:props.ip,type});if(this.customerGatewayId=customerGateway.ref,this.customerGatewayAsn=bgpAsn,this.customerGatewayIp=props.ip,props.tunnelOptions){if(props.tunnelOptions.length>2)throw new Error("Cannot specify more than two `tunnelOptions`");if(props.tunnelOptions.length===2&&props.tunnelOptions[0].tunnelInsideCidr===props.tunnelOptions[1].tunnelInsideCidr)throw new Error(`Same ${props.tunnelOptions[0].tunnelInsideCidr} \`tunnelInsideCidr\` cannot be used for both tunnels.`);props.tunnelOptions.forEach((options,index)=>{if(options.preSharedKey&&options.preSharedKeySecret)throw new Error("Specify at most one of 'preSharedKey' and 'preSharedKeySecret'.");if(options.preSharedKey&&!core_1.Token.isUnresolved(options.preSharedKey)&&!/^[a-zA-Z1-9._][a-zA-Z\d._]{7,63}$/.test(options.preSharedKey))throw new Error(`The \`preSharedKey\` ${options.preSharedKey} for tunnel ${index+1} is invalid. Allowed characters are alphanumeric characters and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).`);if(options.tunnelInsideCidr){if(exports.RESERVED_TUNNEL_INSIDE_CIDR.includes(options.tunnelInsideCidr))throw new Error(`The \`tunnelInsideCidr\` ${options.tunnelInsideCidr} for tunnel ${index+1} is a reserved inside CIDR.`);if(!/^169\.254\.\d{1,3}\.\d{1,3}\/30$/.test(options.tunnelInsideCidr))throw new Error(`The \`tunnelInsideCidr\` ${options.tunnelInsideCidr} for tunnel ${index+1} is not a size /30 CIDR block from the 169.254.0.0/16 range.`)}})}const vpnConnection=new ec2_generated_1.CfnVPNConnection(this,"Resource",{type,customerGatewayId:customerGateway.ref,staticRoutesOnly:!!props.staticRoutes,vpnGatewayId:props.vpc.vpnGatewayId,vpnTunnelOptionsSpecifications:props.tunnelOptions?.map(t=>({preSharedKey:t.preSharedKeySecret?.unsafeUnwrap()??t.preSharedKey,tunnelInsideCidr:t.tunnelInsideCidr}))});this.vpnId=vpnConnection.ref,props.staticRoutes&&props.staticRoutes.forEach(route=>{new ec2_generated_1.CfnVPNConnectionRoute(this,`Route${route.replace(/[^\d]/g,"")}`,{destinationCidrBlock:route,vpnConnectionId:this.vpnId})})}static fromVpnConnectionAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_VpnConnectionAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromVpnConnectionAttributes),error}class Import extends VpnConnectionBase{constructor(){super(...arguments),this.vpnId=attrs.vpnId,this.customerGatewayId=attrs.customerGatewayId,this.customerGatewayIp=attrs.customerGatewayIp,this.customerGatewayAsn=attrs.customerGatewayAsn}}return new Import(scope,id)}static metricAll(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAll),error}return new cloudwatch.Metric({namespace:"AWS/VPN",metricName,...props})}static metricAllTunnelState(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllTunnelState),error}return this.metricAll("TunnelState",{statistic:"avg",...props})}static metricAllTunnelDataIn(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllTunnelDataIn),error}return this.metricAll("TunnelDataIn",{statistic:"sum",...props})}static metricAllTunnelDataOut(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllTunnelDataOut),error}return this.metricAll("TunnelDataOut",{statistic:"sum",...props})}}exports.VpnConnection=VpnConnection,_c=JSII_RTTI_SYMBOL_1,VpnConnection[_c]={fqn:"aws-cdk-lib.aws_ec2.VpnConnection",version:"2.69.0"},exports.RESERVED_TUNNEL_INSIDE_CIDR=["169.254.0.0/30","169.254.1.0/30","169.254.2.0/30","169.254.3.0/30","169.254.4.0/30","169.254.5.0/30","169.254.169.252/30"];
