"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.BastionHostLinux=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aws_iam_1=require("../../aws-iam"),core_1=require("../../core"),_1=require("."),instance_1=require("./instance"),machine_image_1=require("./machine-image"),port_1=require("./port");class BastionHostLinux extends core_1.Resource{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_BastionHostLinuxProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BastionHostLinux),error}this.stack=core_1.Stack.of(scope);const instanceType=props.instanceType??_1.InstanceType.of(_1.InstanceClass.T3,_1.InstanceSize.NANO);this.instance=new instance_1.Instance(this,"Resource",{vpc:props.vpc,availabilityZone:props.availabilityZone,securityGroup:props.securityGroup,instanceName:props.instanceName??"BastionHost",instanceType,machineImage:props.machineImage??machine_image_1.MachineImage.latestAmazonLinux({generation:_1.AmazonLinuxGeneration.AMAZON_LINUX_2,cpuType:this.toAmazonLinuxCpuType(instanceType.architecture)}),vpcSubnets:props.subnetSelection??{},blockDevices:props.blockDevices??void 0,init:props.init,initOptions:props.initOptions,requireImdsv2:props.requireImdsv2??!1}),this.instance.addToRolePolicy(new aws_iam_1.PolicyStatement({actions:["ssmmessages:*","ssm:UpdateInstanceInformation","ec2messages:*"],resources:["*"]})),this.connections=this.instance.connections,this.role=this.instance.role,this.grantPrincipal=this.instance.role,this.instanceId=this.instance.instanceId,this.instancePrivateIp=this.instance.instancePrivateIp,this.instanceAvailabilityZone=this.instance.instanceAvailabilityZone,this.instancePrivateDnsName=this.instance.instancePrivateDnsName,this.instancePublicIp=this.instance.instancePublicIp,this.instancePublicDnsName=this.instance.instancePublicDnsName,new core_1.CfnOutput(this,"BastionHostId",{description:"Instance ID of the bastion host. Use this to connect via SSM Session Manager",value:this.instanceId})}toAmazonLinuxCpuType(architecture){if(architecture===_1.InstanceArchitecture.ARM_64)return machine_image_1.AmazonLinuxCpuType.ARM_64;if(architecture===_1.InstanceArchitecture.X86_64)return machine_image_1.AmazonLinuxCpuType.X86_64;throw new Error(`Unsupported instance architecture '${architecture}'`)}allowSshAccessFrom(...peer){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_IPeer(peer)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.allowSshAccessFrom),error}peer.forEach(p=>{this.connections.allowFrom(p,port_1.Port.tcp(22),"SSH access")})}}exports.BastionHostLinux=BastionHostLinux,_a=JSII_RTTI_SYMBOL_1,BastionHostLinux[_a]={fqn:"aws-cdk-lib.aws_ec2.BastionHostLinux",version:"2.69.0"};
