"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.normalizeRawStringStatistic=exports.normalizeStatistic=exports.parseStatistic=exports.pairStatisticToString=exports.singleStatisticToString=void 0;const stats_1=require("../stats");function parseSingleStatistic(statistic,prefix){const prefixLower=prefix.toLowerCase();if(statistic=statistic.toLowerCase(),!statistic.startsWith(prefixLower))return;let r=null;if(r=new RegExp(`^${prefixLower}(\\d{1,2}(?:\\.\\d+)?)$`).exec(statistic),r)return{type:"single",rawStatistic:statistic,statPrefix:prefixLower,value:parseFloat(r[1])}}function parsePairStatistic(statistic,prefix){const prefixUpper=prefix.toUpperCase();if(statistic=statistic.toUpperCase(),!statistic.startsWith(prefixUpper))return;const common={type:"pair",canBeSingleStat:!1,rawStatistic:statistic,statPrefix:prefixUpper};let r=null;if(r=new RegExp(`^${prefixUpper}\\((\\d+(?:\\.\\d+)?)\\:\\)$`).exec(statistic),r)return{...common,lower:parseFloat(r[1]),upper:void 0,isPercent:!1};if(r=new RegExp(`^${prefixUpper}\\((\\d{1,2}(?:\\.\\d+)?)%\\:\\)$`).exec(statistic),r)return{...common,lower:parseFloat(r[1]),upper:void 0,isPercent:!0};if(r=new RegExp(`^${prefixUpper}\\(\\:(\\d+(?:\\.\\d+)?)\\)$`).exec(statistic),r)return{...common,lower:void 0,upper:parseFloat(r[1]),isPercent:!1};if(r=new RegExp(`^${prefixUpper}\\(\\:(\\d{1,2}(?:\\.\\d+)?)%\\)$`).exec(statistic),r)return{...common,canBeSingleStat:!0,asSingleStatStr:`${prefix.toLowerCase()}${r[1]}`,lower:void 0,upper:parseFloat(r[1]),isPercent:!0};if(r=new RegExp(`^${prefixUpper}\\((\\d+(?:\\.\\d+)?)\\:(\\d+(?:\\.\\d+)?)\\)$`).exec(statistic),r)return{...common,lower:parseFloat(r[1]),upper:parseFloat(r[2]),isPercent:!1};if(r=new RegExp(`^${prefixUpper}\\((\\d{1,2}(?:\\.\\d+)?)%\\:(\\d{1,2}(?:\\.\\d+)?)%\\)$`).exec(statistic),r)return{...common,lower:parseFloat(r[1]),upper:parseFloat(r[2]),isPercent:!0}}function singleStatisticToString(parsed){return`${parsed.statPrefix}${parsed.value}`}exports.singleStatisticToString=singleStatisticToString;function pairStatisticToString(parsed){const percent=parsed.isPercent?"%":"",lower=parsed.lower?`${parsed.lower}${percent}`:"",upper=parsed.upper?`${parsed.upper}${percent}`:"";return`${parsed.statPrefix}(${lower}:${upper})`}exports.pairStatisticToString=pairStatisticToString;function parseStatistic(stat){const lowerStat=stat.toLowerCase(),statMap={average:stats_1.Stats.AVERAGE,avg:stats_1.Stats.AVERAGE,minimum:stats_1.Stats.MINIMUM,min:stats_1.Stats.MINIMUM,maximum:stats_1.Stats.MAXIMUM,max:stats_1.Stats.MAXIMUM,samplecount:stats_1.Stats.SAMPLE_COUNT,n:stats_1.Stats.SAMPLE_COUNT,sum:stats_1.Stats.SUM,iqm:stats_1.Stats.IQM};if(lowerStat in statMap)return{type:"simple",statistic:statMap[lowerStat]};let m;return m=parseSingleStatistic(stat,"p"),m?{...m,statName:"percentile"}:(m=parseSingleStatistic(stat,"tm")||parsePairStatistic(stat,"tm"),m?{...m,statName:"trimmedMean"}:(m=parseSingleStatistic(stat,"wm")||parsePairStatistic(stat,"wm"),m?{...m,statName:"winsorizedMean"}:(m=parseSingleStatistic(stat,"tc")||parsePairStatistic(stat,"tc"),m?{...m,statName:"trimmedCount"}:(m=parseSingleStatistic(stat,"ts")||parsePairStatistic(stat,"ts"),m?{...m,statName:"trimmedSum"}:{type:"generic",statistic:stat}))))}exports.parseStatistic=parseStatistic;function normalizeStatistic(parsed){return parsed.type==="simple"||parsed.type==="generic"?parsed.statistic:parsed.type==="single"?parsed.rawStatistic.toLowerCase():parsed.type==="pair"?parsed.rawStatistic.toUpperCase():""}exports.normalizeStatistic=normalizeStatistic;function normalizeRawStringStatistic(stat){const parsed=parseStatistic(stat);return normalizeStatistic(parsed)}exports.normalizeRawStringStatistic=normalizeRawStringStatistic;
