"use strict";var _a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.OriginRequestQueryStringBehavior=exports.OriginRequestHeaderBehavior=exports.OriginRequestCookieBehavior=exports.OriginRequestPolicy=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),core_1=require("../../core"),cloudfront_generated_1=require("./cloudfront.generated");class OriginRequestPolicy extends core_1.Resource{constructor(scope,id,props={}){super(scope,id,{physicalName:props.originRequestPolicyName});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudfront_OriginRequestPolicyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,OriginRequestPolicy),error}const originRequestPolicyName=props.originRequestPolicyName??core_1.Names.uniqueId(this);if(!core_1.Token.isUnresolved(originRequestPolicyName)&&!originRequestPolicyName.match(/^[\w-]+$/i))throw new Error(`'originRequestPolicyName' can only include '-', '_', and alphanumeric characters, got: '${props.originRequestPolicyName}'`);const cookies=props.cookieBehavior??OriginRequestCookieBehavior.none(),headers=props.headerBehavior??OriginRequestHeaderBehavior.none(),queryStrings=props.queryStringBehavior??OriginRequestQueryStringBehavior.none(),resource=new cloudfront_generated_1.CfnOriginRequestPolicy(this,"Resource",{originRequestPolicyConfig:{name:originRequestPolicyName,comment:props.comment,cookiesConfig:{cookieBehavior:cookies.behavior,cookies:cookies.cookies},headersConfig:{headerBehavior:headers.behavior,headers:headers.headers},queryStringsConfig:{queryStringBehavior:queryStrings.behavior,queryStrings:queryStrings.queryStrings}}});this.originRequestPolicyId=resource.ref}static fromOriginRequestPolicyId(scope,id,originRequestPolicyId){return new class extends core_1.Resource{constructor(){super(...arguments),this.originRequestPolicyId=originRequestPolicyId}}(scope,id)}static fromManagedOriginRequestPolicy(managedOriginRequestPolicyId){return new class{constructor(){this.originRequestPolicyId=managedOriginRequestPolicyId}}}}exports.OriginRequestPolicy=OriginRequestPolicy,_a=JSII_RTTI_SYMBOL_1,OriginRequestPolicy[_a]={fqn:"aws-cdk-lib.aws_cloudfront.OriginRequestPolicy",version:"2.69.0"},OriginRequestPolicy.USER_AGENT_REFERER_HEADERS=OriginRequestPolicy.fromManagedOriginRequestPolicy("acba4595-bd28-49b8-b9fe-13317c0390fa"),OriginRequestPolicy.CORS_CUSTOM_ORIGIN=OriginRequestPolicy.fromManagedOriginRequestPolicy("59781a5b-3903-41f3-afcb-af62929ccde1"),OriginRequestPolicy.CORS_S3_ORIGIN=OriginRequestPolicy.fromManagedOriginRequestPolicy("88a5eaf4-2fd4-4709-b370-b4c650ea3fcf"),OriginRequestPolicy.ALL_VIEWER=OriginRequestPolicy.fromManagedOriginRequestPolicy("216adef6-5c7f-47e4-b989-5492eafa07d3"),OriginRequestPolicy.ELEMENTAL_MEDIA_TAILOR=OriginRequestPolicy.fromManagedOriginRequestPolicy("775133bc-15f2-49f9-abea-afb2e0bf67d2"),OriginRequestPolicy.ALL_VIEWER_AND_CLOUDFRONT_2022=OriginRequestPolicy.fromManagedOriginRequestPolicy("33f36d7e-f396-46d9-90e0-52428a34d9dc");class OriginRequestCookieBehavior{constructor(behavior,cookies){this.behavior=behavior,this.cookies=cookies}static none(){return new OriginRequestCookieBehavior("none")}static all(){return new OriginRequestCookieBehavior("all")}static allowList(...cookies){if(cookies.length===0)throw new Error("At least one cookie to allow must be provided");return new OriginRequestCookieBehavior("whitelist",cookies)}}exports.OriginRequestCookieBehavior=OriginRequestCookieBehavior,_b=JSII_RTTI_SYMBOL_1,OriginRequestCookieBehavior[_b]={fqn:"aws-cdk-lib.aws_cloudfront.OriginRequestCookieBehavior",version:"2.69.0"};class OriginRequestHeaderBehavior{constructor(behavior,headers){this.behavior=behavior,this.headers=headers}static none(){return new OriginRequestHeaderBehavior("none")}static all(...cloudfrontHeaders){if(cloudfrontHeaders.length>0){if(!cloudfrontHeaders.every(header=>header.startsWith("CloudFront-")))throw new Error("additional CloudFront headers passed to `OriginRequestHeaderBehavior.all()` must begin with 'CloudFront-'");return new OriginRequestHeaderBehavior("allViewerAndWhitelistCloudFront",cloudfrontHeaders)}else return new OriginRequestHeaderBehavior("allViewer")}static allowList(...headers){if(headers.length===0)throw new Error("At least one header to allow must be provided");if(headers.map(header=>header.toLowerCase()).some(header=>["authorization","accept-encoding"].includes(header)))throw new Error("you cannot pass `Authorization` or `Accept-Encoding` as header values; use a CachePolicy to forward these headers instead");return new OriginRequestHeaderBehavior("whitelist",headers)}}exports.OriginRequestHeaderBehavior=OriginRequestHeaderBehavior,_c=JSII_RTTI_SYMBOL_1,OriginRequestHeaderBehavior[_c]={fqn:"aws-cdk-lib.aws_cloudfront.OriginRequestHeaderBehavior",version:"2.69.0"};class OriginRequestQueryStringBehavior{constructor(behavior,queryStrings){this.behavior=behavior,this.queryStrings=queryStrings}static none(){return new OriginRequestQueryStringBehavior("none")}static all(){return new OriginRequestQueryStringBehavior("all")}static allowList(...queryStrings){if(queryStrings.length===0)throw new Error("At least one query string to allow must be provided");return new OriginRequestQueryStringBehavior("whitelist",queryStrings)}}exports.OriginRequestQueryStringBehavior=OriginRequestQueryStringBehavior,_d=JSII_RTTI_SYMBOL_1,OriginRequestQueryStringBehavior[_d]={fqn:"aws-cdk-lib.aws_cloudfront.OriginRequestQueryStringBehavior",version:"2.69.0"};
