"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.AssetManifestBuilder=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),cxschema=require("../../../cloud-assembly-schema"),_shared_1=require("./_shared"),assets_1=require("../assets");class AssetManifestBuilder{constructor(){this.files={},this.dockerImages={}}defaultAddFileAsset(stack,asset,target){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack),jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset),jsiiDeprecationWarnings.aws_cdk_lib_AssetManifestFileDestination(target)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.defaultAddFileAsset),error}validateFileAssetSource(asset);const extension=asset.fileName!=null?path.extname(asset.fileName):"",objectKey=(target.bucketPrefix??"")+asset.sourceHash+(asset.packaging===assets_1.FileAssetPackaging.ZIP_DIRECTORY?".zip":extension);return this.addFileAsset(stack,asset.sourceHash,{path:asset.fileName,executable:asset.executable,packaging:asset.packaging},{bucketName:target.bucketName,objectKey,region:_shared_1.resolvedOr(stack.region,void 0),assumeRoleArn:target.role?.assumeRoleArn,assumeRoleExternalId:target.role?.assumeRoleExternalId})}defaultAddDockerImageAsset(stack,asset,target){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack),jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset),jsiiDeprecationWarnings.aws_cdk_lib_AssetManifestDockerImageDestination(target)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.defaultAddDockerImageAsset),error}validateDockerImageAssetSource(asset);const imageTag=`${target.dockerTagPrefix??""}${asset.sourceHash}`;return this.addDockerImageAsset(stack,asset.sourceHash,{executable:asset.executable,directory:asset.directoryName,dockerBuildArgs:asset.dockerBuildArgs,dockerBuildSecrets:asset.dockerBuildSecrets,dockerBuildTarget:asset.dockerBuildTarget,dockerFile:asset.dockerFile,networkMode:asset.networkMode,platform:asset.platform,dockerOutputs:asset.dockerOutputs,cacheFrom:asset.dockerCacheFrom,cacheTo:asset.dockerCacheTo},{repositoryName:target.repositoryName,imageTag,region:_shared_1.resolvedOr(stack.region,void 0),assumeRoleArn:target.role?.assumeRoleArn,assumeRoleExternalId:target.role?.assumeRoleExternalId})}addFileAsset(stack,sourceHash,source,dest){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack),jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_FileSource(source),jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_FileDestination(dest)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFileAsset),error}return this.files[sourceHash]||(this.files[sourceHash]={source,destinations:{}}),this.files[sourceHash].destinations[this.manifestEnvName(stack)]=dest,dest}addDockerImageAsset(stack,sourceHash,source,dest){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack),jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_DockerImageSource(source),jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_DockerImageDestination(dest)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDockerImageAsset),error}return this.dockerImages[sourceHash]||(this.dockerImages[sourceHash]={source,destinations:{}}),this.dockerImages[sourceHash].destinations[this.manifestEnvName(stack)]=dest,dest}get hasAssets(){return Object.keys(this.files).length+Object.keys(this.dockerImages).length>0}emitManifest(stack,session,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack),jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session),jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_AssetManifestOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.emitManifest),error}const artifactId=`${stack.artifactId}.assets`,manifestFile=`${artifactId}.json`,outPath=path.join(session.assembly.outdir,manifestFile),manifest={version:cxschema.Manifest.version(),files:this.files,dockerImages:this.dockerImages};return fs.writeFileSync(outPath,JSON.stringify(manifest,void 0,2)),session.assembly.addArtifact(artifactId,{type:cxschema.ArtifactType.ASSET_MANIFEST,properties:{file:manifestFile,...options}}),artifactId}manifestEnvName(stack){return[_shared_1.resolvedOr(stack.account,"current_account"),_shared_1.resolvedOr(stack.region,"current_region")].join("-")}}exports.AssetManifestBuilder=AssetManifestBuilder,_a=JSII_RTTI_SYMBOL_1,AssetManifestBuilder[_a]={fqn:"aws-cdk-lib.AssetManifestBuilder",version:"2.69.0"};function validateFileAssetSource(asset){if(!!asset.executable==!!asset.fileName)throw new Error(`Exactly one of 'fileName' or 'executable' is required, got: ${JSON.stringify(asset)}`);if(!!asset.packaging!=!!asset.fileName)throw new Error(`'packaging' is expected in combination with 'fileName', got: ${JSON.stringify(asset)}`)}function validateDockerImageAssetSource(asset){if(!!asset.executable==!!asset.directoryName)throw new Error(`Exactly one of 'directoryName' or 'executable' is required, got: ${JSON.stringify(asset)}`);check("dockerBuildArgs"),check("dockerBuildTarget"),check("dockerOutputs"),check("dockerFile");function check(key){if(asset[key]&&!asset.directoryName)throw new Error(`'${key}' is only allowed in combination with 'directoryName', got: ${JSON.stringify(asset)}`)}}
