"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.OptionGroup=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2=require("../../aws-ec2"),core_1=require("../../core"),rds_generated_1=require("./rds.generated");class OptionGroup extends core_1.Resource{constructor(scope,id,props){super(scope,id),this.optionConnections={},this.configurations=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_OptionGroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,OptionGroup),error}const majorEngineVersion=props.engine.engineVersion?.majorVersion;if(!majorEngineVersion)throw new Error("OptionGroup cannot be used with an engine that doesn't specify a version");props.configurations.forEach(config=>this.addConfiguration(config));const optionGroup=new rds_generated_1.CfnOptionGroup(this,"Resource",{engineName:props.engine.engineType,majorEngineVersion,optionGroupDescription:props.description||`Option group for ${props.engine.engineType} ${majorEngineVersion}`,optionConfigurations:core_1.Lazy.any({produce:()=>this.renderConfigurations(this.configurations)})});this.optionGroupName=optionGroup.ref}static fromOptionGroupName(scope,id,optionGroupName){class Import extends core_1.Resource{constructor(){super(...arguments),this.optionGroupName=optionGroupName}addConfiguration(_){return!1}}return new Import(scope,id)}addConfiguration(configuration){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_OptionConfiguration(configuration)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addConfiguration),error}if(this.configurations.push(configuration),configuration.port){if(!configuration.vpc)throw new Error("`port` and `vpc` must be specified together.");const securityGroups=configuration.securityGroups&&configuration.securityGroups.length>0?configuration.securityGroups:[new ec2.SecurityGroup(this,`SecurityGroup${configuration.name}`,{description:`Security group for ${configuration.name} option`,vpc:configuration.vpc})];this.optionConnections[configuration.name]=new ec2.Connections({securityGroups,defaultPort:ec2.Port.tcp(configuration.port)})}return!0}renderConfigurations(configurations){const configs=[];for(const config of configurations){const securityGroups=config.vpc?this.optionConnections[config.name].securityGroups.map(sg=>sg.securityGroupId):void 0;configs.push({optionName:config.name,optionSettings:config.settings&&Object.entries(config.settings).map(([name,value])=>({name,value})),optionVersion:config.version,port:config.port,vpcSecurityGroupMemberships:securityGroups})}return configs}}exports.OptionGroup=OptionGroup,_a=JSII_RTTI_SYMBOL_1,OptionGroup[_a]={fqn:"aws-cdk-lib.aws_rds.OptionGroup",version:"2.69.0"};
