"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.HttpCodeTarget=exports.HttpCodeElb=exports.ApplicationLoadBalancer=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudwatch=require("../../../aws-cloudwatch"),ec2=require("../../../aws-ec2"),cxschema=require("../../../cloud-assembly-schema"),core_1=require("../../../core"),cxapi=require("../../../cx-api"),application_listener_1=require("./application-listener"),application_listener_action_1=require("./application-listener-action"),elasticloadbalancingv2_canned_metrics_generated_1=require("../elasticloadbalancingv2-canned-metrics.generated"),base_load_balancer_1=require("../shared/base-load-balancer"),enums_1=require("../shared/enums"),util_1=require("../shared/util");class ApplicationLoadBalancer extends base_load_balancer_1.BaseLoadBalancer{constructor(scope,id,props){super(scope,id,props,{type:"application",securityGroups:core_1.Lazy.list({produce:()=>this.connections.securityGroups.map(sg=>sg.securityGroupId)}),ipAddressType:props.ipAddressType});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationLoadBalancerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ApplicationLoadBalancer),error}this.ipAddressType=props.ipAddressType??enums_1.IpAddressType.IPV4;const securityGroups=[props.securityGroup||new ec2.SecurityGroup(this,"SecurityGroup",{vpc:props.vpc,description:`Automatically created Security Group for ELB ${core_1.Names.uniqueId(this)}`,allowAllOutbound:!1})];this.connections=new ec2.Connections({securityGroups}),this.listeners=[],this.metrics=new ApplicationLoadBalancerMetrics(this,this.loadBalancerFullName),props.http2Enabled===!1&&this.setAttribute("routing.http2.enabled","false"),props.idleTimeout!==void 0&&this.setAttribute("idle_timeout.timeout_seconds",props.idleTimeout.toSeconds().toString()),props.dropInvalidHeaderFields&&this.setAttribute("routing.http.drop_invalid_header_fields.enabled","true"),props.desyncMitigationMode!==void 0&&this.setAttribute("routing.http.desync_mitigation_mode",props.desyncMitigationMode)}static fromLookup(scope,id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationLoadBalancerLookupOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLookup),error}const props=base_load_balancer_1.BaseLoadBalancer._queryContextProvider(scope,{userOptions:options,loadBalancerType:cxschema.LoadBalancerType.APPLICATION});return new LookedUpApplicationLoadBalancer(scope,id,props)}static fromApplicationLoadBalancerAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationLoadBalancerAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromApplicationLoadBalancerAttributes),error}return new ImportedApplicationLoadBalancer(scope,id,attrs)}addListener(id,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_BaseApplicationListenerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addListener),error}const listener=new application_listener_1.ApplicationListener(this,id,{loadBalancer:this,...props});return this.listeners.push(listener),listener}addRedirect(props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_ApplicationLoadBalancerRedirectConfig(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addRedirect),error}const sourcePort=props.sourcePort??80,targetPort=(props.targetPort??443).toString();return this.addListener(`Redirect${sourcePort}To${targetPort}`,{protocol:props.sourceProtocol??enums_1.ApplicationProtocol.HTTP,port:sourcePort,open:props.open??!0,defaultAction:application_listener_action_1.ListenerAction.redirect({port:targetPort,protocol:props.targetProtocol??enums_1.ApplicationProtocol.HTTPS,permanent:!0})})}addSecurityGroup(securityGroup){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_ISecurityGroup(securityGroup)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecurityGroup),error}this.connections.addSecurityGroup(securityGroup)}metric(metricName,props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metric","Use ``ApplicationLoadBalancer.metrics.custom`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return this.metrics.custom(metricName,props)}metricActiveConnectionCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricActiveConnectionCount","Use ``ApplicationLoadBalancer.metrics.activeConnectionCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricActiveConnectionCount),error}return this.metrics.activeConnectionCount(props)}metricClientTlsNegotiationErrorCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricClientTlsNegotiationErrorCount","Use ``ApplicationLoadBalancer.metrics.clientTlsNegotiationErrorCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricClientTlsNegotiationErrorCount),error}return this.metrics.clientTlsNegotiationErrorCount(props)}metricConsumedLCUs(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricConsumedLCUs","Use ``ApplicationLoadBalancer.metrics.consumedLCUs`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricConsumedLCUs),error}return this.metrics.consumedLCUs(props)}metricHttpFixedResponseCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricHttpFixedResponseCount","Use ``ApplicationLoadBalancer.metrics.httpFixedResponseCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHttpFixedResponseCount),error}return this.metrics.httpFixedResponseCount(props)}metricHttpRedirectCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricHttpRedirectCount","Use ``ApplicationLoadBalancer.metrics.httpRedirectCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHttpRedirectCount),error}return this.metrics.httpRedirectCount(props)}metricHttpRedirectUrlLimitExceededCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricHttpRedirectUrlLimitExceededCount","Use ``ApplicationLoadBalancer.metrics.httpRedirectUrlLimitExceededCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHttpRedirectUrlLimitExceededCount),error}return this.metrics.httpRedirectUrlLimitExceededCount(props)}metricHttpCodeElb(code,props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricHttpCodeElb","Use ``ApplicationLoadBalancer.metrics.httpCodeElb`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_HttpCodeElb(code),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHttpCodeElb),error}return this.metrics.httpCodeElb(code,props)}metricHttpCodeTarget(code,props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricHttpCodeTarget","Use ``ApplicationLoadBalancer.metrics.httpCodeTarget`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_HttpCodeTarget(code),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHttpCodeTarget),error}return this.metrics.httpCodeTarget(code,props)}metricIpv6ProcessedBytes(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricIpv6ProcessedBytes","Use ``ApplicationLoadBalancer.metrics.ipv6ProcessedBytes`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricIpv6ProcessedBytes),error}return this.metrics.ipv6ProcessedBytes(props)}metricIpv6RequestCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricIpv6RequestCount","Use ``ApplicationLoadBalancer.metrics.ipv6RequestCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricIpv6RequestCount),error}return this.metrics.ipv6RequestCount(props)}metricNewConnectionCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricNewConnectionCount","Use ``ApplicationLoadBalancer.metrics.newConnectionCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricNewConnectionCount),error}return this.metrics.newConnectionCount(props)}metricProcessedBytes(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricProcessedBytes","Use ``ApplicationLoadBalancer.metrics.processedBytes`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricProcessedBytes),error}return this.metrics.processedBytes(props)}metricRejectedConnectionCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricRejectedConnectionCount","Use ``ApplicationLoadBalancer.metrics.rejectedConnectionCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricRejectedConnectionCount),error}return this.metrics.rejectedConnectionCount(props)}metricRequestCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricRequestCount","Use ``ApplicationLoadBalancer.metrics.requestCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricRequestCount),error}return this.metrics.requestCount(props)}metricRuleEvaluations(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricRuleEvaluations","Use ``ApplicationLoadBalancer.metrics.ruleEvaluations`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricRuleEvaluations),error}return this.metrics.ruleEvaluations(props)}metricTargetConnectionErrorCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricTargetConnectionErrorCount","Use ``ApplicationLoadBalancer.metrics.targetConnectionErrorCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTargetConnectionErrorCount),error}return this.metrics.targetConnectionErrorCount(props)}metricTargetResponseTime(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricTargetResponseTime","Use ``ApplicationLoadBalancer.metrics.targetResponseTime`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTargetResponseTime),error}return this.metrics.targetResponseTime(props)}metricTargetTLSNegotiationErrorCount(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricTargetTLSNegotiationErrorCount","Use ``ApplicationLoadBalancer.metrics.targetTLSNegotiationErrorCount`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTargetTLSNegotiationErrorCount),error}return this.metrics.targetTLSNegotiationErrorCount(props)}metricElbAuthError(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricElbAuthError","Use ``ApplicationLoadBalancer.metrics.elbAuthError`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricElbAuthError),error}return this.metrics.elbAuthError(props)}metricElbAuthFailure(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricElbAuthFailure","Use ``ApplicationLoadBalancer.metrics.elbAuthFailure`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricElbAuthFailure),error}return this.metrics.elbAuthFailure(props)}metricElbAuthLatency(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricElbAuthLatency","Use ``ApplicationLoadBalancer.metrics.elbAuthLatency`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricElbAuthLatency),error}return this.metrics.elbAuthLatency(props)}metricElbAuthSuccess(props){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer#metricElbAuthSuccess","Use ``ApplicationLoadBalancer.metrics.elbAuthSuccess`` instead"),jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricElbAuthSuccess),error}return this.metrics.elbAuthSuccess(props)}}exports.ApplicationLoadBalancer=ApplicationLoadBalancer,_a=JSII_RTTI_SYMBOL_1,ApplicationLoadBalancer[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer",version:"2.69.0"};class ApplicationLoadBalancerMetrics{constructor(scope,loadBalancerFullName){this.scope=scope,this.loadBalancerFullName=loadBalancerFullName}custom(metricName,props){return new cloudwatch.Metric({namespace:"AWS/ApplicationELB",metricName,dimensionsMap:{LoadBalancer:this.loadBalancerFullName},...props})}activeConnectionCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.activeConnectionCountSum,props)}clientTlsNegotiationErrorCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.clientTlsNegotiationErrorCountSum,props)}consumedLCUs(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.consumedLcUsAverage,{statistic:"sum",...props})}httpFixedResponseCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.httpFixedResponseCountSum,props)}httpRedirectCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.httpRedirectCountSum,props)}httpRedirectUrlLimitExceededCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.httpRedirectUrlLimitExceededCountSum,props)}httpCodeElb(code,props){return this.custom(code,{statistic:"Sum",...props})}httpCodeTarget(code,props){return this.custom(code,{statistic:"Sum",...props})}ipv6ProcessedBytes(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.iPv6ProcessedBytesSum,props)}ipv6RequestCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.iPv6RequestCountSum,props)}newConnectionCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.newConnectionCountSum,props)}processedBytes(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.processedBytesSum,props)}rejectedConnectionCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.rejectedConnectionCountSum,props)}requestCount(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.requestCountSum,props)}ruleEvaluations(props){return this.cannedMetric(elasticloadbalancingv2_canned_metrics_generated_1.ApplicationELBMetrics.ruleEvaluationsSum,props)}targetConnectionErrorCount(props){return this.custom("TargetConnectionErrorCount",{statistic:"Sum",...props})}targetResponseTime(props){return this.custom("TargetResponseTime",{statistic:"Average",...props})}targetTLSNegotiationErrorCount(props){return this.custom("TargetTLSNegotiationErrorCount",{statistic:"Sum",...props})}elbAuthError(props){return this.custom("ELBAuthError",{statistic:"Sum",...props})}elbAuthFailure(props){return this.custom("ELBAuthFailure",{statistic:"Sum",...props})}elbAuthLatency(props){return this.custom("ELBAuthLatency",{statistic:"Average",...props})}elbAuthSuccess(props){return this.custom("ELBAuthSuccess",{statistic:"Sum",...props})}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({LoadBalancer:this.loadBalancerFullName}),...props}).attachTo(this.scope)}}var HttpCodeElb;(function(HttpCodeElb2){HttpCodeElb2.ELB_3XX_COUNT="HTTPCode_ELB_3XX_Count",HttpCodeElb2.ELB_4XX_COUNT="HTTPCode_ELB_4XX_Count",HttpCodeElb2.ELB_5XX_COUNT="HTTPCode_ELB_5XX_Count"})(HttpCodeElb=exports.HttpCodeElb||(exports.HttpCodeElb={}));var HttpCodeTarget;(function(HttpCodeTarget2){HttpCodeTarget2.TARGET_2XX_COUNT="HTTPCode_Target_2XX_Count",HttpCodeTarget2.TARGET_3XX_COUNT="HTTPCode_Target_3XX_Count",HttpCodeTarget2.TARGET_4XX_COUNT="HTTPCode_Target_4XX_Count",HttpCodeTarget2.TARGET_5XX_COUNT="HTTPCode_Target_5XX_Count"})(HttpCodeTarget=exports.HttpCodeTarget||(exports.HttpCodeTarget={}));class ImportedApplicationLoadBalancer extends core_1.Resource{constructor(scope,id,props){super(scope,id,{environmentFromArn:props.loadBalancerArn}),this.props=props,this.vpc=props.vpc,this.loadBalancerArn=props.loadBalancerArn,this.connections=new ec2.Connections({securityGroups:[ec2.SecurityGroup.fromSecurityGroupId(this,"SecurityGroup",props.securityGroupId,{allowAllOutbound:props.securityGroupAllowsAllOutbound})]}),this.metrics=new ApplicationLoadBalancerMetrics(this,util_1.parseLoadBalancerFullName(props.loadBalancerArn))}get listeners(){throw Error(".listeners can only be accessed if the class was constructed as an owned, not imported, load balancer")}addListener(id,props){return new application_listener_1.ApplicationListener(this,id,{loadBalancer:this,...props})}get loadBalancerCanonicalHostedZoneId(){if(this.props.loadBalancerCanonicalHostedZoneId)return this.props.loadBalancerCanonicalHostedZoneId;throw new Error(`'loadBalancerCanonicalHostedZoneId' was not provided when constructing Application Load Balancer ${this.node.path} from attributes`)}get loadBalancerDnsName(){if(this.props.loadBalancerDnsName)return this.props.loadBalancerDnsName;throw new Error(`'loadBalancerDnsName' was not provided when constructing Application Load Balancer ${this.node.path} from attributes`)}}class LookedUpApplicationLoadBalancer extends core_1.Resource{constructor(scope,id,props){super(scope,id,{environmentFromArn:props.loadBalancerArn}),this.loadBalancerArn=props.loadBalancerArn,this.loadBalancerCanonicalHostedZoneId=props.loadBalancerCanonicalHostedZoneId,this.loadBalancerDnsName=props.loadBalancerDnsName,props.ipAddressType===cxapi.LoadBalancerIpAddressType.IPV4?this.ipAddressType=enums_1.IpAddressType.IPV4:props.ipAddressType===cxapi.LoadBalancerIpAddressType.DUAL_STACK&&(this.ipAddressType=enums_1.IpAddressType.DUAL_STACK),this.vpc=ec2.Vpc.fromLookup(this,"Vpc",{vpcId:props.vpcId}),this.connections=new ec2.Connections;for(const securityGroupId of props.securityGroupIds){const securityGroup=ec2.SecurityGroup.fromLookupById(this,`SecurityGroup-${securityGroupId}`,securityGroupId);this.connections.addSecurityGroup(securityGroup)}this.metrics=new ApplicationLoadBalancerMetrics(this,util_1.parseLoadBalancerFullName(this.loadBalancerArn))}get listeners(){throw Error(".listeners can only be accessed if the class was constructed as an owned, not looked up, load balancer")}addListener(id,props){return new application_listener_1.ApplicationListener(this,id,{...props,loadBalancer:this})}}
