"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.BackupVault=exports.BackupVaultEvents=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),core_1=require("../../core"),backup_generated_1=require("./backup.generated");var BackupVaultEvents;(function(BackupVaultEvents2){BackupVaultEvents2.BACKUP_JOB_STARTED="BACKUP_JOB_STARTED",BackupVaultEvents2.BACKUP_JOB_COMPLETED="BACKUP_JOB_COMPLETED",BackupVaultEvents2.BACKUP_JOB_SUCCESSFUL="BACKUP_JOB_SUCCESSFUL",BackupVaultEvents2.BACKUP_JOB_FAILED="BACKUP_JOB_FAILED",BackupVaultEvents2.BACKUP_JOB_EXPIRED="BACKUP_JOB_EXPIRED",BackupVaultEvents2.RESTORE_JOB_STARTED="RESTORE_JOB_STARTED",BackupVaultEvents2.RESTORE_JOB_COMPLETED="RESTORE_JOB_COMPLETED",BackupVaultEvents2.RESTORE_JOB_SUCCESSFUL="RESTORE_JOB_SUCCESSFUL",BackupVaultEvents2.RESTORE_JOB_FAILED="RESTORE_JOB_FAILED",BackupVaultEvents2.COPY_JOB_STARTED="COPY_JOB_STARTED",BackupVaultEvents2.COPY_JOB_SUCCESSFUL="COPY_JOB_SUCCESSFUL",BackupVaultEvents2.COPY_JOB_FAILED="COPY_JOB_FAILED",BackupVaultEvents2.RECOVERY_POINT_MODIFIED="RECOVERY_POINT_MODIFIED",BackupVaultEvents2.BACKUP_PLAN_CREATED="BACKUP_PLAN_CREATED",BackupVaultEvents2.BACKUP_PLAN_MODIFIED="BACKUP_PLAN_MODIFIED",BackupVaultEvents2.S3_BACKUP_OBJECT_FAILED="S3_BACKUP_OBJECT_FAILED",BackupVaultEvents2.S3_RESTORE_OBJECT_FAILED="S3_RESTORE_OBJECT_FAILED"})(BackupVaultEvents=exports.BackupVaultEvents||(exports.BackupVaultEvents={}));class BackupVaultBase extends core_1.Resource{grant(grantee,...actions){for(const action of actions)if(action.indexOf("*")>=0)throw new Error("AWS Backup access policies don't support a wildcard in the Action key.");return iam.Grant.addToPrincipal({grantee,actions,resourceArns:[this.backupVaultArn]})}}class BackupVault extends BackupVaultBase{constructor(scope,id,props={}){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_BackupVaultProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BackupVault),error}if(props.backupVaultName&&!/^[a-zA-Z0-9\-_]{2,50}$/.test(props.backupVaultName))throw new Error("Expected vault name to match pattern `^[a-zA-Z0-9-_]{2,50}$`");let notifications;props.notificationTopic&&(notifications={backupVaultEvents:props.notificationEvents||Object.values(BackupVaultEvents),snsTopicArn:props.notificationTopic.topicArn},props.notificationTopic.grantPublish(new iam.ServicePrincipal("backup.amazonaws.com"))),this.accessPolicy=props.accessPolicy??new iam.PolicyDocument,props.blockRecoveryPointDeletion&&this.blockRecoveryPointDeletion();const vault=new backup_generated_1.CfnBackupVault(this,"Resource",{backupVaultName:props.backupVaultName||this.uniqueVaultName(),accessPolicy:core_1.Lazy.any({produce:()=>this.accessPolicy.toJSON()}),encryptionKeyArn:props.encryptionKey&&props.encryptionKey.keyArn,notifications,lockConfiguration:renderLockConfiguration(props.lockConfiguration)});vault.applyRemovalPolicy(props.removalPolicy),this.backupVaultName=vault.attrBackupVaultName,this.backupVaultArn=vault.attrBackupVaultArn}static fromBackupVaultName(scope,id,backupVaultName){const backupVaultArn=core_1.Stack.of(scope).formatArn({service:"backup",resource:"backup-vault",resourceName:backupVaultName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME});return BackupVault.fromBackupVaultArn(scope,id,backupVaultArn)}static fromBackupVaultArn(scope,id,backupVaultArn){const parsedArn=core_1.Stack.of(scope).splitArn(backupVaultArn,core_1.ArnFormat.SLASH_RESOURCE_NAME);if(!parsedArn.resourceName)throw new Error(`Backup Vault Arn ${backupVaultArn} does not have a resource name.`);class Import extends BackupVaultBase{constructor(){super(...arguments),this.backupVaultName=parsedArn.resourceName,this.backupVaultArn=backupVaultArn}}return new Import(scope,id,{account:parsedArn.account,region:parsedArn.region})}addToAccessPolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToAccessPolicy),error}this.accessPolicy.addStatements(statement)}blockRecoveryPointDeletion(){this.addToAccessPolicy(new iam.PolicyStatement({effect:iam.Effect.DENY,actions:["backup:DeleteRecoveryPoint","backup:UpdateRecoveryPointLifecycle"],principals:[new iam.AnyPrincipal],resources:["*"]}))}uniqueVaultName(){const id=core_1.Names.uniqueId(this);return id.substring(Math.max(id.length-50,0),id.length)}}exports.BackupVault=BackupVault,_a=JSII_RTTI_SYMBOL_1,BackupVault[_a]={fqn:"aws-cdk-lib.aws_backup.BackupVault",version:"2.69.0"};function renderLockConfiguration(config){if(config){if(config.changeableFor&&config.changeableFor.toHours()<72)throw new Error(`AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable, got ${config.changeableFor.toHours()} hours`);if(config.maxRetention){if(config.maxRetention.toDays()>36500)throw new Error(`The longest maximum retention period you can specify is 36500 days, got ${config.maxRetention.toDays()} days`);if(config.maxRetention.toDays()<=config.minRetention.toDays())throw new Error(`The maximum retention period (${config.maxRetention.toDays()} days) must be greater than the minimum retention period (${config.minRetention.toDays()} days)`)}if(config.minRetention.toHours()<24)throw new Error(`The shortest minimum retention period you can specify is 1 day, got ${config.minRetention.toHours()} hours`);return{minRetentionDays:config.minRetention.toDays(),maxRetentionDays:config.maxRetention?.toDays(),changeableForDays:config.changeableFor?.toDays()}}}
