"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayHttpApiEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const base_1 = require("./base");
/**
 * Call HTTP API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @stability stable
 */
class CallApiGatewayHttpApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_CallApiGatewayHttpApiEndpointProps(props);
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = this.getArnForExecuteApi();
        this.stageName = props.stageName;
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = this.props.apiStack;
        return `${this.props.apiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
    getArnForExecuteApi() {
        const { apiId, stageName, method, apiPath } = this.props;
        return this.props.apiStack.formatArn({
            service: 'execute-api',
            resource: apiId,
            arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
            resourceName: `${stageName}/${method}${apiPath}`,
        });
    }
}
exports.CallApiGatewayHttpApiEndpoint = CallApiGatewayHttpApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayHttpApiEndpoint[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallApiGatewayHttpApiEndpoint", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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