# coding: utf-8

"""
    TKG Kubernetes API

    This API provides to vCD tenants the means to provision (create and update) Tanzu Kubernetes Grid clusters. This is complementary to the defined-entity APIs:    GET /cloudapi/1.0.0/entities/urn:vcloud:entity:vmware.tkgcluster:1.0.0:{id} which allows to retrieve the clusters created by the API presented here. This is why you will not find here a GET operation for the corresponding entity.   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from container_service_extension.client.tkgclient.models.tkg_cluster_spec_distribution import TkgClusterSpecDistribution  # noqa: F401,E501
from container_service_extension.client.tkgclient.models.tkg_cluster_spec_settings import TkgClusterSpecSettings  # noqa: F401,E501
from container_service_extension.client.tkgclient.models.tkg_cluster_spec_topology import TkgClusterSpecTopology  # noqa: F401,E501


class TkgClusterSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'distribution': 'TkgClusterSpecDistribution',
        'settings': 'TkgClusterSpecSettings',
        'topology': 'TkgClusterSpecTopology'
    }

    attribute_map = {
        'distribution': 'distribution',
        'settings': 'settings',
        'topology': 'topology'
    }

    def __init__(self, distribution=None, settings=None, topology=None):  # noqa: E501
        """TkgClusterSpec - a model defined in Swagger"""  # noqa: E501

        self._distribution = None
        self._settings = None
        self._topology = None
        self.discriminator = None

        self.distribution = distribution
        if settings is not None:
            self.settings = settings
        self.topology = topology

    @property
    def distribution(self):
        """Gets the distribution of this TkgClusterSpec.  # noqa: E501


        :return: The distribution of this TkgClusterSpec.  # noqa: E501
        :rtype: TkgClusterSpecDistribution
        """
        return self._distribution

    @distribution.setter
    def distribution(self, distribution):
        """Sets the distribution of this TkgClusterSpec.


        :param distribution: The distribution of this TkgClusterSpec.  # noqa: E501
        :type: TkgClusterSpecDistribution
        """
        if distribution is None:
            raise ValueError("Invalid value for `distribution`, must not be `None`")  # noqa: E501

        self._distribution = distribution

    @property
    def settings(self):
        """Gets the settings of this TkgClusterSpec.  # noqa: E501


        :return: The settings of this TkgClusterSpec.  # noqa: E501
        :rtype: TkgClusterSpecSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this TkgClusterSpec.


        :param settings: The settings of this TkgClusterSpec.  # noqa: E501
        :type: TkgClusterSpecSettings
        """

        self._settings = settings

    @property
    def topology(self):
        """Gets the topology of this TkgClusterSpec.  # noqa: E501


        :return: The topology of this TkgClusterSpec.  # noqa: E501
        :rtype: TkgClusterSpecTopology
        """
        return self._topology

    @topology.setter
    def topology(self, topology):
        """Sets the topology of this TkgClusterSpec.


        :param topology: The topology of this TkgClusterSpec.  # noqa: E501
        :type: TkgClusterSpecTopology
        """
        if topology is None:
            raise ValueError("Invalid value for `topology`, must not be `None`")  # noqa: E501

        self._topology = topology

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TkgClusterSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
