# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyskoptimize']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.4.2,<2.0.0',
 'pydantic>=1.9.0,<2.0.0',
 'scikit-learn>=1.0.2,<2.0.0',
 'scikit-optimize>=0.9.0,<0.10.0',
 'scipy>=1.8.0,<2.0.0']

setup_kwargs = {
    'name': 'pyskoptimize',
    'version': '0.1.4',
    'description': 'A configuration driven approach to facilitating Bayesian Hyperparameter Tuning',
    'long_description': '# PySkOptimize\n\n## Introduction\n\nWelcome to PySkOptimize!\n\nThe goal of this package is to simply enable Data Scientists, Machine Learning Engineers, or\nthe curious Software Engineer, to develop highly optimized models using low-code.  By using \nPydantic, we were able to develop a methodology that will allow all to create `JSON` representations\nof their Machine Learning Pipeline and the hypyerparameters you want to optimize.  \n\nAs a note, it is imperative perform all feature engineering tasks, especially tasks that uses \ntransformers from `sklearn.preprocessing`, to include in the `JSON` representation.  This enables\nthe representing pipeline to have all of required steps so that it is easy to have a finalized \npipeline at the end.\n\nOne limitation is the inability to scale the tuning through the usage\nof Apache Spark\n\n## Installation\n\nIf you want to install a stable version, simply follow the command: `pip install pyskoptimize`.\n\nIf you want to install from source, please follow the directions under the **Developer Contribution** section.\n\n## Developer Contribution\n\nTo install from local development, run the following commands in order:\n\n    1. make init\n    2. make install\n\nTo add any new packages, follow the poetry requirements and add\nunit tests\n\n## Tutorial\n\nIt is quite easy.  The documentation of the classes and their needed arguments\nare found on https://wwww.pyscale.net/PySkOptimize.  \n\nFirst you develop a `JSON` file named `data.json` that resembles\n\n```json\n{\n  "targetTransformer": {\n    "name": "sklearn.preprocessing.PowerTransformer"\n  },\n  "model": {\n    "name": "sklearn.linear_model.ElasticNet",\n    "params": [\n      {\n        "name": "alpha",\n        "low": 1e-16,\n        "high": 1e16,\n        "log_scale": true\n      },\n      {\n        "name": "l1_ratio",\n        "low": 1e-10,\n        "high": 0.9999999999\n      }\n    ]\n  },\n  "scoring": "neg_mean_squared_error",\n  "preprocess": [\n    {\n      "name": "featurePod1",\n      "features": ["MedInc"],\n      "pipeline": [\n        {\n          "name": "sklearn.preprocessing.KBinsDiscretizer",\n          "params": [\n            {\n              "name": "n_bins",\n              "lowInt": 2,\n              "highInt": 99\n            }\n          ]\n        }\n      ]\n    },\n    {\n      "name": "featurePod2",\n      "features": ["HouseAge"],\n      "pipeline": [\n        {\n          "name": "sklearn.preprocessing.KBinsDiscretizer",\n          "params": [\n            {\n              "name": "n_bins",\n              "lowInt": 2,\n              "highInt": 99\n            }\n          ]\n        }\n      ]\n    },\n    {\n      "name": "featurePod3",\n      "features": ["AveRooms"],\n      "pipeline": [\n        {\n          "name": "sklearn.preprocessing.KBinsDiscretizer",\n          "params": [\n            {\n              "name": "n_bins",\n              "lowInt": 2,\n              "highInt": 99\n            }\n          ]\n        }\n      ]\n    },\n    {\n      "name": "featurePod4",\n      "features": ["Population"],\n      "pipeline": [\n        {\n          "name": "sklearn.preprocessing.KBinsDiscretizer",\n          "params": [\n            {\n              "name": "n_bins",\n              "lowInt": 2,\n              "highInt": 99\n            }\n          ]\n        }\n      ]\n    },\n    {\n      "name": "featurePod5",\n      "features": ["AveOccup"],\n      "pipeline": [\n        {\n          "name": "sklearn.preprocessing.KBinsDiscretizer",\n          "params": [\n            {\n              "name": "n_bins",\n              "lowInt": 2,\n              "highInt": 99\n            }\n          ]\n        }\n      ]\n    },\n    {\n      "name": "featurePod6",\n      "features": ["Latitude"],\n      "pipeline": [\n        {\n          "name": "sklearn.preprocessing.KBinsDiscretizer",\n          "params": [\n            {\n              "name": "n_bins",\n              "lowInt": 2,\n              "highInt": 99\n            }\n          ]\n        }\n      ]\n    },\n    {\n      "name": "featurePod7",\n      "features": ["Longitude"],\n      "pipeline": [\n        {\n          "name": "sklearn.preprocessing.KBinsDiscretizer",\n          "params": [\n            {\n              "name": "n_bins",\n              "lowInt": 2,\n              "highInt": 99\n            }\n          ]\n        }\n      ]\n    }\n  ]\n}\n```\n\nSecond, you create script that resembles\n\n```python\n\nfrom pyskoptimize.base import MLPipelineStateModel\n\nconfig = MLPipelineStateModel.parse_file("data.json")\n\n# lets assume you read in a dataset with the features and that dataset is df\n\ndf = ...\n\nbayes_opt = config.to_bayes_opt()\n\nbayes_opt.fit(df.drop("target"), df["target"])\n\n```\n\nThat is it!  You are done!  You now have created a Machine Learning model\nwith highly optimized parameters, tuned to your specific metrics.  \n\n### Vocabulary\n\nOne of the fundamental building blocks of this methodology lies within \nwhat we define:\n\n    1. Preprocessing\n    2. Post-processing\n    3. Model (or estimator)\n    4. Target Transformer\n\nEach of these points are extremely important for an end-to-end model in industry.\n\nThe **Preprocessing** includes an array of transformations taken on arrays of features,\nor a subset of those features.  For example, we want to standardize the price of an item\nwhile extract features from the description of an item.  These would involve two separate \ntransformations on two arrays of subset of features.  Instead of manually performing these\ntransformations separately, these can be embedded into the one singular object.  This is done\nthrough the `sklearn.compose.ColumnTransformer` object.  However, for more complicated transformations,\nyou may need to develop a `sklearn.pipeline.Pipeline` of transformations for a singular subset of \nfeatures.  Instead of developing the code specifically for that, just follow the example above in your\nconfiguration file and PySkOptimize will take care of the rest.  \n\nThe **Post-processing** includes an array of transformations taken on preprocessed features.  This is \nsimilar to preprocessing in concept, but the application is different.\n\nThe **Model** or the **Estimator** is how you would classically define.  Use anything from `sklearn` or from\n`xgboost.sklearn` or `lightgbm.sklearn`.  Just remember to include the full class path.\n\nThe **Target Transformer** enables the user to apply a transformation from `sklearn.preprocessing` to be \napplied onto the target variable(s) such that the model, followed by all preprocessing and post-processing, \nlearns the transformed target space.  An example is performing the log transformation on the target and training\nthe model on the log-transformed space.  This is preferred when you know the transformed space helps to preserve\nthe original space, which is the case of predicting the price of a home since the value of a home is non-negative.\n\nAnother requirement is the `scoring` parameter.  This is to evaluate the candidate models throughout the search.  \n\n',
    'author': 'ed-turner',
    'author_email': 'edward.turner@pyscale.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://www.pyscale.net/PySkOptimize/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.11',
}


setup(**setup_kwargs)
