# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt

class StartTrainingRequestAnomaly(BaseModel):
    axes: List[StrictInt] = Field(..., description="Which axes (indexes from DSP script) to include in the training set")
    cluster_count: Optional[StrictInt] = Field(None, alias="clusterCount", description="Number of clusters for K-means, or number of components for GMM")
    minimum_confidence_rating: float = Field(..., alias="minimumConfidenceRating", description="Minimum confidence rating required before tagging as anomaly")
    skip_embeddings_and_memory: Optional[StrictBool] = Field(None, alias="skipEmbeddingsAndMemory", description="If set, skips creating embeddings and measuring memory (used in tests)")
    __properties = ["axes", "clusterCount", "minimumConfidenceRating", "skipEmbeddingsAndMemory"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> StartTrainingRequestAnomaly:
        """Create an instance of StartTrainingRequestAnomaly from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StartTrainingRequestAnomaly:
        """Create an instance of StartTrainingRequestAnomaly from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StartTrainingRequestAnomaly.construct(**obj)

        _obj = StartTrainingRequestAnomaly.construct(**{
            "axes": obj.get("axes"),
            "cluster_count": obj.get("clusterCount"),
            "minimum_confidence_rating": obj.get("minimumConfidenceRating"),
            "skip_embeddings_and_memory": obj.get("skipEmbeddingsAndMemory")
        })
        return _obj

