# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr

class StartPerformanceCalibrationRequest(BaseModel):
    background_noise_label: StrictStr = Field(..., alias="backgroundNoiseLabel", description="The label used to signify background noise in the impulse")
    other_noise_labels: Optional[List[StrictStr]] = Field(None, alias="otherNoiseLabels", description="Any other labels that should be considered equivalent to background noise")
    upload_key: Optional[StrictStr] = Field(None, alias="uploadKey", description="The key of an uploaded sample. If not present, a synthetic sample will be created.")
    sample_length_minutes: Optional[float] = Field(None, alias="sampleLengthMinutes", description="The length of sample to create (required for synthetic samples)")
    __properties = ["backgroundNoiseLabel", "otherNoiseLabels", "uploadKey", "sampleLengthMinutes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> StartPerformanceCalibrationRequest:
        """Create an instance of StartPerformanceCalibrationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StartPerformanceCalibrationRequest:
        """Create an instance of StartPerformanceCalibrationRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StartPerformanceCalibrationRequest.construct(**obj)

        _obj = StartPerformanceCalibrationRequest.construct(**{
            "background_noise_label": obj.get("backgroundNoiseLabel"),
            "other_noise_labels": obj.get("otherNoiseLabels"),
            "upload_key": obj.get("uploadKey"),
            "sample_length_minutes": obj.get("sampleLengthMinutes")
        })
        return _obj

