# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.bounding_box import BoundingBox
from edgeimpulse_api.models.sample_image_dimensions import SampleImageDimensions
from edgeimpulse_api.models.sensor import Sensor
from edgeimpulse_api.models.structured_label import StructuredLabel

class Sample(BaseModel):
    id: StrictInt = ...
    filename: StrictStr = ...
    signature_validate: StrictBool = Field(..., alias="signatureValidate", description="Whether signature validation passed")
    signature_method: Optional[StrictStr] = Field(None, alias="signatureMethod")
    signature_key: Optional[StrictStr] = Field(None, alias="signatureKey", description="Either the shared key or the public key that was used to validate the sample")
    created: datetime = Field(..., description="Timestamp when the sample was created on device, or if no accurate time was known on device, the time that the file was processed by the ingestion service.")
    last_modified: datetime = Field(..., alias="lastModified", description="Timestamp when the sample was last modified.")
    category: StrictStr = ...
    coldstorage_filename: StrictStr = Field(..., alias="coldstorageFilename")
    label: StrictStr = ...
    interval_ms: float = Field(..., alias="intervalMs", description="Interval between two windows (1000 / frequency). If the data was resampled, then this lists the resampled interval.")
    frequency: float = Field(..., description="Frequency of the sample. If the data was resampled, then this lists the resampled frequency.")
    original_interval_ms: float = Field(..., alias="originalIntervalMs", description="Interval between two windows (1000 / frequency) in the source data (before resampling).")
    original_frequency: float = Field(..., alias="originalFrequency", description="Frequency of the sample in the source data (before resampling).")
    device_name: Optional[StrictStr] = Field(None, alias="deviceName")
    device_type: StrictStr = Field(..., alias="deviceType")
    sensors: List[Sensor] = ...
    values_count: StrictInt = Field(..., alias="valuesCount", description="Number of readings in this file")
    total_length_ms: Optional[float] = Field(None, alias="totalLengthMs", description="Total length (in ms.) of this file")
    added: datetime = Field(..., description="Timestamp when the sample was added to the current acquisition bucket.")
    bounding_boxes: List[BoundingBox] = Field(..., alias="boundingBoxes")
    bounding_boxes_type: StrictStr = Field(..., alias="boundingBoxesType")
    chart_type: StrictStr = Field(..., alias="chartType")
    thumbnail_video: Optional[StrictStr] = Field(None, alias="thumbnailVideo")
    thumbnail_video_full: Optional[StrictStr] = Field(None, alias="thumbnailVideoFull")
    is_disabled: StrictBool = Field(..., alias="isDisabled", description="True if the current sample is excluded from use")
    is_processing: StrictBool = Field(..., alias="isProcessing", description="True if the current sample is still processing (e.g. for video)")
    processing_job_id: Optional[StrictInt] = Field(None, alias="processingJobId", description="Set when sample is processing and a job has picked up the request")
    processing_error: StrictBool = Field(..., alias="processingError", description="Set when processing this sample failed")
    processing_error_string: Optional[StrictStr] = Field(None, alias="processingErrorString", description="Error (only set when processing this sample failed)")
    is_cropped: StrictBool = Field(..., alias="isCropped", description="Whether the sample is cropped from another sample (and has crop start / end info)")
    metadata: Optional[Dict[str, StrictStr]] = Field(None, description="Sample free form associated metadata")
    project_id: StrictInt = Field(..., alias="projectId", description="Unique identifier of the project this sample belongs to")
    project_owner_name: Optional[StrictStr] = Field(None, alias="projectOwnerName", description="Name of the owner of the project this sample belongs to")
    project_name: Optional[StrictStr] = Field(None, alias="projectName", description="Name of the project this sample belongs to")
    project_labeling_method: Optional[StrictStr] = Field(None, alias="projectLabelingMethod", description="What labeling flow the project this sample belongs to uses")
    sha256_hash: StrictStr = Field(..., alias="sha256Hash", description="Data sample SHA 256 hash (including CBOR envelope if applicable)")
    structured_labels: Optional[List[StructuredLabel]] = Field(None, alias="structuredLabels")
    structured_labels_list: Optional[List[StrictStr]] = Field(None, alias="structuredLabelsList")
    created_by_synthetic_data_job_id: Optional[StrictInt] = Field(None, alias="createdBySyntheticDataJobId", description="If this sample was created by a synthetic data job, it's referenced here.")
    image_dimensions: Optional[SampleImageDimensions] = Field(None, alias="imageDimensions")
    __properties = ["id", "filename", "signatureValidate", "signatureMethod", "signatureKey", "created", "lastModified", "category", "coldstorageFilename", "label", "intervalMs", "frequency", "originalIntervalMs", "originalFrequency", "deviceName", "deviceType", "sensors", "valuesCount", "totalLengthMs", "added", "boundingBoxes", "boundingBoxesType", "chartType", "thumbnailVideo", "thumbnailVideoFull", "isDisabled", "isProcessing", "processingJobId", "processingError", "processingErrorString", "isCropped", "metadata", "projectId", "projectOwnerName", "projectName", "projectLabelingMethod", "sha256Hash", "structuredLabels", "structuredLabelsList", "createdBySyntheticDataJobId", "imageDimensions"]

    @validator('bounding_boxes_type')
    def bounding_boxes_type_validate_enum(cls, v):
        if v not in ('object_detection', 'constrained_object_detection'):
            raise ValueError("must validate the enum values ('object_detection', 'constrained_object_detection')")
        return v

    @validator('chart_type')
    def chart_type_validate_enum(cls, v):
        if v not in ('chart', 'image', 'video', 'table'):
            raise ValueError("must validate the enum values ('chart', 'image', 'video', 'table')")
        return v

    @validator('project_labeling_method')
    def project_labeling_method_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('single_label', 'object_detection'):
            raise ValueError("must validate the enum values ('single_label', 'object_detection')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> Sample:
        """Create an instance of Sample from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in sensors (list)
        _items = []
        if self.sensors:
            for _item in self.sensors:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sensors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bounding_boxes (list)
        _items = []
        if self.bounding_boxes:
            for _item in self.bounding_boxes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['boundingBoxes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in structured_labels (list)
        _items = []
        if self.structured_labels:
            for _item in self.structured_labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['structuredLabels'] = _items
        # override the default output from pydantic by calling `to_dict()` of image_dimensions
        if self.image_dimensions:
            _dict['imageDimensions'] = self.image_dimensions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Sample:
        """Create an instance of Sample from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Sample.construct(**obj)

        _obj = Sample.construct(**{
            "id": obj.get("id"),
            "filename": obj.get("filename"),
            "signature_validate": obj.get("signatureValidate"),
            "signature_method": obj.get("signatureMethod"),
            "signature_key": obj.get("signatureKey"),
            "created": obj.get("created"),
            "last_modified": obj.get("lastModified"),
            "category": obj.get("category"),
            "coldstorage_filename": obj.get("coldstorageFilename"),
            "label": obj.get("label"),
            "interval_ms": obj.get("intervalMs"),
            "frequency": obj.get("frequency"),
            "original_interval_ms": obj.get("originalIntervalMs"),
            "original_frequency": obj.get("originalFrequency"),
            "device_name": obj.get("deviceName"),
            "device_type": obj.get("deviceType"),
            "sensors": [Sensor.from_dict(_item) for _item in obj.get("sensors")] if obj.get("sensors") is not None else None,
            "values_count": obj.get("valuesCount"),
            "total_length_ms": obj.get("totalLengthMs"),
            "added": obj.get("added"),
            "bounding_boxes": [BoundingBox.from_dict(_item) for _item in obj.get("boundingBoxes")] if obj.get("boundingBoxes") is not None else None,
            "bounding_boxes_type": obj.get("boundingBoxesType"),
            "chart_type": obj.get("chartType"),
            "thumbnail_video": obj.get("thumbnailVideo"),
            "thumbnail_video_full": obj.get("thumbnailVideoFull"),
            "is_disabled": obj.get("isDisabled"),
            "is_processing": obj.get("isProcessing"),
            "processing_job_id": obj.get("processingJobId"),
            "processing_error": obj.get("processingError"),
            "processing_error_string": obj.get("processingErrorString"),
            "is_cropped": obj.get("isCropped"),
            "metadata": obj.get("metadata"),
            "project_id": obj.get("projectId"),
            "project_owner_name": obj.get("projectOwnerName"),
            "project_name": obj.get("projectName"),
            "project_labeling_method": obj.get("projectLabelingMethod"),
            "sha256_hash": obj.get("sha256Hash"),
            "structured_labels": [StructuredLabel.from_dict(_item) for _item in obj.get("structuredLabels")] if obj.get("structuredLabels") is not None else None,
            "structured_labels_list": obj.get("structuredLabelsList"),
            "created_by_synthetic_data_job_id": obj.get("createdBySyntheticDataJobId"),
            "image_dimensions": SampleImageDimensions.from_dict(obj.get("imageDimensions")) if obj.get("imageDimensions") is not None else None
        })
        return _obj

