# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.project_public_data_readme import ProjectPublicDataReadme
from edgeimpulse_api.models.project_type import ProjectType

class ProjectPublicData(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    description: StrictStr = ...
    created: datetime = ...
    owner: StrictStr = Field(..., description="User or organization that owns the project")
    owner_avatar: Optional[StrictStr] = Field(None, alias="ownerAvatar", description="URL to the project owner avatar, if any")
    public_url: StrictStr = Field(..., alias="publicUrl", description="URL of the latest public version of the project, if any")
    project_type: ProjectType = Field(..., alias="projectType")
    page_view_count: StrictInt = Field(..., alias="pageViewCount")
    clone_count: StrictInt = Field(..., alias="cloneCount")
    total_samples_count: Optional[StrictStr] = Field(None, alias="totalSamplesCount")
    training_accuracy: Optional[float] = Field(None, alias="trainingAccuracy", description="Accuracy on training set.")
    test_accuracy: Optional[float] = Field(None, alias="testAccuracy", description="Accuracy on test set.")
    readme: Optional[ProjectPublicDataReadme] = None
    tags: List[StrictStr] = Field(..., description="List of project tags")
    __properties = ["id", "name", "description", "created", "owner", "ownerAvatar", "publicUrl", "projectType", "pageViewCount", "cloneCount", "totalSamplesCount", "trainingAccuracy", "testAccuracy", "readme", "tags"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ProjectPublicData:
        """Create an instance of ProjectPublicData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of readme
        if self.readme:
            _dict['readme'] = self.readme.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectPublicData:
        """Create an instance of ProjectPublicData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ProjectPublicData.construct(**obj)

        _obj = ProjectPublicData.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "created": obj.get("created"),
            "owner": obj.get("owner"),
            "owner_avatar": obj.get("ownerAvatar"),
            "public_url": obj.get("publicUrl"),
            "project_type": obj.get("projectType"),
            "page_view_count": obj.get("pageViewCount"),
            "clone_count": obj.get("cloneCount"),
            "total_samples_count": obj.get("totalSamplesCount"),
            "training_accuracy": obj.get("trainingAccuracy"),
            "test_accuracy": obj.get("testAccuracy"),
            "readme": ProjectPublicDataReadme.from_dict(obj.get("readme")) if obj.get("readme") is not None else None,
            "tags": obj.get("tags")
        })
        return _obj

