# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.project_collaborator import ProjectCollaborator
from edgeimpulse_api.models.project_tier_enum import ProjectTierEnum

class Project(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    description: StrictStr = ...
    created: datetime = ...
    owner: StrictStr = Field(..., description="User or organization that owns the project")
    last_accessed: Optional[datetime] = Field(None, alias="lastAccessed")
    last_modified: Optional[datetime] = Field(None, alias="lastModified")
    last_modification_details: Optional[StrictStr] = Field(None, alias="lastModificationDetails", description="Details about the last modification")
    logo: Optional[StrictStr] = Field(None, description="Custom logo for this project (not available for all projects)")
    owner_user_id: Optional[StrictInt] = Field(None, alias="ownerUserId")
    owner_organization_id: Optional[StrictInt] = Field(None, alias="ownerOrganizationId")
    owner_avatar: Optional[StrictStr] = Field(None, alias="ownerAvatar", description="URL of the project owner avatar, if any.")
    owner_is_developer_profile: StrictBool = Field(..., alias="ownerIsDeveloperProfile")
    developer_profile_user_id: Optional[StrictInt] = Field(None, alias="developerProfileUserId", description="User ID of the developer profile, if any.")
    collaborators: List[ProjectCollaborator] = ...
    labeling_method: StrictStr = Field(..., alias="labelingMethod")
    metadata: Dict[str, Any] = Field(..., description="Metadata about the project")
    data_explorer_screenshot: Optional[StrictStr] = Field(None, alias="dataExplorerScreenshot")
    is_enterprise_project: StrictBool = Field(..., alias="isEnterpriseProject", description="Whether this is an enterprise project")
    whitelabel_id: Optional[StrictInt] = Field(..., alias="whitelabelId", description="Unique identifier of the white label this project belongs to, if any.")
    tags: Optional[List[StrictStr]] = Field(None, description="List of project tags")
    category: Optional[StrictStr] = Field(None, description="Project category")
    license: Optional[StrictStr] = Field(None, description="Public project license, if any.")
    tier: ProjectTierEnum = ...
    has_public_version: StrictBool = Field(..., alias="hasPublicVersion", description="Whether this project has been published or not.")
    is_public: StrictBool = Field(..., alias="isPublic", description="Whether this is a public version of a project. A version is a snapshot of a project at a certain point in time, which can be used to periodically save the state of a project. Versions can be private (just for internal use and reference) or public, available to everyone. A public version can be cloned by anyone, restoring the state of the project at the time into a new, separate project. ")
    allows_live_public_access: StrictBool = Field(..., alias="allowsLivePublicAccess", description="Whether this project allows live, public access. Unlike a public version, a live public project is not fixed in time, and always includes the latest project changes. Similar to public versions, a live public project can be cloned by anyone, creating a new, separate project. ")
    ind_pause_processing_samples: StrictBool = Field(..., alias="indPauseProcessingSamples")
    public_project_listed: StrictBool = Field(..., alias="publicProjectListed", description="If the project allows public access, whether to list it the public projects overview response. If not listed, the project is still accessible via direct link. If the project does not allow public access, this field has no effect. ")
    __properties = ["id", "name", "description", "created", "owner", "lastAccessed", "lastModified", "lastModificationDetails", "logo", "ownerUserId", "ownerOrganizationId", "ownerAvatar", "ownerIsDeveloperProfile", "developerProfileUserId", "collaborators", "labelingMethod", "metadata", "dataExplorerScreenshot", "isEnterpriseProject", "whitelabelId", "tags", "category", "license", "tier", "hasPublicVersion", "isPublic", "allowsLivePublicAccess", "indPauseProcessingSamples", "publicProjectListed"]

    @validator('labeling_method')
    def labeling_method_validate_enum(cls, v):
        if v not in ('single_label', 'object_detection'):
            raise ValueError("must validate the enum values ('single_label', 'object_detection')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> Project:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in collaborators (list)
        _items = []
        if self.collaborators:
            for _item in self.collaborators:
                if _item:
                    _items.append(_item.to_dict())
            _dict['collaborators'] = _items
        # set to None if whitelabel_id (nullable) is None
        if self.whitelabel_id is None:
            _dict['whitelabelId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Project:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Project.construct(**obj)

        _obj = Project.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "created": obj.get("created"),
            "owner": obj.get("owner"),
            "last_accessed": obj.get("lastAccessed"),
            "last_modified": obj.get("lastModified"),
            "last_modification_details": obj.get("lastModificationDetails"),
            "logo": obj.get("logo"),
            "owner_user_id": obj.get("ownerUserId"),
            "owner_organization_id": obj.get("ownerOrganizationId"),
            "owner_avatar": obj.get("ownerAvatar"),
            "owner_is_developer_profile": obj.get("ownerIsDeveloperProfile"),
            "developer_profile_user_id": obj.get("developerProfileUserId"),
            "collaborators": [ProjectCollaborator.from_dict(_item) for _item in obj.get("collaborators")] if obj.get("collaborators") is not None else None,
            "labeling_method": obj.get("labelingMethod"),
            "metadata": obj.get("metadata"),
            "data_explorer_screenshot": obj.get("dataExplorerScreenshot"),
            "is_enterprise_project": obj.get("isEnterpriseProject"),
            "whitelabel_id": obj.get("whitelabelId"),
            "tags": obj.get("tags"),
            "category": obj.get("category"),
            "license": obj.get("license"),
            "tier": obj.get("tier"),
            "has_public_version": obj.get("hasPublicVersion"),
            "is_public": obj.get("isPublic"),
            "allows_live_public_access": obj.get("allowsLivePublicAccess"),
            "ind_pause_processing_samples": obj.get("indPauseProcessingSamples"),
            "public_project_listed": obj.get("publicProjectListed")
        })
        return _obj

