# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.deployment_target_engine import DeploymentTargetEngine
from edgeimpulse_api.models.keras_model_type_enum import KerasModelTypeEnum

class GetLastDeploymentBuildResponseAllOfLastBuild(BaseModel):
    version: StrictInt = Field(..., description="The build version, incremented after each deployment build")
    deployment_type: StrictStr = Field(..., alias="deploymentType", description="Deployment type of the build")
    engine: DeploymentTargetEngine = ...
    model_type: Optional[KerasModelTypeEnum] = Field(None, alias="modelType")
    created: datetime = Field(..., description="The time this build was created")
    __properties = ["version", "deploymentType", "engine", "modelType", "created"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> GetLastDeploymentBuildResponseAllOfLastBuild:
        """Create an instance of GetLastDeploymentBuildResponseAllOfLastBuild from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetLastDeploymentBuildResponseAllOfLastBuild:
        """Create an instance of GetLastDeploymentBuildResponseAllOfLastBuild from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetLastDeploymentBuildResponseAllOfLastBuild.construct(**obj)

        _obj = GetLastDeploymentBuildResponseAllOfLastBuild.construct(**{
            "version": obj.get("version"),
            "deployment_type": obj.get("deploymentType"),
            "engine": obj.get("engine"),
            "model_type": obj.get("modelType"),
            "created": obj.get("created")
        })
        return _obj

