# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.project_tier_enum import ProjectTierEnum
from edgeimpulse_api.models.project_type import ProjectType

class AdminApiProject(BaseModel):
    id: StrictInt = ...
    name: StrictStr = ...
    description: Optional[StrictStr] = None
    created: Optional[datetime] = None
    owner: StrictStr = Field(..., description="User or organization that owns the project")
    owner_user_id: Optional[StrictInt] = Field(None, alias="ownerUserId")
    owner_organization_id: Optional[StrictInt] = Field(None, alias="ownerOrganizationId")
    last_accessed: Optional[datetime] = Field(None, alias="lastAccessed")
    whitelabel_id: Optional[StrictInt] = Field(None, alias="whitelabelId", description="Unique identifier of the white label this project belongs to, if any.")
    tier: Optional[ProjectTierEnum] = None
    category: Optional[ProjectType] = None
    __properties = ["id", "name", "description", "created", "owner", "ownerUserId", "ownerOrganizationId", "lastAccessed", "whitelabelId", "tier", "category"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AdminApiProject:
        """Create an instance of AdminApiProject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if whitelabel_id (nullable) is None
        if self.whitelabel_id is None:
            _dict['whitelabelId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminApiProject:
        """Create an instance of AdminApiProject from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AdminApiProject.construct(**obj)

        _obj = AdminApiProject.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "created": obj.get("created"),
            "owner": obj.get("owner"),
            "owner_user_id": obj.get("ownerUserId"),
            "owner_organization_id": obj.get("ownerOrganizationId"),
            "last_accessed": obj.get("lastAccessed"),
            "whitelabel_id": obj.get("whitelabelId"),
            "tier": obj.get("tier"),
            "category": obj.get("category")
        })
        return _obj

